/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.LongCollection;
import com.carrotsearch.hppcrt.LongLookupContainer;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import java.util.Arrays;

public abstract class AbstractLongCollection
implements LongCollection {
    protected LongLookupContainer testContainer;
    protected LongPredicate testPredicate;
    protected LongPredicate containsTestPredicate = new LongPredicate(){

        public final boolean apply(long k) {
            return AbstractLongCollection.this.testContainer.contains(k);
        }
    };
    protected LongPredicate containsNegateTestPredicate = new LongPredicate(){

        public final boolean apply(long k) {
            return !AbstractLongCollection.this.testContainer.contains(k);
        }
    };
    protected LongPredicate negatePredicate = new LongPredicate(){

        public final boolean apply(long k) {
            return !AbstractLongCollection.this.testPredicate.apply(k);
        }
    };

    public int removeAll(LongLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    public int retainAll(LongLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    public int retainAll(LongPredicate predicate) {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

    public long[] toArray(long[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        int i = 0;
        for (LongCursor c : this) {
            target[i++] = c.value;
        }
        return target;
    }

    public long[] toArray() {
        try {
            return this.toArray(new long[this.size()]);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate a '%s'.toArray() of  %d elements", (Throwable)e, this.getClass().toString(), this.size());
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

