/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractCharCollection;
import com.carrotsearch.hppcrt.AbstractDoubleCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.CharArrays;
import com.carrotsearch.hppcrt.CharContainer;
import com.carrotsearch.hppcrt.CharDoubleAssociativeContainer;
import com.carrotsearch.hppcrt.CharDoubleMap;
import com.carrotsearch.hppcrt.CharLookupContainer;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.CharCursor;
import com.carrotsearch.hppcrt.cursors.CharDoubleCursor;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.CharDoublePredicate;
import com.carrotsearch.hppcrt.predicates.CharPredicate;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import com.carrotsearch.hppcrt.procedures.CharDoubleProcedure;
import com.carrotsearch.hppcrt.procedures.CharProcedure;
import com.carrotsearch.hppcrt.procedures.DoubleProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharDoubleHashMap
implements CharDoubleMap,
Cloneable {
    protected double defaultValue = 0.0;
    public char[] keys;
    public double[] values;
    public boolean allocatedDefaultKey = false;
    public double allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<CharDoubleCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = CharDoubleHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public CharDoubleHashMap() {
        this(8);
    }

    public CharDoubleHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public CharDoubleHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public CharDoubleHashMap(CharDoubleAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public double put(char key, double value) {
        char existing;
        if (key == '\u0000') {
            if (this.allocatedDefaultKey) {
                double previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                double oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(CharDoubleAssociativeContainer container) {
        return this.putAll((Iterable<? extends CharDoubleCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends CharDoubleCursor> iterable) {
        int count = this.size();
        for (CharDoubleCursor charDoubleCursor : iterable) {
            this.put(charDoubleCursor.key, charDoubleCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(char key, double value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(char key, double putValue, double incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public double addTo(char key, double incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(char pendingKey, double pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != '\u0000');
        char[] oldKeys = this.keys;
        double[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        char key = '\u0000';
        double value = 0.0;
        int slot = -1;
        char[] keys = this.keys;
        double[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == '\u0000') continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            char[] keys = new char[capacity];
            double[] values = new double[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public double remove(char key) {
        char existing;
        if (key == '\u0000') {
            if (this.allocatedDefaultKey) {
                double previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                double value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        double[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            char existing = keys[slot];
            double existingValue = values[slot];
            if (existing == '\u0000') break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        --this.assigned;
    }

    @Override
    public int removeAll(CharContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof CharLookupContainer) {
            if (this.allocatedDefaultKey && other.contains('\u0000')) {
                this.allocatedDefaultKey = false;
            }
            char[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                char existing = keys[i];
                if (existing != '\u0000' && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (CharCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply('\u0000')) {
            this.allocatedDefaultKey = false;
        }
        char[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            char existing = keys[i];
            if (existing != '\u0000' && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(CharDoublePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply('\u0000', this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        char[] keys = this.keys;
        double[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            char existing = keys[i];
            if (existing != '\u0000' && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public double get(char key) {
        char existing;
        if (key == '\u0000') {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(char key) {
        char existing;
        if (key == '\u0000') {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        CharArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        char[] keys = this.keys;
        double[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            char existing = keys[i];
            if (existing == '\u0000') continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            CharDoubleHashMap other = (CharDoubleHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                CharDoubleCursor c = (CharDoubleCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                double otherValue = other.get(c.key);
                if (Double.doubleToLongBits(c.value) == Double.doubleToLongBits(otherValue)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends CharDoubleProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply('\u0000', this.allocatedDefaultKeyValue);
        }
        char[] keys = this.keys;
        double[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char existing = keys[i];
            if (existing == '\u0000') continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends CharDoublePredicate> T forEach(T predicate) {
        char existing;
        if (this.allocatedDefaultKey && !predicate.apply('\u0000', this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        char[] keys = this.keys;
        double[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == '\u0000' || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public CharDoubleHashMap clone() {
        CharDoubleHashMap cloned = new CharDoubleHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharDoubleCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static CharDoubleHashMap from(char[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharDoubleHashMap map = new CharDoubleHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static CharDoubleHashMap from(CharDoubleAssociativeContainer container) {
        return new CharDoubleHashMap(container);
    }

    public static CharDoubleHashMap newInstance() {
        return new CharDoubleHashMap();
    }

    public static CharDoubleHashMap newInstance(int initialCapacity, double loadFactor) {
        return new CharDoubleHashMap(initialCapacity, loadFactor);
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            if (this.cursor.index == CharDoubleHashMap.this.values.length + 1) {
                if (CharDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = CharDoubleHashMap.this.values.length;
                    this.cursor.value = CharDoubleHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = CharDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && CharDoubleHashMap.this.keys[i] == '\u0000'; --i) {
            }
            if (i == -1) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharDoubleHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractDoubleCollection {
        private final CharDoubleHashMap owner;
        protected final IteratorPool<DoubleCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = CharDoubleHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = CharDoubleHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(double value) {
            if (this.owner.allocatedDefaultKey && Double.doubleToLongBits(value) == Double.doubleToLongBits(this.owner.allocatedDefaultKeyValue)) {
                return true;
            }
            char[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == '\u0000' || Double.doubleToLongBits(value) != Double.doubleToLongBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            char[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == '\u0000') continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            char[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == '\u0000' || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(double e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && Double.doubleToLongBits(e) == Double.doubleToLongBits(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            char[] keys = this.owner.keys;
            double[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != '\u0000' && Double.doubleToLongBits(e) == Double.doubleToLongBits(values[slot])) {
                    CharDoubleHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            char[] keys = this.owner.keys;
            double[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != '\u0000' && predicate.apply(values[slot])) {
                    CharDoubleHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public double[] toArray(double[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            char[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == '\u0000') continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<CharCursor> {
        public final CharCursor cursor = new CharCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            if (this.cursor.index == CharDoubleHashMap.this.keys.length + 1) {
                if (CharDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = CharDoubleHashMap.this.keys.length;
                    this.cursor.value = '\u0000';
                    return this.cursor;
                }
                this.cursor.index = CharDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && CharDoubleHashMap.this.keys[i] == '\u0000'; --i) {
            }
            if (i == -1) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharDoubleHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharDoubleHashMap owner;
        protected final IteratorPool<CharCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = CharDoubleHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = CharDoubleHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(char e) {
            return CharDoubleHashMap.this.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply('\u0000');
            }
            char[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                char existing = keys[i];
                if (existing == '\u0000') continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            char existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply('\u0000')) {
                return predicate;
            }
            char[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == '\u0000' || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(char e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public char[] toArray(char[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = '\u0000';
            }
            char[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                char existing = keys[i];
                if (existing == '\u0000') continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<CharDoubleCursor> {
        public final CharDoubleCursor cursor = new CharDoubleCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected CharDoubleCursor fetch() {
            int i;
            if (this.cursor.index == CharDoubleHashMap.this.keys.length + 1) {
                if (CharDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = CharDoubleHashMap.this.keys.length;
                    this.cursor.key = '\u0000';
                    this.cursor.value = CharDoubleHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = CharDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && CharDoubleHashMap.this.keys[i] == '\u0000'; --i) {
            }
            if (i == -1) {
                return (CharDoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = CharDoubleHashMap.this.keys[i];
            this.cursor.value = CharDoubleHashMap.this.values[i];
            return this.cursor;
        }
    }
}

