/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractDoubleCollection;
import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.FloatArrays;
import com.carrotsearch.hppcrt.FloatContainer;
import com.carrotsearch.hppcrt.FloatDoubleAssociativeContainer;
import com.carrotsearch.hppcrt.FloatDoubleMap;
import com.carrotsearch.hppcrt.FloatLookupContainer;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.cursors.FloatDoubleCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import com.carrotsearch.hppcrt.predicates.FloatDoublePredicate;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.procedures.DoubleProcedure;
import com.carrotsearch.hppcrt.procedures.FloatDoubleProcedure;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatDoubleHashMap
implements FloatDoubleMap,
Cloneable {
    protected double defaultValue = 0.0;
    public float[] keys;
    public double[] values;
    public boolean allocatedDefaultKey = false;
    public double allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<FloatDoubleCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = FloatDoubleHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public FloatDoubleHashMap() {
        this(8);
    }

    public FloatDoubleHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public FloatDoubleHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public FloatDoubleHashMap(FloatDoubleAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public double put(float key, double value) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                double previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                double oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(FloatDoubleAssociativeContainer container) {
        return this.putAll((Iterable<? extends FloatDoubleCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends FloatDoubleCursor> iterable) {
        int count = this.size();
        for (FloatDoubleCursor floatDoubleCursor : iterable) {
            this.put(floatDoubleCursor.key, floatDoubleCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(float key, double value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(float key, double putValue, double incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public double addTo(float key, double incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(float pendingKey, double pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (Float.floatToIntBits(pendingKey) != 0);
        float[] oldKeys = this.keys;
        double[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        float key = 0.0f;
        double value = 0.0;
        int slot = -1;
        float[] keys = this.keys;
        double[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (Float.floatToIntBits(key) == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (Float.floatToIntBits(keys[slot]) != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            float[] keys = new float[capacity];
            double[] values = new double[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public double remove(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                double previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                double value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        double[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            float existing = keys[slot];
            double existingValue = values[slot];
            if (Float.floatToIntBits(existing) == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0f;
        --this.assigned;
    }

    @Override
    public int removeAll(FloatContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof FloatLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0.0f)) {
                this.allocatedDefaultKey = false;
            }
            float[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                float existing = keys[i];
                if (Float.floatToIntBits(existing) != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (FloatCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(FloatPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0f)) {
            this.allocatedDefaultKey = false;
        }
        float[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            float existing = keys[i];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(FloatDoublePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0f, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        float[] keys = this.keys;
        double[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            float existing = keys[i];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public double get(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        FloatArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        float[] keys = this.keys;
        double[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            float existing = keys[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            FloatDoubleHashMap other = (FloatDoubleHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                FloatDoubleCursor c = (FloatDoubleCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                double otherValue = other.get(c.key);
                if (Double.doubleToLongBits(c.value) == Double.doubleToLongBits(otherValue)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends FloatDoubleProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0.0f, this.allocatedDefaultKeyValue);
        }
        float[] keys = this.keys;
        double[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            float existing = keys[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends FloatDoublePredicate> T forEach(T predicate) {
        float existing;
        if (this.allocatedDefaultKey && !predicate.apply(0.0f, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        float[] keys = this.keys;
        double[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && (Float.floatToIntBits(existing = keys[i]) == 0 || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public FloatDoubleHashMap clone() {
        FloatDoubleHashMap cloned = new FloatDoubleHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (FloatDoubleCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static FloatDoubleHashMap from(float[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatDoubleHashMap map = new FloatDoubleHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static FloatDoubleHashMap from(FloatDoubleAssociativeContainer container) {
        return new FloatDoubleHashMap(container);
    }

    public static FloatDoubleHashMap newInstance() {
        return new FloatDoubleHashMap();
    }

    public static FloatDoubleHashMap newInstance(int initialCapacity, double loadFactor) {
        return new FloatDoubleHashMap(initialCapacity, loadFactor);
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            if (this.cursor.index == FloatDoubleHashMap.this.values.length + 1) {
                if (FloatDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = FloatDoubleHashMap.this.values.length;
                    this.cursor.value = FloatDoubleHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = FloatDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatDoubleHashMap.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatDoubleHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractDoubleCollection {
        private final FloatDoubleHashMap owner;
        protected final IteratorPool<DoubleCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = FloatDoubleHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = FloatDoubleHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(double value) {
            if (this.owner.allocatedDefaultKey && Double.doubleToLongBits(value) == Double.doubleToLongBits(this.owner.allocatedDefaultKeyValue)) {
                return true;
            }
            float[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Float.floatToIntBits(keys[slot]) == 0 || Double.doubleToLongBits(value) != Double.doubleToLongBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            float[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Float.floatToIntBits(keys[slot]) == 0) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            float[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (Float.floatToIntBits(keys[slot]) == 0 || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(double e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && Double.doubleToLongBits(e) == Double.doubleToLongBits(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            float[] keys = this.owner.keys;
            double[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Float.floatToIntBits(keys[slot]) != 0 && Double.doubleToLongBits(e) == Double.doubleToLongBits(values[slot])) {
                    FloatDoubleHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            float[] keys = this.owner.keys;
            double[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Float.floatToIntBits(keys[slot]) != 0 && predicate.apply(values[slot])) {
                    FloatDoubleHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public double[] toArray(double[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            float[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (Float.floatToIntBits(keys[i]) == 0) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            if (this.cursor.index == FloatDoubleHashMap.this.keys.length + 1) {
                if (FloatDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = FloatDoubleHashMap.this.keys.length;
                    this.cursor.value = 0.0f;
                    return this.cursor;
                }
                this.cursor.index = FloatDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatDoubleHashMap.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatDoubleHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractFloatCollection
    implements FloatLookupContainer {
        private final FloatDoubleHashMap owner;
        protected final IteratorPool<FloatCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = FloatDoubleHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = FloatDoubleHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(float e) {
            return FloatDoubleHashMap.this.containsKey(e);
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0.0f);
            }
            float[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                float existing = keys[i];
                if (Float.floatToIntBits(existing) == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            float existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0.0f)) {
                return predicate;
            }
            float[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && (Float.floatToIntBits(existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(float e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public float[] toArray(float[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0.0f;
            }
            float[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                float existing = keys[i];
                if (Float.floatToIntBits(existing) == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<FloatDoubleCursor> {
        public final FloatDoubleCursor cursor = new FloatDoubleCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatDoubleCursor fetch() {
            int i;
            if (this.cursor.index == FloatDoubleHashMap.this.keys.length + 1) {
                if (FloatDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = FloatDoubleHashMap.this.keys.length;
                    this.cursor.key = 0.0f;
                    this.cursor.value = FloatDoubleHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = FloatDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatDoubleHashMap.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (FloatDoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = FloatDoubleHashMap.this.keys[i];
            this.cursor.value = FloatDoubleHashMap.this.values[i];
            return this.cursor;
        }
    }
}

