/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sorting;

import com.carrotsearch.hppcrt.ShortIndexedContainer;
import com.carrotsearch.hppcrt.strategies.ShortComparator;

public final class ShortSort {
    private static final int MIN_LENGTH_FOR_INSERTION_SORT = 24;
    private static final int DIST_SIZE_DUALQSORT = 13;

    private ShortSort() {
    }

    public static void quicksort(short[] table, int beginIndex, int endIndex) {
        ShortSort.checkRanges(beginIndex, endIndex, table.length);
        if (endIndex - beginIndex > 1) {
            ShortSort.dualPivotQuicksort(table, beginIndex, endIndex - 1);
        }
    }

    public static void quicksort(short[] table) {
        ShortSort.quicksort(table, 0, table.length);
    }

    public static void quicksort(ShortIndexedContainer table, int beginIndex, int endIndex) {
        ShortSort.checkRanges(beginIndex, endIndex, table.size());
        if (endIndex - beginIndex > 1) {
            ShortSort.dualPivotQuicksort(table, beginIndex, endIndex - 1);
        }
    }

    public static void quicksort(ShortIndexedContainer table) {
        ShortSort.quicksort(table, 0, table.size());
    }

    public static void quicksort(short[] table, int beginIndex, int endIndex, ShortComparator comp) {
        ShortSort.checkRanges(beginIndex, endIndex, table.length);
        if (endIndex - beginIndex > 1) {
            ShortSort.dualPivotQuicksort(table, beginIndex, endIndex - 1, comp);
        }
    }

    public static void quicksort(short[] table, ShortComparator comp) {
        ShortSort.quicksort(table, 0, table.length, comp);
    }

    public static void quicksort(ShortIndexedContainer table, int beginIndex, int endIndex, ShortComparator comp) {
        ShortSort.checkRanges(beginIndex, endIndex, table.size());
        if (endIndex - beginIndex > 1) {
            ShortSort.dualPivotQuicksort(table, beginIndex, endIndex - 1, comp);
        }
    }

    public static void quicksort(ShortIndexedContainer table, ShortComparator comp) {
        ShortSort.quicksort(table, 0, table.size(), comp);
    }

    private static void insertionsort(short[] a, int left, int right) {
        for (int i = left + 1; i <= right; ++i) {
            for (int j = i; j > left && a[j] < a[j - 1]; --j) {
                short x = a[j - 1];
                a[j - 1] = a[j];
                a[j] = x;
            }
        }
    }

    private static void dualPivotQuicksort(short[] a, int left, int right) {
        int k;
        short pivot2;
        short pivot1;
        short x;
        int len = right - left;
        if (len < 24) {
            ShortSort.insertionsort(a, left, right);
            return;
        }
        int sixth = len / 6;
        int m1 = left + sixth;
        int m22 = m1 + sixth;
        int m3 = m22 + sixth;
        int m4 = m3 + sixth;
        int m5 = m4 + sixth;
        if (a[m1] > a[m22]) {
            x = a[m1];
            a[m1] = a[m22];
            a[m22] = x;
        }
        if (a[m4] > a[m5]) {
            x = a[m4];
            a[m4] = a[m5];
            a[m5] = x;
        }
        if (a[m1] > a[m3]) {
            x = a[m1];
            a[m1] = a[m3];
            a[m3] = x;
        }
        if (a[m22] > a[m3]) {
            x = a[m22];
            a[m22] = a[m3];
            a[m3] = x;
        }
        if (a[m1] > a[m4]) {
            x = a[m1];
            a[m1] = a[m4];
            a[m4] = x;
        }
        if (a[m3] > a[m4]) {
            x = a[m3];
            a[m3] = a[m4];
            a[m4] = x;
        }
        if (a[m22] > a[m5]) {
            x = a[m22];
            a[m22] = a[m5];
            a[m5] = x;
        }
        if (a[m22] > a[m3]) {
            x = a[m22];
            a[m22] = a[m3];
            a[m3] = x;
        }
        if (a[m4] > a[m5]) {
            x = a[m4];
            a[m4] = a[m5];
            a[m5] = x;
        }
        boolean diffPivots = (pivot1 = a[m22]) != (pivot2 = a[m4]);
        a[m22] = a[left];
        a[m4] = a[right];
        int less = left + 1;
        int great = right - 1;
        if (diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a[k];
                if (x < pivot1) {
                    a[k] = a[less];
                    a[less++] = x;
                    continue;
                }
                if (x <= pivot2) continue;
                while (a[great] > pivot2 && k < great) {
                    --great;
                }
                a[k] = a[great];
                a[great--] = x;
                x = a[k];
                if (x >= pivot1) continue;
                a[k] = a[less];
                a[less++] = x;
            }
        } else {
            for (k = less; k <= great; ++k) {
                x = a[k];
                if (x == pivot1) continue;
                if (x < pivot1) {
                    a[k] = a[less];
                    a[less++] = x;
                    continue;
                }
                while (a[great] > pivot2 && k < great) {
                    --great;
                }
                a[k] = a[great];
                a[great--] = x;
                x = a[k];
                if (x >= pivot1) continue;
                a[k] = a[less];
                a[less++] = x;
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        ShortSort.dualPivotQuicksort(a, left, less - 2);
        ShortSort.dualPivotQuicksort(a, great + 2, right);
        if (great - less > len - 13 && diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a[k];
                if (x == pivot1) {
                    a[k] = a[less];
                    a[less++] = x;
                    continue;
                }
                if (x != pivot2) continue;
                a[k] = a[great];
                a[great--] = x;
                x = a[k];
                if (x != pivot1) continue;
                a[k] = a[less];
                a[less++] = x;
            }
        }
        if (diffPivots) {
            ShortSort.dualPivotQuicksort(a, less, great);
        }
    }

    private static void insertionsort(ShortIndexedContainer a, int left, int right) {
        for (int i = left + 1; i <= right; ++i) {
            for (int j = i; j > left && a.get(j) < a.get(j - 1); --j) {
                short x = a.get(j - 1);
                a.set(j - 1, a.get(j));
                a.set(j, x);
            }
        }
    }

    private static void dualPivotQuicksort(ShortIndexedContainer a, int left, int right) {
        int k;
        short pivot2;
        short pivot1;
        short x;
        int len = right - left;
        if (len < 24) {
            ShortSort.insertionsort(a, left, right);
            return;
        }
        int sixth = len / 6;
        int m1 = left + sixth;
        int m22 = m1 + sixth;
        int m3 = m22 + sixth;
        int m4 = m3 + sixth;
        int m5 = m4 + sixth;
        if (a.get(m1) > a.get(m22)) {
            x = a.get(m1);
            a.set(m1, a.get(m22));
            a.set(m22, x);
        }
        if (a.get(m4) > a.get(m5)) {
            x = a.get(m4);
            a.set(m4, a.get(m5));
            a.set(m5, x);
        }
        if (a.get(m1) > a.get(m3)) {
            x = a.get(m1);
            a.set(m1, a.get(m3));
            a.set(m3, x);
        }
        if (a.get(m22) > a.get(m3)) {
            x = a.get(m22);
            a.set(m22, a.get(m3));
            a.set(m3, x);
        }
        if (a.get(m1) > a.get(m4)) {
            x = a.get(m1);
            a.set(m1, a.get(m4));
            a.set(m4, x);
        }
        if (a.get(m3) > a.get(m4)) {
            x = a.get(m3);
            a.set(m3, a.get(m4));
            a.set(m4, x);
        }
        if (a.get(m22) > a.get(m5)) {
            x = a.get(m22);
            a.set(m22, a.get(m5));
            a.set(m5, x);
        }
        if (a.get(m22) > a.get(m3)) {
            x = a.get(m22);
            a.set(m22, a.get(m3));
            a.set(m3, x);
        }
        if (a.get(m4) > a.get(m5)) {
            x = a.get(m4);
            a.set(m4, a.get(m5));
            a.set(m5, x);
        }
        boolean diffPivots = (pivot1 = a.get(m22)) != (pivot2 = a.get(m4));
        a.set(m22, a.get(left));
        a.set(m4, a.get(right));
        int less = left + 1;
        int great = right - 1;
        if (diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a.get(k);
                if (x < pivot1) {
                    a.set(k, a.get(less));
                    a.set(less, x);
                    ++less;
                    continue;
                }
                if (x <= pivot2) continue;
                while (a.get(great) > pivot2 && k < great) {
                    --great;
                }
                a.set(k, a.get(great));
                a.set(great, x);
                --great;
                x = a.get(k);
                if (x >= pivot1) continue;
                a.set(k, a.get(less));
                a.set(less, x);
                ++less;
            }
        } else {
            for (k = less; k <= great; ++k) {
                x = a.get(k);
                if (x == pivot1) continue;
                if (x < pivot1) {
                    a.set(k, a.get(less));
                    a.set(less, x);
                    ++less;
                    continue;
                }
                while (a.get(great) > pivot2 && k < great) {
                    --great;
                }
                a.set(k, a.get(great));
                a.set(great, x);
                --great;
                x = a.get(k);
                if (x >= pivot1) continue;
                a.set(k, a.get(less));
                a.set(less, x);
                ++less;
            }
        }
        a.set(left, a.get(less - 1));
        a.set(less - 1, pivot1);
        a.set(right, a.get(great + 1));
        a.set(great + 1, pivot2);
        ShortSort.dualPivotQuicksort(a, left, less - 2);
        ShortSort.dualPivotQuicksort(a, great + 2, right);
        if (great - less > len - 13 && diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a.get(k);
                if (x == pivot1) {
                    a.set(k, a.get(less));
                    a.set(less, x);
                    ++less;
                    continue;
                }
                if (x != pivot2) continue;
                a.set(k, a.get(great));
                a.set(great, x);
                --great;
                x = a.get(k);
                if (x != pivot1) continue;
                a.set(k, a.get(less));
                a.set(less, x);
                ++less;
            }
        }
        if (diffPivots) {
            ShortSort.dualPivotQuicksort(a, less, great);
        }
    }

    private static void insertionsort(short[] a, int left, int right, ShortComparator comp) {
        for (int i = left + 1; i <= right; ++i) {
            for (int j = i; j > left && comp.compare(a[j], a[j - 1]) < 0; --j) {
                short x = a[j - 1];
                a[j - 1] = a[j];
                a[j] = x;
            }
        }
    }

    private static void dualPivotQuicksort(short[] a, int left, int right, ShortComparator comp) {
        int k;
        short pivot2;
        short pivot1;
        short x;
        int len = right - left;
        if (len < 24) {
            ShortSort.insertionsort(a, left, right, comp);
            return;
        }
        int sixth = len / 6;
        int m1 = left + sixth;
        int m22 = m1 + sixth;
        int m3 = m22 + sixth;
        int m4 = m3 + sixth;
        int m5 = m4 + sixth;
        if (comp.compare(a[m1], a[m22]) > 0) {
            x = a[m1];
            a[m1] = a[m22];
            a[m22] = x;
        }
        if (comp.compare(a[m4], a[m5]) > 0) {
            x = a[m4];
            a[m4] = a[m5];
            a[m5] = x;
        }
        if (comp.compare(a[m1], a[m3]) > 0) {
            x = a[m1];
            a[m1] = a[m3];
            a[m3] = x;
        }
        if (comp.compare(a[m22], a[m3]) > 0) {
            x = a[m22];
            a[m22] = a[m3];
            a[m3] = x;
        }
        if (comp.compare(a[m1], a[m4]) > 0) {
            x = a[m1];
            a[m1] = a[m4];
            a[m4] = x;
        }
        if (comp.compare(a[m3], a[m4]) > 0) {
            x = a[m3];
            a[m3] = a[m4];
            a[m4] = x;
        }
        if (comp.compare(a[m22], a[m5]) > 0) {
            x = a[m22];
            a[m22] = a[m5];
            a[m5] = x;
        }
        if (comp.compare(a[m22], a[m3]) > 0) {
            x = a[m22];
            a[m22] = a[m3];
            a[m3] = x;
        }
        if (comp.compare(a[m4], a[m5]) > 0) {
            x = a[m4];
            a[m4] = a[m5];
            a[m5] = x;
        }
        boolean diffPivots = comp.compare(pivot1 = a[m22], pivot2 = a[m4]) != 0;
        a[m22] = a[left];
        a[m4] = a[right];
        int less = left + 1;
        int great = right - 1;
        if (diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a[k];
                if (comp.compare(x, pivot1) < 0) {
                    a[k] = a[less];
                    a[less++] = x;
                    continue;
                }
                if (comp.compare(x, pivot2) <= 0) continue;
                while (comp.compare(a[great], pivot2) > 0 && k < great) {
                    --great;
                }
                a[k] = a[great];
                a[great--] = x;
                x = a[k];
                if (comp.compare(x, pivot1) >= 0) continue;
                a[k] = a[less];
                a[less++] = x;
            }
        } else {
            for (k = less; k <= great; ++k) {
                x = a[k];
                if (comp.compare(x, pivot1) == 0) continue;
                if (comp.compare(x, pivot1) < 0) {
                    a[k] = a[less];
                    a[less++] = x;
                    continue;
                }
                while (comp.compare(a[great], pivot2) > 0 && k < great) {
                    --great;
                }
                a[k] = a[great];
                a[great--] = x;
                x = a[k];
                if (comp.compare(x, pivot1) >= 0) continue;
                a[k] = a[less];
                a[less++] = x;
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        ShortSort.dualPivotQuicksort(a, left, less - 2, comp);
        ShortSort.dualPivotQuicksort(a, great + 2, right, comp);
        if (great - less > len - 13 && diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a[k];
                if (comp.compare(x, pivot1) == 0) {
                    a[k] = a[less];
                    a[less++] = x;
                    continue;
                }
                if (comp.compare(x, pivot2) != 0) continue;
                a[k] = a[great];
                a[great--] = x;
                x = a[k];
                if (comp.compare(x, pivot1) != 0) continue;
                a[k] = a[less];
                a[less++] = x;
            }
        }
        if (diffPivots) {
            ShortSort.dualPivotQuicksort(a, less, great, comp);
        }
    }

    private static void insertionsort(ShortIndexedContainer a, int left, int right, ShortComparator comp) {
        for (int i = left + 1; i <= right; ++i) {
            for (int j = i; j > left && comp.compare(a.get(j), a.get(j - 1)) < 0; --j) {
                short x = a.get(j - 1);
                a.set(j - 1, a.get(j));
                a.set(j, x);
            }
        }
    }

    private static void dualPivotQuicksort(ShortIndexedContainer a, int left, int right, ShortComparator comp) {
        int k;
        short pivot2;
        short pivot1;
        short x;
        int len = right - left;
        if (len < 24) {
            ShortSort.insertionsort(a, left, right, comp);
            return;
        }
        int sixth = len / 6;
        int m1 = left + sixth;
        int m22 = m1 + sixth;
        int m3 = m22 + sixth;
        int m4 = m3 + sixth;
        int m5 = m4 + sixth;
        if (comp.compare(a.get(m1), a.get(m22)) > 0) {
            x = a.get(m1);
            a.set(m1, a.get(m22));
            a.set(m22, x);
        }
        if (comp.compare(a.get(m4), a.get(m5)) > 0) {
            x = a.get(m4);
            a.set(m4, a.get(m5));
            a.set(m5, x);
        }
        if (comp.compare(a.get(m1), a.get(m3)) > 0) {
            x = a.get(m1);
            a.set(m1, a.get(m3));
            a.set(m3, x);
        }
        if (comp.compare(a.get(m22), a.get(m3)) > 0) {
            x = a.get(m22);
            a.set(m22, a.get(m3));
            a.set(m3, x);
        }
        if (comp.compare(a.get(m1), a.get(m4)) > 0) {
            x = a.get(m1);
            a.set(m1, a.get(m4));
            a.set(m4, x);
        }
        if (comp.compare(a.get(m3), a.get(m4)) > 0) {
            x = a.get(m3);
            a.set(m3, a.get(m4));
            a.set(m4, x);
        }
        if (comp.compare(a.get(m22), a.get(m5)) > 0) {
            x = a.get(m22);
            a.set(m22, a.get(m5));
            a.set(m5, x);
        }
        if (comp.compare(a.get(m22), a.get(m3)) > 0) {
            x = a.get(m22);
            a.set(m22, a.get(m3));
            a.set(m3, x);
        }
        if (comp.compare(a.get(m4), a.get(m5)) > 0) {
            x = a.get(m4);
            a.set(m4, a.get(m5));
            a.set(m5, x);
        }
        boolean diffPivots = comp.compare(pivot1 = a.get(m22), pivot2 = a.get(m4)) != 0;
        a.set(m22, a.get(left));
        a.set(m4, a.get(right));
        int less = left + 1;
        int great = right - 1;
        if (diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a.get(k);
                if (comp.compare(x, pivot1) < 0) {
                    a.set(k, a.get(less));
                    a.set(less, x);
                    ++less;
                    continue;
                }
                if (comp.compare(x, pivot2) <= 0) continue;
                while (comp.compare(a.get(great), pivot2) > 0 && k < great) {
                    --great;
                }
                a.set(k, a.get(great));
                a.set(great, x);
                --great;
                x = a.get(k);
                if (comp.compare(x, pivot1) >= 0) continue;
                a.set(k, a.get(less));
                a.set(less, x);
                ++less;
            }
        } else {
            for (k = less; k <= great; ++k) {
                x = a.get(k);
                if (comp.compare(x, pivot1) == 0) continue;
                if (comp.compare(x, pivot1) < 0) {
                    a.set(k, a.get(less));
                    a.set(less, x);
                    ++less;
                    continue;
                }
                while (comp.compare(a.get(great), pivot2) > 0 && k < great) {
                    --great;
                }
                a.set(k, a.get(great));
                a.set(great, x);
                --great;
                x = a.get(k);
                if (comp.compare(x, pivot1) >= 0) continue;
                a.set(k, a.get(less));
                a.set(less, x);
                ++less;
            }
        }
        a.set(left, a.get(less - 1));
        a.set(less - 1, pivot1);
        a.set(right, a.get(great + 1));
        a.set(great + 1, pivot2);
        ShortSort.dualPivotQuicksort(a, left, less - 2, comp);
        ShortSort.dualPivotQuicksort(a, great + 2, right, comp);
        if (great - less > len - 13 && diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a.get(k);
                if (comp.compare(x, pivot1) == 0) {
                    a.set(k, a.get(less));
                    a.set(less, x);
                    ++less;
                    continue;
                }
                if (comp.compare(x, pivot2) != 0) continue;
                a.set(k, a.get(great));
                a.set(great, x);
                --great;
                x = a.get(k);
                if (comp.compare(x, pivot1) != 0) continue;
                a.set(k, a.get(less));
                a.set(less, x);
                ++less;
            }
        }
        if (diffPivots) {
            ShortSort.dualPivotQuicksort(a, less, great, comp);
        }
    }

    private static void checkRanges(int beginIndex, int endIndex, int size) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > size) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + size + "].");
        }
    }
}

