/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.MultipleExplanationGenerator;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.owlapi.explanation.util.ExplanationProgressMonitor;
import com.clarkparsia.owlapi.explanation.util.OntologyUtils;
import com.clarkparsia.owlapi.explanation.util.SilentExplanationProgressMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLEntityCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSTExplanationGenerator
implements MultipleExplanationGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSTExplanationGenerator.class);
    @Nonnull
    private final TransactionAwareSingleExpGen singleExplanationGenerator;
    @Nonnull
    private ExplanationProgressMonitor progressMonitor = new SilentExplanationProgressMonitor();

    public HSTExplanationGenerator(@Nonnull TransactionAwareSingleExpGen singleExplanationGenerator) {
        this.singleExplanationGenerator = OWLAPIPreconditions.checkNotNull(singleExplanationGenerator, "singleExplanationGenerator cannot be null");
    }

    @Override
    public void setProgressMonitor(ExplanationProgressMonitor progressMonitor) {
        this.progressMonitor = OWLAPIPreconditions.checkNotNull(progressMonitor, "progressMonitor cannot be null");
    }

    @Override
    public OWLOntologyManager getOntologyManager() {
        return this.singleExplanationGenerator.getOntologyManager();
    }

    @Override
    public OWLOntology getOntology() {
        return this.singleExplanationGenerator.getOntology();
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.singleExplanationGenerator.getReasoner();
    }

    @Override
    public OWLReasonerFactory getReasonerFactory() {
        return this.singleExplanationGenerator.getReasonerFactory();
    }

    @Nonnull
    public TransactionAwareSingleExpGen getSingleExplanationGenerator() {
        return this.singleExplanationGenerator;
    }

    @Override
    public Set<OWLAxiom> getExplanation(OWLClassExpression unsatClass) {
        return this.singleExplanationGenerator.getExplanation(unsatClass);
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLClassExpression unsatClass) {
        return this.getExplanations(unsatClass, 0);
    }

    @Override
    public void dispose() {
        this.singleExplanationGenerator.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLClassExpression unsatClass, @Nonnegative int maxExplanations) {
        OWLAPIPreconditions.checkNotNegative(maxExplanations, "max explanations cannot be negative");
        Object max = maxExplanations == 0 ? "all" : Integer.valueOf(maxExplanations);
        LOGGER.info("Get {} explanation(s) for: {}", max, (Object)unsatClass);
        try {
            Set<OWLAxiom> firstMups = this.getExplanation(unsatClass);
            if (firstMups.isEmpty()) {
                return CollectionFactory.emptySet();
            }
            LinkedHashSet<Set<OWLAxiom>> allMups = new LinkedHashSet<Set<OWLAxiom>>();
            this.progressMonitor.foundExplanation(firstMups);
            allMups.add(firstMups);
            HashSet<Set<OWLAxiom>> satPaths = new HashSet<Set<OWLAxiom>>();
            HashSet<OWLAxiom> currentPathContents = new HashSet<OWLAxiom>();
            this.singleExplanationGenerator.beginTransaction();
            try {
                this.constructHittingSetTree(unsatClass, firstMups, allMups, satPaths, currentPathContents, maxExplanations);
            }
            finally {
                this.singleExplanationGenerator.endTransaction();
            }
            this.progressMonitor.foundAllExplanations();
            return allMups;
        }
        catch (OWLException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Nonnull
    private static List<OWLAxiom> getOrderedMUPS(@Nonnull List<OWLAxiom> mups, @Nonnull Set<Set<OWLAxiom>> allMups) {
        Comparator mupsComparator = (o1, o2) -> {
            assert (o1 != null);
            assert (o2 != null);
            int occ1 = HSTExplanationGenerator.getOccurrences(o1, allMups);
            int occ2 = HSTExplanationGenerator.getOccurrences(o2, allMups);
            return -occ1 + occ2;
        };
        Collections.sort(mups, mupsComparator);
        return mups;
    }

    protected static int getOccurrences(@Nonnull OWLAxiom ax, @Nonnull Set<Set<OWLAxiom>> axiomSets) {
        int count = 0;
        for (Set<OWLAxiom> axioms : axiomSets) {
            if (!axioms.contains(ax)) continue;
            ++count;
        }
        return count;
    }

    @Nonnull
    private static Set<OWLEntity> getSignature(@Nonnull OWLAxiom axiom) {
        HashSet<OWLEntity> toReturn = new HashSet<OWLEntity>();
        OWLEntityCollector collector = new OWLEntityCollector(toReturn);
        axiom.accept(collector);
        return toReturn;
    }

    private void constructHittingSetTree(@Nonnull OWLClassExpression unsatClass, @Nonnull Set<OWLAxiom> mups, @Nonnull Set<Set<OWLAxiom>> allMups, @Nonnull Set<Set<OWLAxiom>> satPaths, @Nonnull Set<OWLAxiom> currentPathContents, int maxExplanations) throws OWLException {
        LOGGER.info("MUPS {}: {}", (Object)allMups.size(), (Object)mups);
        if (this.progressMonitor.isCancelled()) {
            return;
        }
        List<OWLAxiom> orderedMups = HSTExplanationGenerator.getOrderedMUPS(new ArrayList<OWLAxiom>(mups), allMups);
        while (!orderedMups.isEmpty()) {
            if (this.progressMonitor.isCancelled()) {
                return;
            }
            OWLAxiom axiom = orderedMups.get(0);
            assert (axiom != null);
            orderedMups.remove(0);
            if (allMups.size() == maxExplanations) {
                LOGGER.info("Computed {} explanations", (Object)maxExplanations);
                return;
            }
            LOGGER.info("Removing axiom: {} {} more removed: {}", axiom, currentPathContents.size(), currentPathContents);
            ArrayList<OWLDeclarationAxiom> temporaryDeclarations = new ArrayList<OWLDeclarationAxiom>();
            Set<OWLOntology> ontologies = this.removeAxiomAndAddDeclarations(axiom, temporaryDeclarations);
            currentPathContents.add(axiom);
            boolean earlyTermination = HSTExplanationGenerator.checkEarlyTermination(satPaths, currentPathContents);
            if (!earlyTermination) {
                orderedMups = this.recurse(unsatClass, allMups, satPaths, currentPathContents, maxExplanations, orderedMups, axiom);
            }
            this.backtrack(currentPathContents, axiom, temporaryDeclarations, ontologies);
        }
    }

    private static boolean checkEarlyTermination(@Nonnull Set<Set<OWLAxiom>> satPaths, @Nonnull Set<OWLAxiom> currentPathContents) {
        boolean earlyTermination = false;
        for (Set<OWLAxiom> satPath : satPaths) {
            if (!currentPathContents.containsAll(satPath)) continue;
            earlyTermination = true;
            LOGGER.info("Stop - satisfiable (early termination)");
            break;
        }
        return earlyTermination;
    }

    @Nonnull
    private List<OWLAxiom> recurse(@Nonnull OWLClassExpression unsatClass, @Nonnull Set<Set<OWLAxiom>> allMups, @Nonnull Set<Set<OWLAxiom>> satPaths, @Nonnull Set<OWLAxiom> currentPathContents, int maxExplanations, @Nonnull List<OWLAxiom> orderedMups, @Nonnull OWLAxiom axiom) throws OWLException {
        Set<OWLAxiom> newMUPS = this.getNewMUPS(unsatClass, allMups, currentPathContents);
        if (newMUPS.contains(axiom)) {
            throw new OWLRuntimeException("Explanation contains removed axiom: " + axiom);
        }
        if (!newMUPS.isEmpty()) {
            allMups.add(newMUPS);
            this.progressMonitor.foundExplanation(newMUPS);
            this.constructHittingSetTree(unsatClass, newMUPS, allMups, satPaths, currentPathContents, maxExplanations);
            return HSTExplanationGenerator.getOrderedMUPS(orderedMups, allMups);
        }
        LOGGER.info("Stop - satisfiable");
        satPaths.add(new HashSet<OWLAxiom>(currentPathContents));
        return orderedMups;
    }

    private void backtrack(@Nonnull Set<OWLAxiom> currentPathContents, @Nonnull OWLAxiom axiom, @Nonnull List<OWLDeclarationAxiom> temporaryDeclarations, @Nonnull Set<OWLOntology> ontologies) {
        currentPathContents.remove(axiom);
        LOGGER.info("Restoring axiom: {}", (Object)axiom);
        for (OWLDeclarationAxiom decl : temporaryDeclarations) {
            assert (decl != null);
            OntologyUtils.removeAxiom(decl, this.getReasoner().getRootOntology().getImportsClosure(), this.getOntologyManager());
        }
        OntologyUtils.addAxiom(axiom, ontologies, this.getOntologyManager());
    }

    @Nonnull
    private Set<OWLAxiom> getNewMUPS(@Nonnull OWLClassExpression unsatClass, @Nonnull Set<Set<OWLAxiom>> allMups, @Nonnull Set<OWLAxiom> currentPathContents) {
        Set<OWLAxiom> newMUPS = null;
        for (Set<OWLAxiom> foundMUPS : allMups) {
            HashSet<OWLAxiom> foundMUPSCopy = new HashSet<OWLAxiom>(foundMUPS);
            foundMUPSCopy.retainAll(currentPathContents);
            if (!foundMUPSCopy.isEmpty()) continue;
            newMUPS = foundMUPS;
            break;
        }
        if (newMUPS == null) {
            newMUPS = this.getExplanation(unsatClass);
        }
        return newMUPS;
    }

    @Nonnull
    private Set<OWLOntology> removeAxiomAndAddDeclarations(@Nonnull OWLAxiom axiom, @Nonnull List<OWLDeclarationAxiom> temporaryDeclarations) {
        Set<OWLOntology> ontologies = OntologyUtils.removeAxiom(axiom, this.getReasoner().getRootOntology().getImportsClosure(), this.getOntologyManager());
        this.collectTemporaryDeclarations(axiom, temporaryDeclarations);
        for (OWLDeclarationAxiom decl : temporaryDeclarations) {
            assert (decl != null);
            OntologyUtils.addAxiom(decl, this.getReasoner().getRootOntology().getImportsClosure(), this.getOntologyManager());
        }
        return ontologies;
    }

    private void collectTemporaryDeclarations(@Nonnull OWLAxiom axiom, @Nonnull List<OWLDeclarationAxiom> temporaryDeclarations) {
        for (OWLEntity e : HSTExplanationGenerator.getSignature(axiom)) {
            assert (e != null);
            boolean referenced = this.getReasoner().getRootOntology().isDeclared(e, Imports.INCLUDED);
            if (referenced) continue;
            temporaryDeclarations.add(this.getDeclaration(e));
        }
    }

    @Nonnull
    private OWLDeclarationAxiom getDeclaration(@Nonnull OWLEntity e) {
        return this.getOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(e);
    }
}

