/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOVocabulary;
import org.coode.owlapi.obo12.parser.TagValueHandler;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;

abstract class AbstractTagValueHandler
implements TagValueHandler {
    @Nonnull
    private String tag;
    @Nonnull
    private OBOConsumer consumer;

    public AbstractTagValueHandler(@Nonnull String tag, @Nonnull OBOConsumer consumer) {
        this.tag = tag;
        this.consumer = consumer;
    }

    @Override
    public String getTagName() {
        return this.tag;
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.consumer.getOWLOntologyManager();
    }

    @Nonnull
    public OWLOntology getOntology() {
        return this.consumer.getOntology();
    }

    public void applyChange(@Nonnull OWLOntologyChange change) {
        this.consumer.getOWLOntologyManager().applyChange(change);
    }

    @Nonnull
    public OBOConsumer getConsumer() {
        return this.consumer;
    }

    public OWLDataFactory getDataFactory() {
        return this.consumer.getOWLOntologyManager().getOWLDataFactory();
    }

    @Nonnull
    public IRI getTagIRI(OBOVocabulary vocabulary) {
        return this.consumer.getIRIFromTagName(vocabulary.getName());
    }

    @Nonnull
    public IRI getTagIRI(String tagName) {
        return this.consumer.getIRIFromTagName(tagName);
    }

    @Nonnull
    public IRI getIRIFromOBOId(String id) {
        return this.consumer.getIRIFromOBOId(id);
    }

    @Nonnull
    public OWLAnnotation getAnnotationForTagValuePair(String tagName, String value) {
        IRI tagIRI = this.getTagIRI(tagName);
        OWLDataFactory df = this.getDataFactory();
        OWLAnnotationProperty annotationProperty = df.getOWLAnnotationProperty(tagIRI);
        String unescapedString = this.getUnquotedString(value);
        OWLLiteral annotationValue = df.getOWLLiteral(unescapedString);
        return df.getOWLAnnotation(annotationProperty, annotationValue);
    }

    @Nonnull
    public OWLClass getClassFromId(String s2) {
        return this.getDataFactory().getOWLClass(this.getIRIFromOBOId(s2));
    }

    @Nonnull
    public OWLClass getCurrentClass() {
        return this.getDataFactory().getOWLClass(this.getIRIFromOBOId(this.consumer.getCurrentId()));
    }

    @Nonnull
    protected OWLClass getOWLClass(String id) {
        return this.getDataFactory().getOWLClass(this.getIRIFromOBOId(id));
    }

    @Nonnull
    protected OWLObjectProperty getOWLObjectProperty(String id) {
        return this.getDataFactory().getOWLObjectProperty(this.getIRIFromOBOId(id));
    }

    @Nonnull
    protected String getUnquotedString(String value) {
        String unquotedString = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        return unquotedString;
    }

    @Nonnull
    protected OWLClassExpression getOWLClassOrRestriction(String termList) {
        StringTokenizer tok = new StringTokenizer(termList, " ", false);
        String id0 = null;
        String id1 = null;
        id0 = tok.nextToken();
        if (tok.hasMoreTokens()) {
            id1 = tok.nextToken();
        }
        if (id1 == null) {
            return this.getDataFactory().getOWLClass(this.getIRIFromOBOId(id0));
        }
        IRI propertyIRI = this.getConsumer().getRelationIRIFromSymbolicIdOrOBOId(id0);
        OWLObjectProperty prop = this.getDataFactory().getOWLObjectProperty(propertyIRI);
        OWLClass filler = this.getDataFactory().getOWLClass(this.getIRIFromOBOId(id1));
        return this.getDataFactory().getOWLObjectSomeValuesFrom(prop, filler);
    }

    @Nonnull
    protected OWLLiteral getBooleanConstant(boolean b) {
        return this.getDataFactory().getOWLLiteral(b);
    }

    protected void addAnnotation(String id, String uriID, @Nonnull OWLLiteral value) {
        IRI subject = this.getIRIFromOBOId(id);
        OWLAnnotationProperty annotationProperty = this.getDataFactory().getOWLAnnotationProperty(this.getIRIFromOBOId(uriID));
        OWLAnnotationAssertionAxiom ax = this.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, subject, value);
        this.applyChange(new AddAxiom(this.getOntology(), ax));
    }
}

