/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilentIteration<T, E extends Exception>
extends IterationWrapper<T, E> {
    private static final Logger logger = LoggerFactory.getLogger(SilentIteration.class);

    public SilentIteration(CloseableIteration<T, E> iter) {
        super(iter);
    }

    @Override
    public boolean hasNext() throws E {
        try {
            return super.hasNext();
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("Suppressed error in SILENT iteration: " + e.getMessage(), e);
            }
            return false;
        }
    }

    @Override
    public T next() throws E {
        try {
            return (T)super.next();
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("Converted error in SILENT iteration: " + e.getMessage(), e);
            }
            throw new NoSuchElementException(e.getMessage());
        }
    }

    @Override
    protected void handleClose() throws E {
        block2: {
            try {
                super.handleClose();
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("Suppressed error in SILENT iteration: " + e.getMessage(), e);
            }
        }
    }
}

