/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.obolibrary.cli.OBORunnerConfigCLIReader;
import org.obolibrary.cli.OBORunnerConfiguration;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.obo2owl.Owl2Obo;
import org.obolibrary.oboformat.diff.Diff;
import org.obolibrary.oboformat.diff.OBODocDiffer;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OBODiffRunner {
    private static Logger logger = Logger.getLogger(OBODiffRunner.class.getName());

    public static void main(String[] args) throws Exception {
        OBORunnerConfiguration config = OBORunnerConfigCLIReader.readConfig(args);
        if (config.showHelp.getValue().booleanValue()) {
            OBODiffRunner.usage();
            System.exit(0);
        }
        String buildDir = config.buildDir.getValue();
        if (config.ontsToDownload.getValue().size() > 0 && buildDir == null) {
            logger.log(Level.SEVERE, "must specify dir with -b DIR");
            System.exit(1);
        }
        if (config.outFile.isEmpty() && config.outputdir.isEmpty()) {
            logger.log(Level.SEVERE, "must specify at least one fo the following: outFile OR outputdir");
            OBODiffRunner.usage();
            System.exit(1);
        }
        if (buildDir != null) {
            OBODiffRunner.buildAllOboOwlFiles(buildDir, config, logger, null);
        }
        OBODiffRunner.runConversion(config, logger, null);
    }

    protected static void runConversion(OBORunnerConfiguration config, Logger logger, OWLOntologyManager manager) throws Exception {
        String outFile = config.outFile.getValue();
        Vector<OBODoc> obodocs = new Vector<OBODoc>();
        for (String iri : config.paths.getValue()) {
            iri = OBODiffRunner.getURI(iri);
            if (config.isOboToOwl.getValue().booleanValue()) {
                OBOFormatParser p = new OBOFormatParser();
                p.setFollowImports(config.followImports.getValue());
                OBODoc obodoc = p.parseURL(iri);
                obodocs.add(obodoc);
                continue;
            }
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument(IRI.create(iri));
            String version = config.version.getValue();
            if (version != null) {
                OBODiffRunner.addVersion(ontology, version, manager);
            }
            Owl2Obo bridge = new Owl2Obo();
            bridge.setStrictConversion(config.strictConversion.getValue());
            OBODoc doc = bridge.convert(ontology);
            obodocs.add(doc);
        }
        if (obodocs.size() > 2) {
            System.err.println("Max 2 docs!");
        }
        OBODoc obodoc1 = (OBODoc)obodocs.get(0);
        OBODoc obodoc2 = (OBODoc)obodocs.get(1);
        List<Diff> diffs = OBODocDiffer.getDiffs(obodoc1, obodoc2);
        for (Diff diff : diffs) {
            System.out.println("MDiff=" + diff);
        }
    }

    private static void usage() {
        System.out.println("obolib-obo2owl [--to SYNTAX, --allowdangling --followimports --strictconversion] -o FILEPATH-URI OBO-FILE");
        System.out.println("obolib-obo2owl -b BUILDPATH-URI");
        System.out.println("\n");
        System.out.println("Converts obo files to OWL. If -b option is used, entire\n");
        System.out.println("obo repository is converted\n");
        System.out.println("\n");
        System.out.println("Example:\n");
        System.out.println(" obolib-obo2owl -o file://`pwd`/my.owl my.obo\n");
        System.out.println("Example:\n");
        System.out.println(" obolib-obo2owl -b file://`pwd`\n");
        System.out.println("Example:\n");
        System.out.println(" obolib-obo2owl -b file://`pwd` --download FBBT\n");
    }

    private static String getURI(String path) {
        if (path.startsWith("http://") || path.startsWith("file:///")) {
            return path;
        }
        File f = new File(path);
        return f.toURI().toString();
    }

    public static void showMemory() {
        System.gc();
        System.gc();
        System.gc();
        long tm = Runtime.getRuntime().totalMemory();
        long fm = Runtime.getRuntime().freeMemory();
        long mem = tm - fm;
        System.out.println("Memory total:" + tm + " free:" + fm + " diff:" + mem + " (bytes) diff:" + mem / 1000000L + " (mb)");
    }

    protected static void buildAllOboOwlFiles(String dir, OBORunnerConfiguration config, Logger logger, OWLOntologyManager manager) throws IOException {
        Map<String, String> ontmap = OBODiffRunner.getOntDownloadMap();
        Vector<String> fails = new Vector<String>();
        Set<String> ontsToDownload = config.ontsToDownload.getValue();
        Set<String> omitOntsToDownload = config.omitOntsToDownload.getValue();
        for (String ont : ontmap.keySet()) {
            if (ontsToDownload.size() > 0 && !ontsToDownload.contains(ont) || omitOntsToDownload.size() > 0 && omitOntsToDownload.contains(ont)) continue;
            if (ontmap.containsKey(ont)) {
                try {
                    String url = ontmap.get(ont);
                    long initTime = System.nanoTime();
                    String ontId = ont.toLowerCase();
                    logger.info("converting: " + ont + " from: " + url + " using default ont:" + ontId);
                    if (url == null) {
                        logger.log(Level.WARNING, "no url for " + ont);
                        fails.add(ont);
                        continue;
                    }
                    OWLAPIObo2Owl.convertURL(url, OBODiffRunner.getURI(dir + "/" + ontId + ".owl"), ontId, manager);
                    long totalTime = System.nanoTime() - initTime;
                    OBODiffRunner.showMemory();
                    logger.info("TIME_TO_CONVERT " + ont + " " + (double)totalTime / 1000000.0 + " ms");
                }
                catch (Error e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                    fails.add(ont);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                    fails.add(ont);
                }
                continue;
            }
            fails.add(ont);
            logger.log(Level.WARNING, "did not convert: " + ont);
        }
        logger.info("DONE!");
        for (String fail : fails) {
            logger.log(Level.WARNING, "FAIL:" + fail);
        }
    }

    private static Map<String, String> getOntDownloadMap() throws IOException {
        return OBODiffRunner.getOntDownloadMap(new URL("http://obo.cvs.sourceforge.net/viewvc/*checkout*/obo/obo/website/cgi-bin/ontologies.txt"));
    }

    private static Map<String, String> getOntDownloadMap(URL url) throws IOException {
        return OBODiffRunner.getOntDownloadMap(new BufferedReader(new InputStreamReader(url.openStream())));
    }

    private static Map<String, String> getOntDownloadMap(BufferedReader in) throws IOException {
        String line;
        HashMap<String, String> urlmap = new HashMap<String, String>();
        String ns = null;
        while ((line = in.readLine()) != null) {
            if (line.length() == 0) {
                ns = null;
                continue;
            }
            String[] parts = line.split("\t");
            if (parts.length < 2) continue;
            String tag = parts[0];
            if (tag.equals("namespace")) {
                ns = parts[1];
                continue;
            }
            if (tag.equals("download")) {
                if (parts[1] == "") continue;
                urlmap.put(ns, parts[1]);
                continue;
            }
            if (tag.equals("source")) {
                if (parts[1].isEmpty() || urlmap.containsKey(ns)) continue;
                urlmap.put(ns, parts[1]);
                continue;
            }
            if (tag.equals("is_obsolete")) {
                if (urlmap.containsKey(ns)) {
                    urlmap.remove(ns);
                }
                ns = null;
                continue;
            }
            if (!tag.equals("format") || parts[1].equals("obo")) continue;
            urlmap.remove(ns);
        }
        return urlmap;
    }

    private static void addVersion(OWLOntology ontology, String version, OWLOntologyManager manager) {
        OWLDataFactory fac = manager.getOWLDataFactory();
        OWLAnnotationProperty ap = fac.getOWLAnnotationProperty(OWLAPIObo2Owl.trTagToIRI(OBOFormatConstants.OboFormatTag.TAG_REMARK.getTag()));
        OWLAnnotation ann = fac.getOWLAnnotation(ap, fac.getOWLLiteral(version));
        OWLAnnotationAssertionAxiom ax = fac.getOWLAnnotationAssertionAxiom(ontology.getOntologyID().getOntologyIRI().get(), ann);
        manager.applyChange(new AddAxiom(ontology, ax));
    }
}

