/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.cli;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.obolibrary.cli.OBORunner;
import org.obolibrary.cli.OBORunnerConfigCLIReader;
import org.obolibrary.cli.OBORunnerConfiguration;
import org.obolibrary.gui.GuiMainFrame;

public class OBORunnerGui
extends OBORunner {
    private static final Logger logger = Logger.getLogger(OBORunnerGui.class.getName());
    private static final ThreadLocal<DateFormat> df = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public static void main(String[] args) {
        ArrayBlockingQueue logQueue = new ArrayBlockingQueue(100000);
        OBORunnerConfiguration config = OBORunnerConfigCLIReader.readConfig(args);
        if (config.showHelp.getValue().booleanValue()) {
            System.out.println("GUI version of OBORunner. All parameters are set using the GUI.");
            System.exit(0);
        }
        new GuiMainFrameWorker(logQueue, config);
    }

    private static final class GuiMainFrameWorker
    extends GuiMainFrame {
        private static final long serialVersionUID = -7439731894262579201L;

        private GuiMainFrameWorker(BlockingQueue<String> logQueue, OBORunnerConfiguration config) {
            super(logQueue, config);
        }

        @Override
        protected void executeConversion(final OBORunnerConfiguration config) {
            this.disableRunButton();
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        String buildDir = config.buildDir.getValue();
                        if (buildDir != null) {
                            OBORunner.buildAllOboOwlFiles(buildDir, config, logger, null);
                        }
                        OBORunner.runConversion(config, logger, null, null);
                        logger.info("Finished ontology conversion.");
                        JOptionPane.showMessageDialog(this, "Finished ontology conversion.");
                    }
                    catch (Exception e) {
                        String message = "Internal error: " + e.getMessage();
                        logger.log(Level.SEVERE, message, e);
                        JOptionPane.showMessageDialog(this, message, "Error", 0);
                    }
                    catch (Throwable e) {
                        String message = "Internal error: " + e.getMessage();
                        logger.log(Level.SEVERE, message, e);
                        JOptionPane.showMessageDialog(this, message, "FatalError", 0);
                    }
                    finally {
                        this.enableRunButton();
                    }
                }
            };
            t.start();
        }
    }
}

