/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.examples;

import java.io.FileOutputStream;
import org.obolibrary.obo2owl.Obo2Owl;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class ExportLabelsAsOWL {
    public static void main(String[] args) throws Exception {
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(args[0]);
        Obo2Owl bridge = new Obo2Owl(null);
        OWLOntology ontology = bridge.convert(obodoc);
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        FileOutputStream os = new FileOutputStream(args[1]);
        IRI rdfsLabelIRI = OWLRDFVocabulary.RDFS_LABEL.getIRI();
        OWLOntology ontology2 = manager.createOntology(IRI.create("http://example.org"));
        for (OWLClass c : ontology.getClassesInSignature()) {
            manager.addAxiom(ontology2, manager.getOWLDataFactory().getOWLDeclarationAxiom(c));
            for (OWLAnnotationAssertionAxiom a : ontology.getAnnotationAssertionAxioms(c.getIRI())) {
                if (!a.getProperty().getIRI().equals(rdfsLabelIRI)) continue;
                manager.addAxiom(ontology2, a);
            }
        }
        RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
        manager.saveOntology(ontology2, (OWLDocumentFormat)format, os);
    }
}

