/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.obolibrary.gui.GuiAdvancedDirectionSpecificPanel;
import org.obolibrary.gui.GuiMainFrame;
import org.obolibrary.gui.GuiTools;
import org.obolibrary.gui.SelectDialog;

public class GuiMainPanel
extends GuiTools.SizedJPanel {
    private static final long serialVersionUID = 1281395185956670966L;
    final GuiMainFrame frame;
    final JTextField inputFileTextField;
    final JTextField outputFileTextField;
    final JRadioButton obo2owlButton;
    final JRadioButton owl2oboButton;

    public GuiMainPanel(GuiMainFrame frame, Iterable<String> defaultInputFiles, String defaultOutputFile, boolean obo2owl) {
        this.frame = frame;
        String defaultInputFileName = null;
        Iterator<String> iterator = defaultInputFiles.iterator();
        if (iterator.hasNext()) {
            defaultInputFileName = iterator.next();
        }
        this.inputFileTextField = GuiTools.createTextField(defaultInputFileName);
        this.obo2owlButton = new JRadioButton("OBO2OWL");
        this.owl2oboButton = new JRadioButton("OWL2OBO");
        this.outputFileTextField = GuiTools.createTextField(defaultOutputFile);
        this.setLayout(new GridBagLayout());
        GuiTools.GBHelper pos = new GuiTools.GBHelper();
        GuiTools.addRowGap(this, pos, 10);
        this.addLabelLine(pos, "Minimal options required to convert an ontology file");
        GuiTools.addRowGap(this, pos, 20);
        this.createInputPanel(pos, defaultInputFileName);
        GuiTools.addRowGap(this, pos, 20);
        this.createOutputPanel(pos, defaultOutputFile);
        GuiTools.addRowGap(this, pos, 20);
        this.createDirectionPanel(pos, obo2owl);
    }

    private void addLabelLine(GuiTools.GBHelper pos, String text) {
        this.add((Component)new JLabel(text), pos.nextRow().expandW().width(3));
        GuiTools.addRowGap(this, pos, 10);
    }

    private void createInputPanel(GuiTools.GBHelper pos, String defaultFolder) {
        final SelectDialog dialog = SelectDialog.getFileSelector(this.frame, false, defaultFolder, "Input ontology file choose dialog", "OBO & OWL files", new String[]{"obo", "owl"});
        JButton fileDialogAddButton = new JButton("Select");
        fileDialogAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.show();
                String selected = dialog.getSelectedCanonicalPath();
                if (selected != null) {
                    GuiMainPanel.this.inputFileTextField.setText(selected);
                }
            }
        });
        this.addLabelLine(pos, "Input Ontology File");
        this.add((Component)this.inputFileTextField, pos.nextRow().indentLeft(40).expandW().fill());
        this.add((Component)fileDialogAddButton, pos.nextCol().indentLeft(10));
        pos.nextRow();
    }

    private void createOutputPanel(GuiTools.GBHelper pos, String defaultFolder) {
        final SelectDialog fileDialog = SelectDialog.getFileSelector(this.frame, true, defaultFolder, "Output ontology file choose dialog", "OBO & OWL files", new String[]{"obo", "owl"});
        JButton fileButton = new JButton("Select");
        fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileDialog.show();
                String selected = fileDialog.getSelectedCanonicalPath();
                if (selected != null) {
                    GuiMainPanel.this.outputFileTextField.setText(selected);
                }
            }
        });
        this.addLabelLine(pos, "Output Ontology File");
        this.add((Component)this.outputFileTextField, pos.nextRow().indentLeft(40).expandW().fill());
        this.add((Component)fileButton, pos.nextCol().indentLeft(10));
    }

    private void createDirectionPanel(GuiTools.GBHelper pos, boolean isObo2Owl) {
        this.addLabelLine(pos, "Direction");
        ButtonGroup directionButtonGroup = new ButtonGroup();
        directionButtonGroup.add(this.obo2owlButton);
        directionButtonGroup.add(this.owl2oboButton);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.obo2owlButton);
        buttonPanel.add(this.owl2oboButton);
        this.add((Component)buttonPanel, pos.nextRow().indentLeft(40).expandW().expandH());
        this.obo2owlButton.setSelected(isObo2Owl);
        this.obo2owlButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GuiAdvancedDirectionSpecificPanel panel = GuiMainPanel.this.frame.getSpecificAdvancedPanel();
                panel.setObo2Owl(GuiMainPanel.this.obo2owlButton.isSelected());
            }
        });
    }
}

