/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class GuiTools {
    public static JTextField createTextField(String defaultValue) {
        JTextField jTextField = new JTextField();
        if (defaultValue != null) {
            jTextField.setText(defaultValue);
        }
        return jTextField;
    }

    public static void addRowGap(JPanel panel, GBHelper pos, int size) {
        panel.add((Component)new Gap(size), pos.nextRow());
    }

    public static List<String> getStrings(JTextArea jTextArea) {
        Document document = jTextArea.getDocument();
        Element paragraph = document.getDefaultRootElement();
        int contentCount = paragraph.getElementCount();
        if (contentCount <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(contentCount);
        for (int i = 0; i < contentCount; ++i) {
            Element element = paragraph.getElement(i);
            int rangeStart = element.getStartOffset();
            int rangeEnd = element.getEndOffset();
            try {
                String line = document.getText(rangeStart, rangeEnd - rangeStart).trim();
                list.add(line);
                continue;
            }
            catch (BadLocationException exception) {
                throw new RuntimeException("Could not parse text in area", exception);
            }
        }
        return list;
    }

    public static class GBHelper
    extends GridBagConstraints {
        private static final long serialVersionUID = -7193587738437725346L;

        public GBHelper() {
            this.gridx = 0;
            this.gridy = 0;
            this.fill = 0;
            this.ipadx = 2;
            this.ipady = 2;
            this.anchor = 18;
        }

        public GBHelper nextCol() {
            ++this.gridx;
            return this;
        }

        public GBHelper nextRow() {
            this.gridx = 0;
            ++this.gridy;
            return this;
        }

        public GBHelper indentLeft(int pixel) {
            GBHelper duplicate = (GBHelper)this.clone();
            duplicate.insets = new Insets(this.insets.top, this.insets.left + pixel, this.insets.bottom, this.insets.right);
            return duplicate;
        }

        public GBHelper indentRight(int pixel) {
            GBHelper duplicate = (GBHelper)this.clone();
            duplicate.insets = new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right + pixel);
            return duplicate;
        }

        public GBHelper anchorCenter() {
            GBHelper duplicate = (GBHelper)this.clone();
            duplicate.anchor = 10;
            return duplicate;
        }

        public GBHelper expandW() {
            GBHelper duplicate = (GBHelper)this.clone();
            duplicate.weightx = 1.0;
            return duplicate;
        }

        public GBHelper expandH() {
            GBHelper duplicate = (GBHelper)this.clone();
            duplicate.weighty = 1.0;
            return duplicate;
        }

        public GBHelper height(int rowsHigh) {
            GBHelper duplicate = (GBHelper)this.clone();
            duplicate.gridheight = rowsHigh;
            return duplicate;
        }

        public GBHelper width(int columnsWide) {
            GBHelper duplicate = (GBHelper)this.clone();
            duplicate.gridwidth = columnsWide;
            return duplicate;
        }

        public GBHelper fill() {
            GBHelper duplicate = (GBHelper)this.clone();
            duplicate.fill = 1;
            return duplicate;
        }
    }

    private static class Gap
    extends JComponent {
        private static final long serialVersionUID = -7493120260432598483L;

        private Gap() {
            Dimension min2 = new Dimension(0, 0);
            Dimension max = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.setMinimumSize(min2);
            this.setPreferredSize(min2);
            this.setMaximumSize(max);
        }

        private Gap(int size) {
            Dimension dim = new Dimension(size, size);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
            this.setMaximumSize(dim);
        }
    }

    public static class SizedJPanel
    extends JPanel {
        private static final long serialVersionUID = -7310308040237600280L;

        public SizedJPanel() {
            this.setPreferredSize(new Dimension(590, 340));
        }
    }
}

