/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.parser;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class OBOFormatConstants {
    private static final Map<String, OboFormatTag> TAGSTABLE = Stream.of(OboFormatTag.values()).collect(Collectors.toConcurrentMap(OboFormatTag::getTag, Function.identity()));
    public static Comparator<String> headerPriority = (a, b) -> Integer.compare(OBOFormatConstants.map(a, OboFormatTag::headerPriority), OBOFormatConstants.map(b, OboFormatTag::headerPriority));
    public static Comparator<String> tagPriority = (a, b) -> Integer.compare(OBOFormatConstants.map(a, OboFormatTag::tagPriority), OBOFormatConstants.map(b, OboFormatTag::tagPriority));
    public static Comparator<String> typeDefPriority = (a, b) -> Integer.compare(OBOFormatConstants.map(a, OboFormatTag::typeDefPriority), OBOFormatConstants.map(b, OboFormatTag::typeDefPriority));
    public static final Set<String> TAGS = TAGSTABLE.keySet();

    private static int map(String s2, ToIntFunction<OboFormatTag> f) {
        OboFormatTag t = TAGSTABLE.get(s2);
        if (t == null) {
            return 10000;
        }
        return f.applyAsInt(t);
    }

    @Nullable
    public static OboFormatTag getTag(String tag) {
        return TAGSTABLE.get(tag);
    }

    public static final DateFormat headerDateFormat() {
        return new SimpleDateFormat("dd:MM:yyyy HH:mm");
    }

    public static enum OboFormatTag {
        TAG_FORMAT_VERSION("format-version", 0),
        TAG_ONTOLOGY("ontology", 85),
        TAG_DATA_VERSION("data-version", 10),
        TAG_DATE("date", 15),
        TAG_SAVED_BY("saved-by", 20),
        TAG_AUTO_GENERATED_BY("auto-generated-by", 25),
        TAG_IMPORT("import", 80),
        TAG_SUBSETDEF("subsetdef", 35),
        TAG_SYNONYMTYPEDEF("synonymtypedef", 40),
        TAG_DEFAULT_NAMESPACE("default-namespace", 45),
        TAG_IDSPACE("idspace", 50),
        TAG_TREAT_XREFS_AS_EQUIVALENT("treat-xrefs-as-equivalent", 55),
        TAG_TREAT_XREFS_AS_REVERSE_GENUS_DIFFERENTIA("treat-xrefs-as-reverse-genus-differentia"),
        TAG_TREAT_XREFS_AS_GENUS_DIFFERENTIA("treat-xrefs-as-genus-differentia", 60),
        TAG_TREAT_XREFS_AS_RELATIONSHIP("treat-xrefs-as-relationship", 65),
        TAG_TREAT_XREFS_AS_IS_A("treat-xrefs-as-is_a", 70),
        TAG_TREAT_XREFS_AS_HAS_SUBCLASS("treat-xrefs-as-has-subclass"),
        TAG_OWL_AXIOMS("owl-axioms", 110),
        TAG_REMARK("remark", 75),
        TAG_ID("id", 10000, 5, 5),
        TAG_NAME("name", 10000, 15, 15),
        TAG_NAMESPACE("namespace", 10000, 20, 20),
        TAG_ALT_ID("alt_id", 10000, 25, 25),
        TAG_DEF("def", 10000, 30, 30),
        TAG_COMMENT("comment", 10000, 35, 35),
        TAG_SUBSET("subset", 10000, 40, 40),
        TAG_SYNONYM("synonym", 10000, 45, 45),
        TAG_XREF("xref", 10000, 50, 50),
        TAG_BUILTIN("builtin", 10000, 55, 70),
        TAG_PROPERTY_VALUE("property_value", 100, 98, 55),
        TAG_IS_A("is_a", 10000, 65, 115),
        TAG_INTERSECTION_OF("intersection_of", 10000, 70, 120),
        TAG_UNION_OF("union_of", 10000, 80, 125),
        TAG_EQUIVALENT_TO("equivalent_to", 10000, 85, 130),
        TAG_DISJOINT_FROM("disjoint_from", 10000, 90, 135),
        TAG_RELATIONSHIP("relationship", 10000, 95, 165),
        TAG_CREATED_BY("created_by", 10000, 130, 191),
        TAG_CREATION_DATE("creation_date", 10000, 140, 192),
        TAG_IS_OBSELETE("is_obsolete", 10000, 110, 169),
        TAG_REPLACED_BY("replaced_by", 10000, 115, 185),
        TAG_IS_ANONYMOUS("is_anonymous", 10000, 10, 10),
        TAG_DOMAIN("domain", 10000, 10000, 60),
        TAG_RANGE("range", 10000, 10000, 65),
        TAG_IS_ANTI_SYMMETRIC("is_anti_symmetric", 10000, 10000, 75),
        TAG_IS_CYCLIC("is_cyclic", 10000, 10000, 80),
        TAG_IS_REFLEXIVE("is_reflexive", 10000, 10000, 85),
        TAG_IS_SYMMETRIC("is_symmetric", 10000, 10000, 90),
        TAG_IS_TRANSITIVE("is_transitive", 10000, 10000, 100),
        TAG_IS_FUNCTIONAL("is_functional", 10000, 10000, 105),
        TAG_IS_INVERSE_FUNCTIONAL("is_inverse_functional", 10000, 10000, 110),
        TAG_TRANSITIVE_OVER("transitive_over", 10000, 10000, 145),
        TAG_HOLDS_OVER_CHAIN("holds_over_chain", 10000, 60, 71),
        TAG_EQUIVALENT_TO_CHAIN("equivalent_to_chain", 10000, 10000, 155),
        TAG_DISJOINT_OVER("disjoint_over", 10000, 10000, 160),
        TAG_EXPAND_ASSERTION_TO("expand_assertion_to", 10000, 10000, 195),
        TAG_EXPAND_EXPRESSION_TO("expand_expression_to", 10000, 10000, 200),
        TAG_IS_CLASS_LEVEL_TAG("is_class_level", 10000, 10000, 210),
        TAG_IS_METADATA_TAG("is_metadata_tag", 10000, 10000, 205),
        TAG_CONSIDER("consider", 10000, 120, 190),
        TAG_INVERSE_OF("inverse_of", 10000, 10000, 140),
        TAG_IS_ASYMMETRIC("is_asymmetric"),
        TAG_NAMESPACE_ID_RULE("namespace-id-rule", 46),
        TAG_LOGICAL_DEFINITION_VIEW_RELATION("logical-definition-view-relation"),
        TAG_SCOPE("scope"),
        TAG_HAS_SYNONYM_TYPE("has_synonym_type"),
        TAG_BROAD("BROAD"),
        TAG_NARROW("NARROW"),
        TAG_EXACT("EXACT"),
        TAG_RELATED("RELATED");

        public static final EnumSet<OboFormatTag> TERM_FRAMES;
        public static final EnumSet<OboFormatTag> TYPEDEF_FRAMES;
        private final String tag;
        private final int headerTagsPriority;
        private final int tagsPriority;
        private final int typeDefTagsPriority;

        private OboFormatTag(String tag) {
            this(tag, 10000, 10000, 10000);
        }

        private OboFormatTag(String tag, int header) {
            this(tag, header, 10000, 10000);
        }

        private OboFormatTag(String tag, int header, int priority, int typedef) {
            this.tag = tag;
            this.headerTagsPriority = header;
            this.tagsPriority = priority;
            this.typeDefTagsPriority = typedef;
        }

        public int headerPriority() {
            return this.headerTagsPriority;
        }

        public int tagPriority() {
            return this.tagsPriority;
        }

        public int typeDefPriority() {
            return this.typeDefTagsPriority;
        }

        public String getTag() {
            return this.tag;
        }

        public String toString() {
            return this.tag;
        }

        static {
            TERM_FRAMES = EnumSet.of(TAG_INTERSECTION_OF, new OboFormatTag[]{TAG_UNION_OF, TAG_EQUIVALENT_TO, TAG_DISJOINT_FROM, TAG_RELATIONSHIP, TAG_IS_A});
            TYPEDEF_FRAMES = EnumSet.of(TAG_INTERSECTION_OF, new OboFormatTag[]{TAG_UNION_OF, TAG_EQUIVALENT_TO, TAG_DISJOINT_FROM, TAG_INVERSE_OF, TAG_TRANSITIVE_OVER, TAG_DISJOINT_OVER, TAG_IS_A});
        }
    }
}

