/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.FrameMergeException;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.InvalidXrefMapException;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrefExpander {
    protected static final Logger LOG = LoggerFactory.getLogger(XrefExpander.class);
    OBODoc sourceOBODoc;
    OBODoc targetOBODoc;
    String targetBase;
    @Nonnull
    Map<String, Rule> treatMap = new HashMap<String, Rule>();
    @Nonnull
    Map<String, OBODoc> targetDocMap = new HashMap<String, OBODoc>();

    public XrefExpander(@Nonnull OBODoc src) {
        this.sourceOBODoc = src;
        Frame shf = src.getHeaderFrame();
        String ontId = shf.getTagValue(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, String.class);
        String tgtOntId = ontId + "/xref_expansions";
        this.targetOBODoc = new OBODoc();
        Frame thf = new Frame(Frame.FrameType.HEADER);
        thf.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, tgtOntId));
        this.targetOBODoc.setHeaderFrame(thf);
        this.sourceOBODoc.addImportedOBODoc(this.targetOBODoc);
        this.setUp();
    }

    public XrefExpander(OBODoc src, String targetBase) {
        this.sourceOBODoc = src;
        this.targetBase = targetBase;
        this.setUp();
    }

    public XrefExpander(OBODoc src, OBODoc tgt) {
        this.sourceOBODoc = src;
        this.targetOBODoc = tgt;
        this.setUp();
    }

    public final void setUp() {
        HashMap<String, String> relationsUseByIdSpace = new HashMap<String, String>();
        for (Clause c : this.sourceOBODoc.getHeaderFrame().getClauses()) {
            Frame tdf;
            String v = c.getValue(String.class);
            if (v == null) {
                LOG.error("problem with header clause in xref expansion: {}", (Object)c);
                continue;
            }
            String[] parts = v.split("\\s");
            String relation = null;
            String idSpace = parts[0];
            if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_EQUIVALENT.getTag())) {
                this.addRule(parts[0], new EquivalenceExpansion());
            } else if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_GENUS_DIFFERENTIA.getTag())) {
                this.addRule(idSpace, new GenusDifferentiaExpansion(parts[1], parts[2]));
                relationsUseByIdSpace.put(idSpace, parts[1]);
                relation = parts[1];
            } else if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_REVERSE_GENUS_DIFFERENTIA.getTag())) {
                this.addRule(idSpace, new ReverseGenusDifferentiaExpansion(parts[1], parts[2]));
                relationsUseByIdSpace.put(idSpace, parts[1]);
                relation = parts[1];
            } else if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_HAS_SUBCLASS.getTag())) {
                this.addRule(idSpace, new HasSubClassExpansion());
            } else if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_IS_A.getTag())) {
                this.addRule(idSpace, new IsaExpansion());
            } else {
                if (!c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_RELATIONSHIP.getTag())) continue;
                this.addRule(idSpace, new RelationshipExpansion(parts[1]));
                relationsUseByIdSpace.put(idSpace, parts[1]);
                relation = parts[1];
            }
            if (this.targetBase == null) continue;
            OBODoc tgt = new OBODoc();
            Frame thf = new Frame(Frame.FrameType.HEADER);
            thf.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, this.targetBase + "-" + idSpace.toLowerCase()));
            tgt.setHeaderFrame(thf);
            this.targetDocMap.put(idSpace, tgt);
            this.sourceOBODoc.addImportedOBODoc(tgt);
            if (relation == null || (tdf = this.sourceOBODoc.getTypedefFrame(relation)) == null) continue;
            try {
                tgt.addTypedefFrame(tdf);
            }
            catch (FrameMergeException e) {
                LOG.debug("frame merge failed", e);
            }
        }
    }

    public OBODoc getTargetDoc(String idSpace) {
        if (this.targetOBODoc != null) {
            return this.targetOBODoc;
        }
        return this.targetDocMap.get(idSpace);
    }

    private void addRule(String db, @Nonnull Rule rule) {
        if (this.treatMap.containsKey(db)) {
            throw new InvalidXrefMapException(db);
        }
        rule.idSpace = db;
        this.treatMap.put(db, rule);
    }

    public void expandXrefs() {
        for (Frame f : this.sourceOBODoc.getTermFrames()) {
            String id = f.getTagValue(OBOFormatConstants.OboFormatTag.TAG_ID, String.class);
            Collection<Clause> clauses = f.getClauses(OBOFormatConstants.OboFormatTag.TAG_XREF);
            for (Clause c : clauses) {
                String xid;
                String s2;
                Xref x = c.getValue(Xref.class);
                if (x == null || !this.treatMap.containsKey(s2 = XrefExpander.getIDSpace(xid = x.getIdref()))) continue;
                this.treatMap.get(s2).expand(f, id, xid);
            }
        }
    }

    private static String getIDSpace(@Nonnull String x) {
        String[] parts = x.split(":", 2);
        return parts[0];
    }

    public class RelationshipExpansion
    extends Rule {
        protected final String rel;

        public RelationshipExpansion(String rel) {
            this.rel = rel;
        }

        @Override
        public void expand(Frame sf, String id, String xRef) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP, this.rel);
            c.addValue(xRef);
            this.getTargetFrame(id).addClause(c);
        }
    }

    public class IsaExpansion
    extends Rule {
        @Override
        public void expand(Frame sf, String id, String xRef) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, xRef);
            this.getTargetFrame(id).addClause(c);
        }
    }

    public class ReverseGenusDifferentiaExpansion
    extends Rule {
        protected final String rel;
        protected final String tgt;

        public ReverseGenusDifferentiaExpansion(String rel, String tgt) {
            this.rel = rel;
            this.tgt = tgt;
        }

        @Override
        public void expand(Frame sf, String id, String xRef) {
            Clause gc = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF, id);
            Clause dc = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF);
            dc.setValue(this.rel);
            dc.addValue(this.tgt);
            this.getTargetFrame(xRef).addClause(gc);
            this.getTargetFrame(xRef).addClause(dc);
        }
    }

    public class GenusDifferentiaExpansion
    extends Rule {
        protected final String rel;
        protected final String tgt;

        public GenusDifferentiaExpansion(String rel, String tgt) {
            this.rel = rel;
            this.tgt = tgt;
        }

        @Override
        public void expand(Frame sf, String id, String xRef) {
            Clause gc = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF, xRef);
            Clause dc = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF);
            dc.setValue(this.rel);
            dc.addValue(this.tgt);
            this.getTargetFrame(id).addClause(gc);
            this.getTargetFrame(id).addClause(dc);
        }
    }

    public class HasSubClassExpansion
    extends Rule {
        @Override
        public void expand(Frame sf, String id, String xRef) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, id);
            this.getTargetFrame(xRef).addClause(c);
        }
    }

    public class EquivalenceExpansion
    extends Rule {
        @Override
        public void expand(@Nonnull Frame sf, String id, String xRef) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO, xRef);
            sf.addClause(c);
        }
    }

    public abstract class Rule {
        protected String xref;
        public String idSpace;

        public abstract void expand(@Nonnull Frame var1, String var2, String var3);

        @Nonnull
        protected Frame getTargetFrame(String id) {
            Frame f = XrefExpander.this.getTargetDoc(this.idSpace).getTermFrame(id);
            if (f == null) {
                f = new Frame();
                f.setId(id);
                try {
                    XrefExpander.this.getTargetDoc(this.idSpace).addTermFrame(f);
                }
                catch (FrameMergeException e) {
                    LOG.error("Frame merge exceptions should not be possible", e);
                }
            }
            return f;
        }
    }
}

