/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.krss1.parser.NameResolverStrategy;
import org.semanticweb.owlapi.krss2.parser.JavaCharStream;
import org.semanticweb.owlapi.krss2.parser.KRSS2OWLParserException;
import org.semanticweb.owlapi.krss2.parser.KRSS2ParserConstants;
import org.semanticweb.owlapi.krss2.parser.KRSS2ParserTokenManager;
import org.semanticweb.owlapi.krss2.parser.ParseException;
import org.semanticweb.owlapi.krss2.parser.Token;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

class KRSS2Parser
implements KRSS2ParserConstants {
    private OWLOntology ontology;
    private OWLDataFactory dataFactory;
    private Map<String, IRI> string2IRI;
    private String base;
    private NameResolverStrategy nameResolution;
    private int adaptiveMaxRuns = 10;
    private boolean alwaysIRIs = false;
    private boolean alwaysNames = false;
    private KRSS2ParserTokenManager token_source;
    private JavaCharStream jj_input_stream;
    private Token token;
    private Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[77];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    void setOntology(OWLOntology ontology, OWLDataFactory dataFactory) {
        this.ontology = ontology;
        this.dataFactory = dataFactory;
        this.string2IRI = new HashMap<String, IRI>();
        OWLOntologyID id = ontology.getOntologyID();
        this.base = !id.isAnonymous() ? id.getOntologyIRI().get().toString() + "#" : id.toString() + "#";
        this.nameResolution = NameResolverStrategy.CHECK;
    }

    protected void addAxiom(OWLAxiom ax) {
        try {
            ((OWLMutableOntology)this.ontology).applyChange(new AddAxiom(this.ontology, ax));
        }
        catch (OWLOntologyChangeException e) {
            throw new KRSS2OWLParserException(e);
        }
    }

    IRI getIRI(String s2) throws URISyntaxException {
        IRI iri = this.string2IRI.get(s2);
        if (iri == null) {
            switch (this.nameResolution) {
                case IRI: {
                    iri = IRI.create(s2);
                    break;
                }
                case NAME: {
                    iri = IRI.create(this.base + s2);
                    break;
                }
                case ADAPTIVE: {
                    if (this.adaptiveMaxRuns <= 1) {
                        this.nameResolution = this.alwaysIRIs && !this.alwaysNames ? NameResolverStrategy.IRI : (this.alwaysNames && !this.alwaysIRIs ? NameResolverStrategy.NAME : NameResolverStrategy.CHECK);
                    }
                    --this.adaptiveMaxRuns;
                }
                case CHECK: {
                    String ns = XMLUtils.getNCNamePrefix(s2);
                    if (ns.equals("")) {
                        iri = IRI.create(this.base + s2);
                        break;
                    }
                    iri = IRI.create(s2);
                    break;
                }
            }
            this.string2IRI.put(s2, iri);
        }
        return iri;
    }

    void setNameResolution(NameResolverStrategy nameResolution) {
        this.nameResolution = nameResolution;
    }

    void parse() {
        while (this.jj_2_1(2)) {
            this.TBoxStatement();
        }
        if (this.jj_2_2(2)) {
            this.jj_consume_token(20);
        }
        while (this.jj_2_3(2)) {
            this.ABoxStatement();
        }
        if (this.jj_2_4(2)) {
            this.jj_consume_token(21);
        }
        this.jj_consume_token(0);
    }

    private void TBoxStatement() {
        if (this.jj_2_5(2)) {
            this.DefinePrimitiveConcept();
        } else if (this.jj_2_6(2)) {
            this.DefineConcept();
        } else if (this.jj_2_7(2)) {
            this.Implies();
        } else if (this.jj_2_8(2)) {
            this.Equivalent();
        } else if (this.jj_2_9(2)) {
            this.Disjoint();
        } else if (this.jj_2_10(2)) {
            this.ComplexRoleInclusion();
        } else if (this.jj_2_11(2)) {
            this.DefinePrimitiveRole();
        } else if (this.jj_2_12(2)) {
            this.DefineRole();
        } else if (this.jj_2_13(2)) {
            this.DisjointRoles();
        } else if (this.jj_2_14(2)) {
            this.RolesEquivalent();
        } else if (this.jj_2_15(2)) {
            this.ImpliesRole();
        } else if (this.jj_2_16(2)) {
            this.Inverses();
        } else if (this.jj_2_17(2)) {
            this.Range();
        } else if (this.jj_2_18(2)) {
            this.Transitive();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    private void DefinePrimitiveConcept() {
        OWLClassExpression subClass = null;
        OWLClassExpression superClass = null;
        this.jj_consume_token(18);
        this.jj_consume_token(24);
        subClass = this.ConceptName();
        if (this.jj_2_19(2)) {
            superClass = this.ConceptExpression();
        }
        this.jj_consume_token(19);
        if (superClass == null) {
            this.addAxiom(this.dataFactory.getOWLSubClassOfAxiom(subClass, this.dataFactory.getOWLThing()));
        } else {
            this.addAxiom(this.dataFactory.getOWLSubClassOfAxiom(subClass, superClass));
        }
    }

    private void DefineConcept() {
        this.jj_consume_token(18);
        this.jj_consume_token(23);
        OWLClassExpression clsA = this.ConceptName();
        OWLClassExpression clsB = this.ConceptExpression();
        this.jj_consume_token(19);
        if (clsB == null) {
            clsB = this.dataFactory.getOWLThing();
        }
        this.addAxiom(this.dataFactory.getOWLEquivalentClassesAxiom(clsA, clsB));
    }

    private void Disjoint() {
        this.jj_consume_token(18);
        this.jj_consume_token(25);
        OWLClassExpression desc1 = this.ConceptExpression();
        OWLClassExpression desc2 = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLDisjointClassesAxiom(desc1, desc2));
    }

    private void Equivalent() {
        this.jj_consume_token(18);
        this.jj_consume_token(26);
        OWLClassExpression desc1 = this.ConceptExpression();
        OWLClassExpression desc2 = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLEquivalentClassesAxiom(desc1, desc2));
    }

    private void Implies() {
        this.jj_consume_token(18);
        this.jj_consume_token(27);
        OWLClassExpression subDescription = this.ConceptExpression();
        OWLClassExpression superDescription = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLSubClassOfAxiom(subDescription, superDescription));
    }

    private void DefineRole() {
        this.jj_consume_token(18);
        this.jj_consume_token(37);
        OWLObjectPropertyExpression propA = this.RoleExpression();
        OWLObjectPropertyExpression propB = this.RoleExpression();
        this.jj_consume_token(19);
        HashSet<OWLObjectPropertyExpression> ops = new HashSet<OWLObjectPropertyExpression>();
        ops.add(propA);
        ops.add(propB);
        this.addAxiom(this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(ops));
    }

    private void DefinePrimitiveRole() {
        this.jj_consume_token(18);
        this.jj_consume_token(38);
        OWLObjectProperty subProp = this.RoleName();
        if (subProp != null) {
            this.addAxiom(this.dataFactory.getOWLDeclarationAxiom(subProp));
        }
        this.Parent(subProp);
        this.RightIdentity(subProp);
        this.Parents(subProp);
        this.DomainAttribute(subProp);
        this.RangeAttribute(subProp);
        this.TransitiveAttribute(subProp);
        this.SymmetricAttribute(subProp);
        this.ReflexiveAttribute(subProp);
        this.InverseProperty(subProp);
        this.jj_consume_token(19);
    }

    private void RightIdentity(OWLObjectProperty r) {
        if (this.jj_2_20(2)) {
            this.jj_consume_token(51);
            OWLObjectProperty s2 = this.RoleName();
            ArrayList<OWLObjectProperty> chain = new ArrayList<OWLObjectProperty>(2);
            chain.add(r);
            chain.add(s2);
            this.addAxiom(this.dataFactory.getOWLSubPropertyChainOfAxiom(chain, r));
        }
    }

    private void LeftIdentity(OWLObjectProperty r) {
        if (this.jj_2_21(2)) {
            this.jj_consume_token(45);
            OWLObjectProperty s2 = this.RoleName();
            ArrayList<OWLObjectProperty> chain = new ArrayList<OWLObjectProperty>(2);
            chain.add(s2);
            chain.add(r);
            this.addAxiom(this.dataFactory.getOWLSubPropertyChainOfAxiom(chain, r));
        }
    }

    private void InverseProperty(OWLObjectProperty subProp) {
        if (this.jj_2_22(2)) {
            this.jj_consume_token(44);
            OWLObjectPropertyExpression superProp = this.RoleExpression();
            this.addAxiom(this.dataFactory.getOWLInverseObjectPropertiesAxiom(subProp, superProp));
        }
    }

    private void DomainAttribute(OWLObjectProperty subProp) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        if (this.jj_2_26(2)) {
            OWLClassExpression desc;
            this.jj_consume_token(40);
            if (this.jj_2_24(2)) {
                this.jj_consume_token(18);
                do {
                    if ((desc = this.ConceptExpression()) == null) continue;
                    descs.add(desc);
                } while (this.jj_2_23(2));
                this.jj_consume_token(19);
            } else if (this.jj_2_25(2)) {
                desc = this.ConceptExpression();
                descs.add(desc);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            for (OWLClassExpression eachDescription : descs) {
                this.addAxiom(this.dataFactory.getOWLObjectPropertyDomainAxiom(subProp, eachDescription));
            }
        }
    }

    private void RangeAttribute(OWLObjectProperty subProp) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        if (this.jj_2_30(2)) {
            OWLClassExpression desc;
            this.jj_consume_token(49);
            if (this.jj_2_28(2)) {
                this.jj_consume_token(18);
                do {
                    if ((desc = this.ConceptExpression()) == null) continue;
                    descs.add(desc);
                } while (this.jj_2_27(2));
                this.jj_consume_token(19);
            } else if (this.jj_2_29(2)) {
                desc = this.ConceptExpression();
                descs.add(desc);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            for (OWLClassExpression eachDescription : descs) {
                this.addAxiom(this.dataFactory.getOWLObjectPropertyRangeAxiom(subProp, eachDescription));
            }
        }
    }

    private void TransitiveAttribute(OWLObjectProperty property) {
        if (this.jj_2_33(2)) {
            this.jj_consume_token(57);
            if (this.jj_2_31(2)) {
                this.jj_consume_token(16);
            } else if (this.jj_2_32(2)) {
                this.jj_consume_token(17);
                this.addAxiom(this.dataFactory.getOWLTransitiveObjectPropertyAxiom(property));
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private void SymmetricAttribute(OWLObjectProperty property) {
        if (this.jj_2_36(2)) {
            this.jj_consume_token(55);
            if (this.jj_2_34(2)) {
                this.jj_consume_token(16);
            } else if (this.jj_2_35(2)) {
                this.jj_consume_token(17);
                this.addAxiom(this.dataFactory.getOWLSymmetricObjectPropertyAxiom(property));
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private void ReflexiveAttribute(OWLObjectProperty property) {
        if (this.jj_2_39(2)) {
            this.jj_consume_token(50);
            if (this.jj_2_37(2)) {
                this.jj_consume_token(16);
            } else if (this.jj_2_38(2)) {
                this.jj_consume_token(17);
                this.addAxiom(this.dataFactory.getOWLReflexiveObjectPropertyAxiom(property));
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void Parents(OWLObjectProperty subProp) {
        if (!this.jj_2_46(2)) return;
        if (this.jj_2_44(2)) {
            this.jj_consume_token(47);
            if (this.jj_2_40(2)) {
                this.jj_consume_token(16);
                return;
            }
            if (!this.jj_2_41(2)) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(18);
            Set<OWLObjectProperty> roles = this.RoleNameSet();
            this.jj_consume_token(19);
            if (roles == null) return;
            Iterator<OWLObjectProperty> iterator = roles.iterator();
            while (iterator.hasNext()) {
                OWLObjectProperty prop = iterator.next();
                this.addAxiom(this.dataFactory.getOWLSubObjectPropertyOfAxiom(subProp, prop));
            }
            return;
        }
        if (!this.jj_2_45(2)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(46);
        if (this.jj_2_42(2)) {
            this.jj_consume_token(16);
            return;
        }
        if (this.jj_2_43(2)) {
            OWLObjectProperty superProp = this.RoleName();
            this.addAxiom(this.dataFactory.getOWLSubObjectPropertyOfAxiom(subProp, superProp));
            return;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private void Parent(OWLObjectProperty subProp) {
        if (this.jj_2_47(2)) {
            OWLObjectProperty superProp = this.RoleName();
            this.addAxiom(this.dataFactory.getOWLSubObjectPropertyOfAxiom(subProp, superProp));
        }
    }

    private void DisjointRoles() {
        this.jj_consume_token(18);
        this.jj_consume_token(39);
        OWLObjectPropertyExpression exp1 = this.RoleExpression();
        OWLObjectPropertyExpression exp2 = this.RoleExpression();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLDisjointObjectPropertiesAxiom(exp1, exp2));
    }

    private void ImpliesRole() {
        this.jj_consume_token(18);
        this.jj_consume_token(41);
        OWLObjectPropertyExpression subProp = this.RoleExpression();
        OWLObjectPropertyExpression superProp = this.RoleExpression();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLSubObjectPropertyOfAxiom(subProp, superProp));
    }

    private void Inverses() {
        this.jj_consume_token(18);
        this.jj_consume_token(43);
        OWLObjectPropertyExpression prop1 = this.RoleExpression();
        OWLObjectPropertyExpression prop2 = this.RoleExpression();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLInverseObjectPropertiesAxiom(prop1, prop2));
    }

    private void RolesEquivalent() {
        this.jj_consume_token(18);
        this.jj_consume_token(52);
        OWLObjectPropertyExpression exp1 = this.RoleExpression();
        OWLObjectPropertyExpression exp2 = this.RoleExpression();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(exp1, exp2));
    }

    private void ComplexRoleInclusion() {
        this.jj_consume_token(18);
        this.jj_consume_token(53);
        List<OWLObjectPropertyExpression> chain = this.propertyChain();
        OWLObjectProperty superProp = this.RoleName();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLSubPropertyChainOfAxiom(chain, superProp));
    }

    private List<OWLObjectPropertyExpression> propertyChain() {
        ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
        this.jj_consume_token(18);
        this.jj_consume_token(22);
        OWLObjectPropertyExpression prop = this.RoleExpression();
        chain.add(prop);
        if (this.jj_2_48(2)) {
            List<OWLObjectPropertyExpression> subChain = this.propertyChain();
            chain.addAll(subChain);
        } else if (this.jj_2_49(2)) {
            prop = this.RoleExpression();
            chain.add(prop);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(19);
        return chain;
    }

    private void Transitive() {
        this.jj_consume_token(18);
        this.jj_consume_token(56);
        OWLObjectProperty prop = this.RoleName();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop));
    }

    private void Range() {
        this.jj_consume_token(18);
        this.jj_consume_token(48);
        OWLObjectProperty prop = this.RoleName();
        OWLClassExpression rng = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, rng));
    }

    private OWLClassExpression ConceptExpression() {
        OWLClassExpression desc;
        if (this.jj_2_50(2)) {
            desc = this.ConceptName();
        } else if (this.jj_2_51(2)) {
            desc = this.And();
        } else if (this.jj_2_52(2)) {
            desc = this.Or();
        } else if (this.jj_2_53(2)) {
            desc = this.Not();
        } else if (this.jj_2_54(2)) {
            desc = this.All();
        } else if (this.jj_2_55(2)) {
            desc = this.Some();
        } else if (this.jj_2_56(2)) {
            desc = this.AtLeast();
        } else if (this.jj_2_57(2)) {
            desc = this.AtMost();
        } else if (this.jj_2_58(2)) {
            desc = this.Exactly();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    private OWLClassExpression ConceptName() {
        IRI IRI2 = this.Name();
        return this.dataFactory.getOWLClass(IRI2);
    }

    private Set<OWLClassExpression> ConceptSet() {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        do {
            OWLClassExpression desc = this.ConceptExpression();
            descs.add(desc);
        } while (this.jj_2_59(2));
        return descs;
    }

    private OWLClassExpression And() {
        this.jj_consume_token(18);
        this.jj_consume_token(28);
        Set<OWLClassExpression> operands = this.ConceptSet();
        this.jj_consume_token(19);
        return this.dataFactory.getOWLObjectIntersectionOf(operands);
    }

    private OWLClassExpression Or() {
        this.jj_consume_token(18);
        this.jj_consume_token(29);
        Set<OWLClassExpression> operands = this.ConceptSet();
        this.jj_consume_token(19);
        return this.dataFactory.getOWLObjectUnionOf(operands);
    }

    private OWLClassExpression Not() {
        this.jj_consume_token(18);
        this.jj_consume_token(30);
        OWLClassExpression operand = this.ConceptExpression();
        this.jj_consume_token(19);
        return this.dataFactory.getOWLObjectComplementOf(operand);
    }

    private OWLClassExpression All() {
        this.jj_consume_token(18);
        this.jj_consume_token(31);
        OWLObjectPropertyExpression prop = this.RoleExpression();
        OWLClassExpression filler = this.ConceptExpression();
        this.jj_consume_token(19);
        return this.dataFactory.getOWLObjectAllValuesFrom(prop, filler);
    }

    private OWLClassExpression Some() {
        this.jj_consume_token(18);
        this.jj_consume_token(33);
        OWLObjectPropertyExpression prop = this.RoleExpression();
        OWLClassExpression filler = this.ConceptExpression();
        this.jj_consume_token(19);
        return this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
    }

    private OWLClassExpression AtLeast() {
        OWLClassExpression filler = null;
        this.jj_consume_token(18);
        this.jj_consume_token(34);
        int card = this.Integer();
        OWLObjectPropertyExpression prop = this.RoleExpression();
        if (this.jj_2_60(2)) {
            filler = this.ConceptExpression();
        }
        this.jj_consume_token(19);
        if (filler == null) {
            return this.dataFactory.getOWLObjectMinCardinality(card, prop);
        }
        return this.dataFactory.getOWLObjectMinCardinality(card, prop, filler);
    }

    private OWLClassExpression AtMost() {
        OWLClassExpression filler = null;
        this.jj_consume_token(18);
        this.jj_consume_token(35);
        int card = this.Integer();
        OWLObjectPropertyExpression prop = this.RoleExpression();
        if (this.jj_2_61(2)) {
            filler = this.ConceptExpression();
        }
        this.jj_consume_token(19);
        if (filler == null) {
            return this.dataFactory.getOWLObjectMaxCardinality(card, prop);
        }
        return this.dataFactory.getOWLObjectMaxCardinality(card, prop, filler);
    }

    private OWLClassExpression Exactly() {
        OWLClassExpression filler = null;
        this.jj_consume_token(18);
        this.jj_consume_token(36);
        int card = this.Integer();
        OWLObjectPropertyExpression prop = this.RoleExpression();
        if (this.jj_2_62(2)) {
            filler = this.ConceptExpression();
        }
        this.jj_consume_token(19);
        if (filler == null) {
            return this.dataFactory.getOWLObjectExactCardinality(card, prop);
        }
        return this.dataFactory.getOWLObjectExactCardinality(card, prop, filler);
    }

    private OWLObjectProperty RoleName() {
        IRI IRI2 = this.Name();
        if (IRI2 == null) {
            return null;
        }
        return this.dataFactory.getOWLObjectProperty(IRI2);
    }

    private Set<OWLObjectProperty> RoleNameSet() {
        HashSet<OWLObjectProperty> roles = new HashSet<OWLObjectProperty>();
        do {
            OWLObjectProperty role = this.RoleName();
            roles.add(role);
        } while (this.jj_2_63(2));
        return roles;
    }

    private OWLObjectPropertyExpression RoleExpression() {
        if (this.jj_2_64(2)) {
            this.jj_consume_token(18);
            this.jj_consume_token(42);
            OWLObjectPropertyExpression exp = this.RoleExpression();
            this.jj_consume_token(19);
            return this.dataFactory.getOWLObjectInverseOf(exp);
        }
        if (this.jj_2_65(2)) {
            OWLObjectProperty exp = this.RoleName();
            return exp;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private void ABoxStatement() {
        if (this.jj_2_66(2)) {
            this.Instance();
        } else if (this.jj_2_67(2)) {
            this.Related();
        } else if (this.jj_2_68(2)) {
            this.Equal();
        } else if (this.jj_2_69(2)) {
            this.Distinct();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    private void Instance() {
        this.jj_consume_token(18);
        this.jj_consume_token(61);
        OWLIndividual ind = this.IndividualName();
        OWLClassExpression type = this.ConceptExpression();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLClassAssertionAxiom(type, ind));
    }

    private void Related() {
        this.jj_consume_token(18);
        this.jj_consume_token(62);
        OWLIndividual subj = this.IndividualName();
        OWLObjectProperty prop = this.RoleName();
        OWLIndividual obj = this.IndividualName();
        this.jj_consume_token(19);
        this.addAxiom(this.dataFactory.getOWLObjectPropertyAssertionAxiom(prop, subj, obj));
    }

    private void Equal() {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        this.jj_consume_token(18);
        this.jj_consume_token(60);
        OWLIndividual indA = this.IndividualName();
        OWLIndividual indB = this.IndividualName();
        this.jj_consume_token(19);
        inds.add(indA);
        inds.add(indB);
        this.addAxiom(this.dataFactory.getOWLSameIndividualAxiom(inds));
    }

    private void Distinct() {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        this.jj_consume_token(18);
        this.jj_consume_token(59);
        OWLIndividual indA = this.IndividualName();
        OWLIndividual indB = this.IndividualName();
        this.jj_consume_token(19);
        inds.add(indA);
        inds.add(indB);
        this.addAxiom(this.dataFactory.getOWLDifferentIndividualsAxiom(inds));
    }

    private OWLIndividual IndividualName() {
        IRI name = this.Name();
        return this.dataFactory.getOWLNamedIndividual(name);
    }

    private int Integer() {
        Token t = this.jj_consume_token(65);
        return Integer.parseInt(t.image);
    }

    private boolean parseBoolean() {
        if (this.jj_2_70(2)) {
            this.jj_consume_token(17);
            return true;
        }
        if (this.jj_2_71(2)) {
            this.jj_consume_token(16);
            return false;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private IRI Name() {
        if (this.jj_2_76(2)) {
            Token t;
            if (this.jj_2_72(2)) {
                t = this.jj_consume_token(66);
            } else if (this.jj_2_73(2)) {
                t = this.jj_consume_token(65);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            try {
                return this.getIRI(t.image);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        if (this.jj_2_77(2)) {
            if (this.jj_2_74(2)) {
                Token t = this.jj_consume_token(14);
                return OWLRDFVocabulary.OWL_THING.getIRI();
            }
            if (this.jj_2_75(2)) {
                Token t = this.jj_consume_token(15);
                return OWLRDFVocabulary.OWL_NOTHING.getIRI();
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_69(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_70(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_71(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_72(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_73(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_74(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_75(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_76(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_77(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, xla);
        }
    }

    private boolean jj_3_19() {
        return this.jj_3R_23();
    }

    private boolean jj_3_9() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_36() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3_13() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_19() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(41);
    }

    private boolean jj_3_25() {
        return this.jj_3R_23();
    }

    private boolean jj_3_43() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_11() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(27);
    }

    private boolean jj_3_42() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_57() {
        return this.jj_3R_35();
    }

    private boolean jj_3_8() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_35() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_17() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_12() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3_12() {
        return this.jj_3R_16();
    }

    private boolean jj_3_45() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_43()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        return this.jj_3R_11();
    }

    private boolean jj_3_4() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3_47() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_13() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3_56() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_34() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_18() {
        return this.jj_3R_22();
    }

    private boolean jj_3_38() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3_41() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3_49() {
        return this.jj_3R_25();
    }

    private boolean jj_3_75() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3_73() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3_71() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_17() {
        return this.jj_3R_21();
    }

    private boolean jj_3_74() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_33() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_10() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3_77() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_75()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_37() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_40() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_55() {
        return this.jj_3R_33();
    }

    private boolean jj_3_6() {
        return this.jj_3R_10();
    }

    private boolean jj_3_11() {
        return this.jj_3R_15();
    }

    private boolean jj_3_35() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3_3() {
        return this.jj_3R_8();
    }

    private boolean jj_3_72() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3_76() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_72()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_73()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_76()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_77()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_34() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_44() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_41()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_44()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_45()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3_16() {
        return this.jj_3R_20();
    }

    private boolean jj_3_32() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_9() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_54() {
        return this.jj_3R_32();
    }

    private boolean jj_3_31() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3_70() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_31() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(30);
    }

    private boolean jj_3_39() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_37()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_38()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_27() {
        return this.jj_3R_23();
    }

    private boolean jj_3_15() {
        return this.jj_3R_19();
    }

    private boolean jj_3_53() {
        return this.jj_3R_31();
    }

    private boolean jj_3_10() {
        return this.jj_3R_14();
    }

    private boolean jj_3_5() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_7()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_8()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_9()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_10()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_11()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_12()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_13()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_14()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_15()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3_16()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3_17()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3_18()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_36() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_35()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_30() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3_28() {
        Token xsp;
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_3_27()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_27());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_7();
    }

    private boolean jj_3_23() {
        return this.jj_3R_23();
    }

    private boolean jj_3_52() {
        return this.jj_3R_30();
    }

    private boolean jj_3_33() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_32()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_29() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(28);
    }

    private boolean jj_3_24() {
        Token xsp;
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_3_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_23());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_48() {
        return this.jj_3R_27();
    }

    private boolean jj_3_59() {
        return this.jj_3R_23();
    }

    private boolean jj_3_30() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_29()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_51() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_40() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(59);
    }

    private boolean jj_3R_28() {
        return this.jj_3R_41();
    }

    private boolean jj_3_69() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_39() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(60);
    }

    private boolean jj_3_26() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_25()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_50() {
        return this.jj_3R_28();
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_51()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_52()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_53()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_54()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_55()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_56()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_57()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_58()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_68() {
        return this.jj_3R_39();
    }

    private boolean jj_3R_38() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(62);
    }

    private boolean jj_3_22() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3R_21() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private boolean jj_3_67() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_37() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(61);
    }

    private boolean jj_3_21() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3_62() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(56);
    }

    private boolean jj_3_66() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_66()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_67()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_68()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_69()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_20() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3R_27() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3_61() {
        return this.jj_3R_23();
    }

    private boolean jj_3_65() {
        return this.jj_3R_24();
    }

    private boolean jj_3_64() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_64()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_65()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_14() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_15() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(38);
    }

    private boolean jj_3_60() {
        return this.jj_3R_23();
    }

    private boolean jj_3_63() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_26() {
        Token xsp;
        if (this.jj_3_63()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_63());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_18() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(52);
    }

    private boolean jj_3_14() {
        return this.jj_3R_18();
    }

    private boolean jj_3R_24() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_16() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(37);
    }

    private boolean jj_3_29() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_20() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(43);
    }

    private boolean jj_3_58() {
        return this.jj_3R_36();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[0];
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[0];
    }

    KRSS2Parser(InputStream stream) {
        this(stream, null);
    }

    KRSS2Parser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLRuntimeException(e);
        }
        this.token_source = new KRSS2ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLRuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    KRSS2Parser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new KRSS2ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    KRSS2Parser(KRSS2ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    void ReInit(KRSS2ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[70];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 70; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 77; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                            break;
                        }
                        case 52: {
                            this.jj_3_53();
                            break;
                        }
                        case 53: {
                            this.jj_3_54();
                            break;
                        }
                        case 54: {
                            this.jj_3_55();
                            break;
                        }
                        case 55: {
                            this.jj_3_56();
                            break;
                        }
                        case 56: {
                            this.jj_3_57();
                            break;
                        }
                        case 57: {
                            this.jj_3_58();
                            break;
                        }
                        case 58: {
                            this.jj_3_59();
                            break;
                        }
                        case 59: {
                            this.jj_3_60();
                            break;
                        }
                        case 60: {
                            this.jj_3_61();
                            break;
                        }
                        case 61: {
                            this.jj_3_62();
                            break;
                        }
                        case 62: {
                            this.jj_3_63();
                            break;
                        }
                        case 63: {
                            this.jj_3_64();
                            break;
                        }
                        case 64: {
                            this.jj_3_65();
                            break;
                        }
                        case 65: {
                            this.jj_3_66();
                            break;
                        }
                        case 66: {
                            this.jj_3_67();
                            break;
                        }
                        case 67: {
                            this.jj_3_68();
                            break;
                        }
                        case 68: {
                            this.jj_3_69();
                            break;
                        }
                        case 69: {
                            this.jj_3_70();
                            break;
                        }
                        case 70: {
                            this.jj_3_71();
                            break;
                        }
                        case 71: {
                            this.jj_3_72();
                            break;
                        }
                        case 72: {
                            this.jj_3_73();
                            break;
                        }
                        case 73: {
                            this.jj_3_74();
                            break;
                        }
                        case 74: {
                            this.jj_3_75();
                            break;
                        }
                        case 75: {
                            this.jj_3_76();
                            break;
                        }
                        case 76: {
                            this.jj_3_77();
                            break;
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        KRSS2Parser.jj_la1_init_0();
        KRSS2Parser.jj_la1_init_1();
        KRSS2Parser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends OWLRuntimeException {
        private static final long serialVersionUID = 40000L;
    }
}

