/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.owlxml.parser.AbstractClassExpressionElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractIRIElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLAxiomElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLDataRangeHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLObjectPropertyElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnnotationElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnnotationPropertyElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnonymousIndividualElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLDataPropertyElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLDatatypeFacetRestrictionElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLIndividualElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLLiteralElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLSubObjectPropertyChainElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserAttributeNotFoundException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserElementNotFoundException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserHandler;
import org.semanticweb.owlapi.owlxml.parser.SWRLAtomElementHandler;
import org.semanticweb.owlapi.owlxml.parser.SWRLAtomListElementHandler;
import org.semanticweb.owlapi.owlxml.parser.SWRLVariableElementHandler;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

abstract class OWLElementHandler<O> {
    @Nonnull
    final OWLXMLParserHandler handler;
    OWLElementHandler<?> parentHandler;
    @Nonnull
    final StringBuilder sb = new StringBuilder();
    String elementName;
    @Nonnull
    final OWLDataFactory df;

    @Nonnull
    abstract O getOWLObject();

    abstract void endElement();

    OWLElementHandler(@Nonnull OWLXMLParserHandler handler) {
        this.handler = handler;
        this.df = handler.getDataFactory();
    }

    @Nonnull
    IRI getIRIFromAttribute(@Nonnull String localName, @Nonnull String value) {
        if (localName.equals(OWLXMLVocabulary.IRI_ATTRIBUTE.getShortForm())) {
            return this.handler.getIRI(value);
        }
        if (localName.equals(OWLXMLVocabulary.ABBREVIATED_IRI_ATTRIBUTE.getShortForm())) {
            return this.handler.getAbbreviatedIRI(value);
        }
        if (localName.equals("URI")) {
            return this.handler.getIRI(value);
        }
        this.ensureAttributeNotNull(null, OWLXMLVocabulary.IRI_ATTRIBUTE.getShortForm());
        return IRI.create("");
    }

    IRI getIRIFromElement(@Nonnull String elementLocalName, @Nonnull String textContent) {
        if (elementLocalName.equals(OWLXMLVocabulary.IRI_ELEMENT.getShortForm())) {
            return this.handler.getIRI(textContent.trim());
        }
        if (elementLocalName.equals(OWLXMLVocabulary.ABBREVIATED_IRI_ELEMENT.getShortForm())) {
            return this.handler.getAbbreviatedIRI(textContent.trim());
        }
        throw new OWLXMLParserException(this.handler, elementLocalName + " is not an IRI element");
    }

    void setParentHandler(@Nonnull OWLElementHandler<?> handler) {
        this.parentHandler = handler;
    }

    @Nonnull
    OWLElementHandler<?> getParentHandler() {
        return OWLAPIPreconditions.verifyNotNull(this.parentHandler, "parentHandler cannot be null at this point");
    }

    void attribute(@Nonnull String localName, @Nonnull String value) {
    }

    void startElement(@Nonnull String name) {
        this.elementName = name;
    }

    String getElementName() {
        return this.elementName;
    }

    void handleChild(@Nonnull AbstractOWLAxiomElementHandler h2) {
    }

    void handleChild(@Nonnull AbstractClassExpressionElementHandler h2) {
    }

    void handleChild(@Nonnull AbstractOWLDataRangeHandler h2) {
    }

    void handleChild(@Nonnull AbstractOWLObjectPropertyElementHandler h2) {
    }

    void handleChild(@Nonnull OWLDataPropertyElementHandler h2) {
    }

    void handleChild(@Nonnull OWLIndividualElementHandler h2) {
    }

    void handleChild(@Nonnull OWLLiteralElementHandler h2) {
    }

    void handleChild(@Nonnull OWLAnnotationElementHandler h2) {
    }

    void handleChild(@Nonnull OWLSubObjectPropertyChainElementHandler h2) {
    }

    void handleChild(@Nonnull OWLDatatypeFacetRestrictionElementHandler h2) {
    }

    void handleChild(@Nonnull OWLAnnotationPropertyElementHandler h2) {
    }

    void handleChild(@Nonnull OWLAnonymousIndividualElementHandler h2) {
    }

    void handleChild(@Nonnull AbstractIRIElementHandler h2) {
    }

    void handleChild(@Nonnull SWRLVariableElementHandler h2) {
    }

    void handleChild(@Nonnull SWRLAtomElementHandler h2) {
    }

    void handleChild(@Nonnull SWRLAtomListElementHandler h2) {
    }

    void ensureNotNull(@Nullable Object element, String message) {
        if (element == null) {
            throw new OWLXMLParserElementNotFoundException(this.handler, message);
        }
    }

    void ensureAttributeNotNull(@Nullable Object element, String message) {
        if (element == null) {
            throw new OWLXMLParserAttributeNotFoundException(this.handler, message);
        }
    }

    void handleChars(char[] chars, int start, int length) {
        if (this.isTextContentPossible()) {
            this.sb.append(chars, start, length);
        }
    }

    @Nonnull
    String getText() {
        return this.sb.toString();
    }

    boolean isTextContentPossible() {
        return false;
    }
}

