/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLZipSaver {
    public static final String YAML_INDEX_NAME = "owlzip.yaml";
    public static final String PROPERTIES_INDEX_NAME = "owlzip.properties";
    public static final String CATALOG_INDEX_NAME = "catalog.xml";
    private Function<OWLOntologyID, String> entryPath = this::entryPath;
    private BiFunction<Collection<OWLOntology>, Collection<OWLOntology>, String> index = this::yamlIndex;
    private Supplier<String> indexName = () -> "owlzip.yaml";

    public void setEntryPath(Function<OWLOntologyID, String> entryPath) {
        this.entryPath = entryPath;
    }

    public void setIndex(BiFunction<Collection<OWLOntology>, Collection<OWLOntology>, String> index) {
        this.index = index;
    }

    public void setIndexName(Supplier<String> indexName) {
        this.indexName = indexName;
    }

    public void saveImportsClosure(OWLOntology root, OutputStream out) throws IOException, OWLOntologyStorageException {
        Set<OWLOntology> importsClosure = root.getImportsClosure();
        importsClosure.remove(root);
        this.saveOntologies(Collections.singletonList(root), importsClosure, out);
    }

    public void saveImportsClosures(Collection<OWLOntology> roots, OutputStream out) throws IOException, OWLOntologyStorageException {
        Set<OWLOntology> set = roots.stream().flatMap(o -> o.getImportsClosure().stream()).collect(Collectors.toSet());
        set.removeAll(roots);
        this.saveOntologies(roots, set, out);
    }

    public void saveOntologies(Collection<OWLOntology> ontologies, OutputStream out) throws IOException, OWLOntologyStorageException {
        this.saveOntologies(Collections.emptyList(), ontologies, out);
    }

    public void saveOntologies(Collection<OWLOntology> roots, Collection<OWLOntology> ontologies, OutputStream out) throws IOException, OWLOntologyStorageException {
        try (ZipOutputStream f = new ZipOutputStream(out);){
            ByteArrayOutputStream temp;
            ZipEntry next;
            this.addIndex(roots, ontologies, f);
            for (OWLOntology o : roots) {
                next = new ZipEntry(this.entryPath.apply(o.getOntologyID()));
                f.putNextEntry(next);
                temp = new ByteArrayOutputStream();
                o.saveOntology(temp);
                f.write(temp.toByteArray());
            }
            for (OWLOntology o : ontologies) {
                next = new ZipEntry(this.entryPath.apply(o.getOntologyID()));
                f.putNextEntry(next);
                temp = new ByteArrayOutputStream();
                o.saveOntology(temp);
                f.write(temp.toByteArray());
            }
            f.close();
        }
    }

    protected void addIndex(Collection<OWLOntology> roots, Collection<OWLOntology> ontologies, ZipOutputStream f) throws IOException {
        String name = this.indexName.get();
        if (name != null && !name.isEmpty()) {
            ZipEntry e = new ZipEntry(name);
            f.putNextEntry(e);
            String entrydata = this.index.apply(roots, ontologies);
            f.write(entrydata.getBytes());
            f.closeEntry();
        }
    }

    public String catalogIndex(Collection<OWLOntology> roots, Collection<OWLOntology> ontologies) {
        StringBuilder b = new StringBuilder(1000).append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<catalog prefer=\"public\" xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">\n    <group id=\"Folder Repository, directory=, recursive=true, Auto-Update=true, version=2\" prefer=\"public\" xml:base=\"\">\n");
        int id = 1;
        if (roots.size() + ontologies.size() > 0) {
            for (OWLOntology o : roots) {
                b.append("        <uri id=\"test").append(id).append("\" name=\"").append(o.getOntologyID().getOntologyIRI().get()).append("\" uri=\"").append(this.entryPath.apply(o.getOntologyID())).append("\"/>\n");
                ++id;
            }
            for (OWLOntology o : ontologies) {
                b.append("        <uri id=\"test").append(id).append("\" name=\"").append(o.getOntologyID().getOntologyIRI().get()).append("\" uri=\"").append(this.entryPath.apply(o.getOntologyID())).append("\"/>\n");
                ++id;
            }
        }
        b.append("    </group>\n</catalog>\n");
        return b.toString();
    }

    public String yamlIndex(Collection<OWLOntology> roots, Collection<OWLOntology> ontologies) {
        StringBuilder b = new StringBuilder();
        if (roots.size() + ontologies.size() > 0) {
            b.append("ontologies:\n");
            roots.stream().map(OWLOntology::getOntologyID).forEach(o -> b.append("- iri: ").append(o.getOntologyIRI().get()).append("\n  path: ").append(this.entryPath.apply((OWLOntologyID)o)).append("\n  root: true\n"));
            ontologies.stream().map(OWLOntology::getOntologyID).forEach(o -> b.append("- iri: ").append(o.getOntologyIRI().get()).append("\n  path: ").append(this.entryPath.apply((OWLOntologyID)o)).append("\n"));
        }
        return b.toString();
    }

    public String propertiesIndex(Collection<OWLOntology> roots, Collection<OWLOntology> ontologies) {
        StringBuilder b = new StringBuilder();
        if (!roots.isEmpty()) {
            String rootsEntry = roots.stream().map(OWLOntology::getOntologyID).map(this.entryPath).collect(Collectors.joining(", "));
            b.append("roots=").append(rootsEntry).append("\n");
        }
        ontologies.stream().map(OWLOntology::getOntologyID).forEach(o -> b.append(this.entryPath.apply((OWLOntologyID)o)).append("=").append(o.getOntologyIRI().get()).append("\n"));
        return b.toString();
    }

    public String entryPath(OWLOntologyID id) {
        String string = id.getOntologyIRI().get().toString();
        if (string.endsWith("/") || string.endsWith("#")) {
            string = XMLUtils.getNCNameSuffix(string.subSequence(0, string.length() - 1));
        }
        return OWLAPIPreconditions.verifyNotNull(string);
    }
}

