/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum DublinCoreVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    CONTRIBUTOR("contributor"),
    COVERAGE("coverage"),
    CREATOR("creator"),
    DATE("date"),
    DESCRIPTION("description"),
    FORMAT("format"),
    IDENTIFIER("identifier"),
    LANGUAGE("language"),
    PUBLISHER("publisher"),
    RELATION("relation"),
    RIGHTS("rights"),
    SOURCE("source"),
    SUBJECT("subject"),
    TITLE("title"),
    TYPE("type");

    @Nonnull
    private final String shortName;
    @Nonnull
    private final String qname;
    @Nonnull
    private final IRI iri;
    @Nonnull
    public static final String NAME_SPACE = "http://purl.org/dc/elements/1.1/";
    public static final Set<IRI> ALL_URIS;

    private DublinCoreVocabulary(String name) {
        this.shortName = name;
        this.qname = Namespaces.DC.getPrefixName() + ':' + name;
        this.iri = IRI.create(NAME_SPACE, name);
    }

    @Override
    public String getShortForm() {
        return this.shortName;
    }

    @Override
    public String getPrefixedName() {
        return this.qname;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public String toString() {
        return this.iri.toString();
    }

    static {
        ALL_URIS = Collections.unmodifiableSet(Stream.of(DublinCoreVocabulary.values()).map(HasIRI::getIRI).collect(Collectors.toSet()));
    }
}

