/*
 * Decompiled with CFR 0.152.
 */
package owltools.ncbi;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.obolibrary.obo2owl.Obo2Owl;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import owltools.ncbi.NCBIConverter;

public class NCBIOWL
extends NCBIConverter {
    protected static final Logger logger = Logger.getLogger(NCBIOWL.class);
    protected static final OWLDataFactory dataFactory = OWLManager.getOWLDataFactory();
    protected static final OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    public static final HashSet<String> ranks = NCBIOWL.initializeRanks();
    public static final HashMap<String, String> synonymTypes = NCBIOWL.initializeFieldMap();

    private static HashSet<String> initializeRanks() {
        HashSet<String> ranks = new HashSet<String>();
        ranks.add("class");
        ranks.add("family");
        ranks.add("forma");
        ranks.add("genus");
        ranks.add("infraclass");
        ranks.add("infraorder");
        ranks.add("kingdom");
        ranks.add("order");
        ranks.add("parvorder");
        ranks.add("phylum");
        ranks.add("species group");
        ranks.add("species subgroup");
        ranks.add("species");
        ranks.add("subclass");
        ranks.add("subfamily");
        ranks.add("subgenus");
        ranks.add("subkingdom");
        ranks.add("suborder");
        ranks.add("subphylum");
        ranks.add("subspecies");
        ranks.add("subtribe");
        ranks.add("superclass");
        ranks.add("superfamily");
        ranks.add("superkingdom");
        ranks.add("superorder");
        ranks.add("superphylum");
        ranks.add("tribe");
        ranks.add("varietas");
        return ranks;
    }

    private static HashMap<String, String> initializeFieldMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("acronym", "oio:hasBroadSynonym");
        map.put("anamorph", "oio:hasRelatedSynonym");
        map.put("blast name", "oio:hasRelatedSynonym");
        map.put("common name", "oio:hasExactSynonym");
        map.put("equivalent name", "oio:hasExactSynonym");
        map.put("genbank acronym", "oio:hasBroadSynonym");
        map.put("genbank anamorph", "oio:hasRelatedSynonym");
        map.put("genbank common name", "oio:hasExactSynonym");
        map.put("genbank synonym", "oio:hasRelatedSynonym");
        map.put("in-part", "oio:hasRelatedSynonym");
        map.put("misnomer", "oio:hasRelatedSynonym");
        map.put("misspelling", "oio:hasRelatedSynonym");
        map.put("synonym", "oio:hasRelatedSynonym");
        map.put("scientific name", "oio:hasExactSynonym");
        map.put("teleomorph", "oio:hasRelatedSynonym");
        return map;
    }

    public static OWLOntology createOWLOntology() throws OWLOntologyCreationException {
        Obo2OWLConstants.Obo2OWLVocabulary[] terms;
        IRI iri = IRI.create("http://purl.obolibrary.org/obo/ncbitaxon.owl");
        OWLOntology ontology = manager.createOntology(iri);
        for (Obo2OWLConstants.Obo2OWLVocabulary term : terms = new Obo2OWLConstants.Obo2OWLVocabulary[]{Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasExactSynonym, Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasRelatedSynonym, Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasBroadSynonym, Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasDbXref, Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasOboNamespace, Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasScope, Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasOBOFormatVersion, Obo2OWLConstants.Obo2OWLVocabulary.hasSynonymType, Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000115}) {
            NCBIOWL.createAnnotationProperty(ontology, term);
        }
        OWLAnnotationProperty rank = NCBIOWL.createAnnotationProperty(ontology, "obo:ncbitaxon#has_rank");
        NCBIOWL.annotate(ontology, (OWLEntity)rank, "rdfs:label", "has_rank");
        NCBIOWL.annotate(ontology, (OWLEntity)rank, "iao:0000115", "A metadata relation between a class and its taxonomic rank (eg species, family)");
        NCBIOWL.annotate(ontology, (OWLEntity)rank, "rdfs:comment", "This is an abstract class for use with the NCBI taxonomy to name the depth of the node within the tree. The link between the node term and the rank is only visible if you are using an obo 1.3 aware browser/editor; otherwise this can be ignored");
        NCBIOWL.annotate(ontology, (OWLEntity)rank, "oio:hasOBONamespace", "ncbi_taxonomy");
        OWLClass taxonomicRank = NCBIOWL.createTaxon(ontology, "taxonomic_rank");
        NCBIOWL.annotate(ontology, (OWLEntity)taxonomicRank, "rdfs:label", "taxonomic rank");
        NCBIOWL.annotate(ontology, (OWLEntity)taxonomicRank, "rdfs:comment", "This is an abstract class for use with the NCBI taxonomy to name the depth of the node within the tree. The link between the node term and the rank is only visible if you are using an obo 1.3 aware browser/editor; otherwise this can be ignored.");
        for (String rankName : ranks) {
            String rankString = NCBIOWL.reformatName(rankName);
            OWLClass rankClass = NCBIOWL.createTaxon(ontology, rankString);
            NCBIOWL.assertSubClass(ontology, rankClass, taxonomicRank);
            NCBIOWL.annotate(ontology, (OWLEntity)rankClass, "rdfs:label", rankName);
        }
        OWLAnnotationProperty synonymTypeProperty = NCBIOWL.createAnnotationProperty(ontology, "oio:SynonymTypeProperty");
        NCBIOWL.annotate(ontology, (OWLEntity)synonymTypeProperty, "rdfs:label", "synonym_type_property");
        Set<String> synonymNames = synonymTypes.keySet();
        for (String synonymName : synonymNames) {
            String synonymString = NCBIOWL.reformatName("ncbitaxon:" + synonymName);
            OWLAnnotationProperty synonymProperty = NCBIOWL.createAnnotationProperty(ontology, synonymString);
            NCBIOWL.annotate(ontology, (OWLEntity)synonymProperty, "rdfs:label", synonymName);
            NCBIOWL.annotate(ontology, (OWLEntity)synonymProperty, "oio:hasScope", synonymTypes.get(synonymName));
            NCBIOWL.assertSubAnnotationProperty(ontology, synonymProperty, synonymTypeProperty);
        }
        NCBIOWL.annotate(ontology, "rdfs:comment", "Autogenerated by OWLTools-NCBIConverter.");
        logger.debug("Initialized ontology. Axioms: " + ontology.getAxiomCount());
        return ontology;
    }

    public static OWLAnnotationProperty setupAltIdProperty(OWLOntology ontology) {
        IRI iri = Obo2Owl.trTagToIRI(OBOFormatConstants.OboFormatTag.TAG_ALT_ID.getTag());
        OWLAnnotationProperty ap = NCBIOWL.createAnnotationProperty(ontology, iri);
        OWLAnnotationProperty prop = dataFactory.getRDFSLabel();
        OWLLiteral value = dataFactory.getOWLLiteral(Obo2OWLConstants.Obo2OWLVocabulary.hasAlternativeId.getLabel());
        manager.addAxiom(ontology, dataFactory.getOWLAnnotationAssertionAxiom(prop, iri, value));
        return ap;
    }

    public static void addAltId(OWLOntology ontology, String merged, String altId, OWLAnnotationProperty ap) {
        altId = altId.trim();
        merged = merged.trim();
        IRI mergedIRI = NCBIOWL.createNCBIIRI(merged);
        OWLLiteral value = dataFactory.getOWLLiteral("NCBITaxon:" + altId);
        OWLAnnotationAssertionAxiom axiom = dataFactory.getOWLAnnotationAssertionAxiom(ap, mergedIRI, value);
        manager.addAxiom(ontology, axiom);
    }

    public static OWLOntology loadOWLOntology(File inputFile) throws OWLOntologyCreationException {
        return manager.loadOntologyFromOntologyDocument(inputFile);
    }
}

