/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.FindLiterals;
import uk.ac.manchester.cs.owl.owlapi.Internals;
import uk.ac.manchester.cs.owl.owlapi.MapPointer;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomIndexImpl;

public class OWLImmutableOntologyImpl
extends OWLAxiomIndexImpl
implements OWLOntology,
Serializable {
    private static final long serialVersionUID = 40000L;
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLClassAxiom>> ontgenAxioms = OWLImmutableOntologyImpl.build(OWLImmutableOntologyImpl::buildGenAxioms);
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLEntity>> ontsignatures = OWLImmutableOntologyImpl.build(OWLImmutableOntologyImpl::build);
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLAnonymousIndividual>> ontanonCaches = OWLImmutableOntologyImpl.build((Q key) -> OWLImmutableOntologyImpl.asCacheable(key.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get().keySet()));
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLClass>> ontclassesSignatures = OWLImmutableOntologyImpl.build((Q key) -> OWLImmutableOntologyImpl.asCacheable(key.ints.get(OWLClass.class, OWLAxiom.class).get().keySet()));
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLDataProperty>> ontdataPropertySignatures = OWLImmutableOntologyImpl.build((Q key) -> OWLImmutableOntologyImpl.asCacheable(key.ints.get(OWLDataProperty.class, OWLAxiom.class).get().keySet()));
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLObjectProperty>> ontobjectPropertySignatures = OWLImmutableOntologyImpl.build((Q key) -> OWLImmutableOntologyImpl.asCacheable(key.ints.get(OWLObjectProperty.class, OWLAxiom.class).get().keySet()));
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLDatatype>> ontdatatypeSignatures = OWLImmutableOntologyImpl.build((Q key) -> OWLImmutableOntologyImpl.asCacheable(Stream.concat(key.ints.get(OWLDatatype.class, OWLAxiom.class).get().keySet().stream(), key.ints.getOntologyAnnotations(false).stream().flatMap(x -> x.getDatatypesInSignature().stream())).collect(Collectors.toSet())));
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLNamedIndividual>> ontindividualSignatures = OWLImmutableOntologyImpl.build((Q key) -> OWLImmutableOntologyImpl.asCacheable(key.ints.get(OWLNamedIndividual.class, OWLAxiom.class).get().keySet()));
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLAnnotationProperty>> ontannotationPropertiesSignatures = OWLImmutableOntologyImpl.build((Q key) -> OWLImmutableOntologyImpl.asCacheable(Stream.concat(key.ints.get(OWLAnnotationProperty.class, OWLAxiom.class, Navigation.IN_SUB_POSITION).get().keySet().stream(), key.ints.getOntologyAnnotations(false).stream().flatMap(a -> a.getAnnotationPropertiesInSignature().stream())).collect(Collectors.toSet())));
    @Nullable
    protected OWLOntologyManager manager;
    @Nonnull
    protected OWLOntologyID ontologyID;

    static <Q, T> LoadingCache<Q, T> build(CacheLoader<Q, T> c) {
        return Caffeine.newBuilder().weakKeys().maximumSize(OWLImmutableOntologyImpl.size()).build(c);
    }

    protected static long size() {
        return ConfigurationOptions.CACHE_SIZE.getValue(Integer.class, Collections.emptyMap()).longValue();
    }

    protected static void invalidateOntologyCaches(OWLImmutableOntologyImpl o) {
        ontgenAxioms.invalidate(o);
        ontsignatures.invalidate(o);
        ontanonCaches.invalidate(o);
        ontclassesSignatures.invalidate(o);
        ontdataPropertySignatures.invalidate(o);
        ontobjectPropertySignatures.invalidate(o);
        ontdatatypeSignatures.invalidate(o);
        ontindividualSignatures.invalidate(o);
        ontannotationPropertiesSignatures.invalidate(o);
    }

    private static Set<OWLClassAxiom> buildGenAxioms(OWLImmutableOntologyImpl key) {
        return new LinkedHashSet<OWLClassAxiom>(key.ints.getGeneralClassAxioms());
    }

    private static Set<OWLEntity> build(OWLImmutableOntologyImpl key) {
        ArrayList stream = new ArrayList();
        key.classesInSignature().forEach(stream::add);
        key.objectPropertiesInSignature().forEach(stream::add);
        key.dataPropertiesInSignature().forEach(stream::add);
        key.individualsInSignature().forEach(stream::add);
        key.datatypesInSignature().forEach(stream::add);
        key.annotationPropertiesInSignature().forEach(stream::add);
        key.getAnnotations().stream().flatMap(x -> x.getSignature().stream()).forEach(stream::add);
        stream.sort(null);
        return new LinkedHashSet<OWLEntity>(stream);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.ontologyID);
        stream.writeObject(this.manager);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.ontologyID = (OWLOntologyID)stream.readObject();
        this.manager = (OWLOntologyManager)stream.readObject();
    }

    @Override
    protected int index() {
        return 1;
    }

    public OWLImmutableOntologyImpl(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntologyID ontologyID) {
        this.manager = OWLAPIPreconditions.checkNotNull(manager, "manager cannot be null");
        this.ontologyID = OWLAPIPreconditions.checkNotNull(ontologyID, "ontologyID cannot be null");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("Ontology(");
        sb.append(this.ontologyID);
        sb.append(") [Axioms: ");
        int axiomCount = this.ints.getAxiomCount();
        sb.append(axiomCount);
        sb.append(" Logical Axioms: ");
        sb.append(this.ints.getLogicalAxiomCount());
        sb.append("] First 20 axioms: {");
        sb.append(this.ints.getAxioms().stream().limit(20L).map(Object::toString).collect(Collectors.joining(" ")));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public OWLOntologyManager getOWLOntologyManager() {
        OWLOntologyManager m3 = this.manager;
        if (m3 == null) {
            throw new IllegalStateException("Manager on ontology " + this.getOntologyID() + " is null; the ontology is no longer associated to a manager. Ensure the ontology is not being used after being removed from its manager.");
        }
        return OWLAPIPreconditions.verifyNotNull(m3, "manager cannot be null at this stage");
    }

    @Override
    public void setOWLOntologyManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    @Override
    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    @Override
    public boolean isAnonymous() {
        return this.ontologyID.isAnonymous();
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        if (object == this) {
            return 0;
        }
        OWLOntology other = (OWLOntology)object;
        return this.ontologyID.compareTo(other.getOntologyID());
    }

    @Override
    public boolean isEmpty() {
        return this.ints.isEmpty();
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean includeImportsClosure) {
        return this.getAxiomCount(axiomType, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public int getAxiomCount(boolean includeImportsClosure) {
        return this.getAxiomCount(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getAxiomCount(axiomType);
        }
        int result = 0;
        for (OWLOntology ont : this.getImportsClosure()) {
            result += ont.getAxiomCount(axiomType);
        }
        return result;
    }

    @Override
    public boolean containsAxiom(@Nonnull OWLAxiom axiom) {
        return Internals.contains(this.ints.getAxiomsByType(), axiom.getAxiomType(), axiom);
    }

    @Override
    public int getAxiomCount() {
        return this.getAxiomCount(Imports.EXCLUDED);
    }

    @Override
    public int getAxiomCount(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.getAxiomCount();
        }
        int total = 0;
        for (OWLOntology o : this.getImportsClosure()) {
            total += o.getAxiomCount();
        }
        return total;
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        return this.getAxioms(Imports.EXCLUDED);
    }

    @Override
    public Set<OWLAxiom> getAxioms(boolean b) {
        return this.getAxioms(Imports.fromBoolean(b));
    }

    @Override
    public Set<OWLAxiom> getAxioms(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return OWLImmutableOntologyImpl.asSet(this.ints.getAxioms());
        }
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLOntology o : this.getImportsClosure()) {
            axioms.addAll(o.getAxioms());
        }
        return axioms;
    }

    @Override
    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        return OWLImmutableOntologyImpl.asSet(this.ints.getAxiomsByType().getValues(axiomType));
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean includeImportsClosure) {
        return this.getAxioms(axiomType, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getAxioms(axiomType);
        }
        Set toReturn = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            toReturn.addAll(o.getAxioms(axiomType));
        }
        return toReturn;
    }

    @Override
    @Nonnull
    public Set<OWLAxiom> getTBoxAxioms(Imports includeImportsClosure) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomType<?> type : AxiomType.TBoxAxiomTypes) {
            assert (type != null);
            toReturn.addAll(this.getAxioms(type, includeImportsClosure));
        }
        return toReturn;
    }

    @Override
    @Nonnull
    public Set<OWLAxiom> getABoxAxioms(Imports includeImportsClosure) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomType<?> type : AxiomType.ABoxAxiomTypes) {
            assert (type != null);
            toReturn.addAll(this.getAxioms(type, includeImportsClosure));
        }
        return toReturn;
    }

    @Override
    @Nonnull
    public Set<OWLAxiom> getRBoxAxioms(Imports includeImportsClosure) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomType<?> type : AxiomType.RBoxAxiomTypes) {
            assert (type != null);
            toReturn.addAll(this.getAxioms(type, includeImportsClosure));
        }
        return toReturn;
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return this.ints.getAxiomCount(axiomType);
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        return this.ints.getLogicalAxioms();
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.getLogicalAxioms();
        }
        Set<OWLLogicalAxiom> result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getLogicalAxioms(Imports.EXCLUDED));
        }
        return result;
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms(boolean includeImportsClosure) {
        return this.getLogicalAxioms(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public int getLogicalAxiomCount() {
        return this.ints.getLogicalAxiomCount();
    }

    @Override
    public int getLogicalAxiomCount(boolean includeImportsClosure) {
        return this.getLogicalAxiomCount(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public int getLogicalAxiomCount(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.getLogicalAxiomCount();
        }
        int total = 0;
        for (OWLOntology o : this.getImportsClosure()) {
            total += o.getLogicalAxiomCount(Imports.EXCLUDED);
        }
        return total;
    }

    @Override
    @Nonnull
    public Set<OWLAnnotation> getAnnotations() {
        return (Set)this.ints.getOntologyAnnotations(true);
    }

    @Override
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return ontgenAxioms.get(this);
    }

    @Override
    public boolean containsAxiom(@Nonnull OWLAxiom axiom, boolean includeImportsClosure) {
        return this.containsAxiom(axiom, Imports.fromBoolean(includeImportsClosure), AxiomAnnotations.CONSIDER_AXIOM_ANNOTATIONS);
    }

    @Override
    public boolean containsAxiom(@Nonnull OWLAxiom axiom, Imports includeImportsClosure, AxiomAnnotations ignoreAnnotations) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            if (ignoreAnnotations == AxiomAnnotations.CONSIDER_AXIOM_ANNOTATIONS) {
                return this.containsAxiom(axiom);
            }
            return this.containsAxiomIgnoreAnnotations(axiom);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsAxiom(axiom, Imports.EXCLUDED, ignoreAnnotations)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom axiom) {
        for (OWLAxiom ax : this.ints.getAxiomsByType().getValues(axiom.getAxiomType())) {
            if (!ax.equalsIgnoreAnnotations(axiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom axiom, boolean importsIncluded) {
        return this.containsAxiom(axiom, Imports.fromBoolean(importsIncluded), AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS);
    }

    @Override
    @Nonnull
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom axiom) {
        Set<OWLAxiom> result = CollectionFactory.createLinkedSet();
        if (this.containsAxiom(axiom)) {
            result.add(axiom);
        }
        for (OWLAxiom ax : this.ints.getAxiomsByType().getValues(axiom.getAxiomType())) {
            if (!ax.equalsIgnoreAnnotations(axiom)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom axiom, boolean includeImportsClosure) {
        return this.getAxiomsIgnoreAnnotations(axiom, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom axiom, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getAxiomsIgnoreAnnotations(axiom);
        }
        Set<OWLAxiom> result = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getAxiomsIgnoreAnnotations(axiom, Imports.EXCLUDED));
        }
        return result;
    }

    @Override
    public boolean containsClassInSignature(IRI owlClassIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsClassInSignature(owlClassIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsClassInSignature(owlClassIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI owlObjectPropertyIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsObjectPropertyInSignature(owlObjectPropertyIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsObjectPropertyInSignature(owlObjectPropertyIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI owlDataPropertyIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsDataPropertyInSignature(owlDataPropertyIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsDataPropertyInSignature(owlDataPropertyIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI owlAnnotationPropertyIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.INCLUDED) {
            for (OWLOntology o : this.getImportsClosure()) {
                if (!o.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI, Imports.EXCLUDED)) continue;
                return true;
            }
        } else if (this.ints.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI)) {
            return true;
        }
        OWLAnnotationProperty p = this.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationProperty(owlAnnotationPropertyIRI);
        return this.checkOntologyAnnotations(p);
    }

    private boolean checkOntologyAnnotations(OWLAnnotationProperty owlAnnotationProperty) {
        for (OWLAnnotation anno : this.ints.getOntologyAnnotations(false)) {
            if (!anno.getProperty().equals(owlAnnotationProperty)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsIndividualInSignature(IRI owlIndividualIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsIndividualInSignature(owlIndividualIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsIndividualInSignature(owlIndividualIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDatatypeInSignature(IRI owlDatatypeIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsDatatypeInSignature(owlDatatypeIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsDatatypeInSignature(owlDatatypeIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(@Nonnull IRI entityIRI) {
        return this.getEntitiesInSignature(entityIRI, Imports.EXCLUDED);
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, Imports includeImportsClosure) {
        Set<int> result = CollectionFactory.createSet(6);
        if (this.containsClassInSignature(iri, includeImportsClosure)) {
            result.add((int)this.getOWLOntologyManager().getOWLDataFactory().getOWLClass(iri));
        }
        if (this.containsObjectPropertyInSignature(iri, includeImportsClosure)) {
            result.add((int)this.getOWLOntologyManager().getOWLDataFactory().getOWLObjectProperty(iri));
        }
        if (this.containsDataPropertyInSignature(iri, includeImportsClosure)) {
            result.add((int)this.getOWLOntologyManager().getOWLDataFactory().getOWLDataProperty(iri));
        }
        if (this.containsIndividualInSignature(iri, includeImportsClosure)) {
            result.add((int)this.getOWLOntologyManager().getOWLDataFactory().getOWLNamedIndividual(iri));
        }
        if (this.containsDatatypeInSignature(iri, includeImportsClosure)) {
            result.add((int)this.getOWLOntologyManager().getOWLDataFactory().getOWLDatatype(iri));
        }
        if (this.containsAnnotationPropertyInSignature(iri, includeImportsClosure)) {
            result.add((int)this.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationProperty(iri));
        }
        return result;
    }

    @Override
    public Set<IRI> getPunnedIRIs(Imports includeImportsClosure) {
        HashSet<IRI> punned = new HashSet<IRI>();
        HashSet<IRI> test = new HashSet<IRI>();
        if (includeImportsClosure == Imports.INCLUDED) {
            for (OWLOntology oWLOntology : this.getImportsClosure()) {
                for (OWLEntity oWLEntity : oWLOntology.getClassesInSignature(Imports.EXCLUDED)) {
                    if (test.add(oWLEntity.getIRI())) continue;
                    punned.add(oWLEntity.getIRI());
                }
                for (OWLEntity oWLEntity : oWLOntology.getDataPropertiesInSignature(Imports.EXCLUDED)) {
                    if (test.add(oWLEntity.getIRI())) continue;
                    punned.add(oWLEntity.getIRI());
                }
                for (OWLEntity oWLEntity : oWLOntology.getObjectPropertiesInSignature(Imports.EXCLUDED)) {
                    if (test.add(oWLEntity.getIRI())) continue;
                    punned.add(oWLEntity.getIRI());
                }
                for (OWLEntity oWLEntity : oWLOntology.getAnnotationPropertiesInSignature(Imports.EXCLUDED)) {
                    if (test.add(oWLEntity.getIRI())) continue;
                    punned.add(oWLEntity.getIRI());
                }
                for (OWLEntity oWLEntity : oWLOntology.getDatatypesInSignature(Imports.EXCLUDED)) {
                    if (test.add(oWLEntity.getIRI())) continue;
                    punned.add(oWLEntity.getIRI());
                }
                for (OWLEntity oWLEntity : oWLOntology.getIndividualsInSignature(Imports.EXCLUDED)) {
                    if (test.add(oWLEntity.getIRI())) continue;
                    punned.add(oWLEntity.getIRI());
                }
            }
            if (punned.isEmpty()) {
                return CollectionFactory.emptySet();
            }
            return punned;
        }
        for (OWLEntity oWLEntity : this.getClassesInSignature(Imports.EXCLUDED)) {
            test.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getDataPropertiesInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getObjectPropertiesInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getAnnotationPropertiesInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getDatatypesInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getIndividualsInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        if (punned.isEmpty()) {
            return CollectionFactory.emptySet();
        }
        return punned;
    }

    @Override
    public boolean containsReference(@Nonnull OWLEntity entity, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsReference(entity);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsReference(entity, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDeclared(OWLEntity owlEntity) {
        return this.ints.isDeclared(owlEntity);
    }

    @Override
    public boolean isDeclared(OWLEntity owlEntity, Imports includeImportsClosure) {
        if (this.isDeclared(owlEntity)) {
            return true;
        }
        if (includeImportsClosure == Imports.INCLUDED) {
            for (OWLOntology ont : this.getOWLOntologyManager().getImportsClosure(this)) {
                if (ont.equals(this) || !ont.isDeclared(owlEntity)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity) {
        return this.containsEntityInSignature(owlEntity, Imports.EXCLUDED);
    }

    @Override
    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity, Imports includeImportsClosure) {
        if (includeImportsClosure != Imports.INCLUDED) {
            Set set = (Set)ontsignatures.getIfPresent(this);
            if (set == null) {
                if (this.ints.containsReference(owlEntity)) {
                    return true;
                }
                return this.getAnnotations().stream().anyMatch(a -> a.getSignature().contains(owlEntity));
            }
            return set.contains(owlEntity);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsEntityInSignature(owlEntity, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntityInSignature(IRI entityIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            if (this.containsClassInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            if (this.containsObjectPropertyInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            if (this.containsDataPropertyInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            if (this.containsIndividualInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            if (this.containsDatatypeInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            return this.containsAnnotationPropertyInSignature(entityIRI, Imports.EXCLUDED);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsEntityInSignature(entityIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return ontsignatures.get(this);
    }

    @Override
    public Set<OWLEntity> getSignature(Imports includeImportsClosure) {
        Set<OWLEntity> entities = this.getSignature();
        if (includeImportsClosure == Imports.INCLUDED) {
            for (OWLOntology ont : this.getImportsClosure()) {
                entities.addAll(ont.getSignature(Imports.EXCLUDED));
            }
        }
        return entities;
    }

    @Nonnull
    private static <T> Set<T> asSet(Iterable<T> i) {
        if (i instanceof Set) {
            ArrayList list = new ArrayList();
            i.forEach(list::add);
            return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(list);
        }
        HashSet set = new HashSet();
        i.forEach(set::add);
        return set;
    }

    @Nonnull
    private static <T> Set<T> asCacheable(Iterable<T> i) {
        if (i instanceof List) {
            List list = (List)i;
            list.sort(null);
            return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(list);
        }
        ArrayList list = new ArrayList();
        i.forEach(list::add);
        list.sort(null);
        if (i instanceof Set) {
            return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(list);
        }
        LinkedHashSet set = new LinkedHashSet();
        list.forEach(set::add);
        return set;
    }

    protected Iterable<OWLClass> classesInSignature() {
        return ontclassesSignatures.get(this);
    }

    protected Iterable<OWLDataProperty> dataPropertiesInSignature() {
        return ontdataPropertySignatures.get(this);
    }

    protected Iterable<OWLObjectProperty> objectPropertiesInSignature() {
        return ontobjectPropertySignatures.get(this);
    }

    protected Iterable<OWLNamedIndividual> individualsInSignature() {
        return ontindividualSignatures.get(this);
    }

    protected Iterable<OWLDatatype> datatypesInSignature() {
        return ontdatatypeSignatures.get(this);
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return ontanonCaches.get(this);
    }

    protected Iterable<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return ontannotationPropertiesSignatures.get(this);
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        return OWLImmutableOntologyImpl.asSet(this.classesInSignature());
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return OWLImmutableOntologyImpl.asSet(this.dataPropertiesInSignature());
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return OWLImmutableOntologyImpl.asSet(this.objectPropertiesInSignature());
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return OWLImmutableOntologyImpl.asSet(this.individualsInSignature());
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        return OWLImmutableOntologyImpl.asSet(this.datatypesInSignature());
    }

    @Override
    public Set<OWLClass> getClassesInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getClassesInSignature();
        }
        Set<OWLClass> results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getClassesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getObjectPropertiesInSignature();
        }
        Set<OWLObjectProperty> results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getObjectPropertiesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getDataPropertiesInSignature();
        }
        Set<OWLDataProperty> results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDataPropertiesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getIndividualsInSignature();
        }
        Set<OWLNamedIndividual> results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getIndividualsInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return OWLImmutableOntologyImpl.asSet(this.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get().keySet());
        }
        Set<OWLAnonymousIndividual> result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getReferencedAnonymousIndividuals(Imports.EXCLUDED));
        }
        return result;
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getDatatypesInSignature();
        }
        Set<OWLDatatype> results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDatatypesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return OWLImmutableOntologyImpl.asSet(this.annotationPropertiesInSignature());
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(Imports includeImportsClosure) {
        Set<OWLAnnotationProperty> props = CollectionFactory.createLinkedSet();
        if (includeImportsClosure == Imports.EXCLUDED) {
            return OWLImmutableOntologyImpl.asSet(this.annotationPropertiesInSignature());
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            props.addAll(ont.getAnnotationPropertiesInSignature(Imports.EXCLUDED));
        }
        return props;
    }

    @Override
    @Nonnull
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        TreeSet<OWLImportsDeclaration> result = new TreeSet<OWLImportsDeclaration>();
        for (OWLImportsDeclaration importsDeclaration : this.ints.getImportsDeclarations(false)) {
            result.add(importsDeclaration);
        }
        return result;
    }

    @Override
    public Set<IRI> getDirectImportsDocuments() {
        TreeSet<IRI> result = new TreeSet<IRI>();
        for (OWLImportsDeclaration importsDeclaration : this.ints.getImportsDeclarations(false)) {
            result.add(importsDeclaration.getIRI());
        }
        return result;
    }

    @Override
    public Set<OWLOntology> getImports() {
        return this.getOWLOntologyManager().getImports(this);
    }

    @Override
    public Set<OWLOntology> getDirectImports() {
        return this.getOWLOntologyManager().getDirectImports(this);
    }

    @Override
    public Set<OWLOntology> getImportsClosure() {
        return this.getOWLOntologyManager().getImportsClosure(this);
    }

    @Override
    public void accept(@Nonnull OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(@Nonnull OWLNamedObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(@Nonnull OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntology)) {
            return false;
        }
        OWLOntology other = (OWLOntology)obj;
        return this.ontologyID.equals(other.getOntologyID());
    }

    @Override
    public int hashCode() {
        return this.ontologyID.hashCode();
    }

    @Override
    public Set<OWLClassAxiom> getAxioms(OWLClass cls, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return OWLImmutableOntologyImpl.asSet(this.ints.get(OWLClass.class, OWLClassAxiom.class).get().getValues(cls));
        }
        Set<OWLClassAxiom> result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getAxioms(cls, Imports.EXCLUDED));
        }
        return result;
    }

    @Override
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property, Imports includeImportsClosure) {
        Set<int> result = CollectionFactory.createSet(50);
        if (includeImportsClosure == Imports.EXCLUDED) {
            result.addAll(this.getAsymmetricObjectPropertyAxioms(property));
            result.addAll(this.getReflexiveObjectPropertyAxioms(property));
            result.addAll(this.getSymmetricObjectPropertyAxioms(property));
            result.addAll(this.getIrreflexiveObjectPropertyAxioms(property));
            result.addAll(this.getTransitiveObjectPropertyAxioms(property));
            result.addAll(this.getInverseFunctionalObjectPropertyAxioms(property));
            result.addAll(this.getFunctionalObjectPropertyAxioms(property));
            result.addAll(this.getInverseObjectPropertyAxioms(property));
            result.addAll(this.getObjectPropertyDomainAxioms(property));
            result.addAll(this.getEquivalentObjectPropertiesAxioms(property));
            result.addAll(this.getDisjointObjectPropertiesAxioms(property));
            result.addAll(this.getObjectPropertyRangeAxioms(property));
            result.addAll(this.getObjectSubPropertyAxiomsForSubProperty(property));
        } else {
            for (OWLOntology o : this.getImportsClosure()) {
                result.addAll(o.getAxioms(property, Imports.EXCLUDED));
            }
        }
        return result;
    }

    @Override
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property, Imports includeImportsClosure) {
        Set<OWLAnnotationAxiom> result = CollectionFactory.createLinkedSet();
        if (includeImportsClosure == Imports.EXCLUDED) {
            for (OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom : this.getAxioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
                if (!oWLSubAnnotationPropertyOfAxiom.getSubProperty().equals(property)) continue;
                result.add(oWLSubAnnotationPropertyOfAxiom);
            }
            for (OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
                if (!oWLAnnotationPropertyRangeAxiom.getProperty().equals(property)) continue;
                result.add(oWLAnnotationPropertyRangeAxiom);
            }
            for (OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
                if (!oWLAnnotationPropertyDomainAxiom.getProperty().equals(property)) continue;
                result.add(oWLAnnotationPropertyDomainAxiom);
            }
        } else {
            for (OWLOntology oWLOntology : this.getImportsClosure()) {
                result.addAll(oWLOntology.getAxioms(property, Imports.EXCLUDED));
            }
        }
        return result;
    }

    @Override
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property, Imports includeImportsClosure) {
        Set<OWLDataPropertyAxiom> result = CollectionFactory.createLinkedSet();
        if (includeImportsClosure == Imports.EXCLUDED) {
            result.addAll(this.getDataPropertyDomainAxioms(property));
            result.addAll(this.getEquivalentDataPropertiesAxioms(property));
            result.addAll(this.getDisjointDataPropertiesAxioms(property));
            result.addAll(this.getDataPropertyRangeAxioms(property));
            result.addAll(this.getFunctionalDataPropertyAxioms(property));
            result.addAll(this.getDataSubPropertyAxiomsForSubProperty(property));
        } else {
            for (OWLOntology o : this.getImportsClosure()) {
                result.addAll(o.getAxioms(property, Imports.EXCLUDED));
            }
        }
        return result;
    }

    @Override
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual, Imports includeImportsClosure) {
        Set<OWLIndividualAxiom> result = CollectionFactory.createLinkedSet();
        if (includeImportsClosure == Imports.EXCLUDED) {
            result.addAll(this.getClassAssertionAxioms(individual));
            result.addAll(this.getObjectPropertyAssertionAxioms(individual));
            result.addAll(this.getDataPropertyAssertionAxioms(individual));
            result.addAll(this.getNegativeObjectPropertyAssertionAxioms(individual));
            result.addAll(this.getNegativeDataPropertyAssertionAxioms(individual));
            result.addAll(this.getSameIndividualAxioms(individual));
            result.addAll(this.getDifferentIndividualAxioms(individual));
        } else {
            for (OWLOntology o : this.getImportsClosure()) {
                result.addAll(o.getAxioms(individual, Imports.EXCLUDED));
            }
        }
        return result;
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getDatatypeDefinitions(datatype);
        }
        Set<OWLDatatypeDefinitionAxiom> result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getAxioms(datatype, Imports.EXCLUDED));
        }
        return result;
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlEntity) {
        return this.getReferencingAxioms(owlEntity, Imports.EXCLUDED);
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlEntity, boolean includeImports) {
        return this.getReferencingAxioms(owlEntity, Imports.fromBoolean(includeImports));
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlEntity, Imports includeImportsClosure) {
        if (owlEntity instanceof OWLEntity) {
            if (includeImportsClosure == Imports.EXCLUDED) {
                return OWLImmutableOntologyImpl.asSet(this.ints.getReferencingAxioms((OWLEntity)owlEntity));
            }
            Set<OWLAxiom> result = CollectionFactory.createLinkedSet();
            for (OWLOntology ont : this.getImportsClosure()) {
                result.addAll(ont.getReferencingAxioms(owlEntity, Imports.EXCLUDED));
            }
            return result;
        }
        if (owlEntity instanceof OWLAnonymousIndividual) {
            return OWLImmutableOntologyImpl.asSet(this.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get().getValues((OWLAnonymousIndividual)owlEntity));
        }
        if (owlEntity instanceof IRI) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            Set<OWLEntity> entities = this.getEntitiesInSignature((IRI)owlEntity, includeImportsClosure);
            for (OWLEntity oWLEntity : entities) {
                assert (oWLEntity != null);
                axioms.addAll(this.getReferencingAxioms((OWLPrimitive)oWLEntity, includeImportsClosure));
            }
            for (OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom : this.getAxioms(AxiomType.DATA_PROPERTY_ASSERTION)) {
                if (!((OWLLiteral)oWLDataPropertyAssertionAxiom.getObject()).getDatatype().getIRI().equals(OWL2Datatype.XSD_ANY_URI.getIRI()) || !((OWLLiteral)oWLDataPropertyAssertionAxiom.getObject()).getLiteral().equals(owlEntity.toString())) continue;
                axioms.add(oWLDataPropertyAssertionAxiom);
            }
            for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : this.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
                OWLLiteral lit;
                if (oWLAnnotationAssertionAxiom.getSubject().equals(owlEntity)) {
                    axioms.add(oWLAnnotationAssertionAxiom);
                    continue;
                }
                if (!oWLAnnotationAssertionAxiom.getValue().asLiteral().isPresent() || !(lit = oWLAnnotationAssertionAxiom.getValue().asLiteral().get()).getDatatype().getIRI().equals(OWL2Datatype.XSD_ANY_URI.getIRI()) || !lit.getLiteral().equals(owlEntity.toString())) continue;
                axioms.add(oWLAnnotationAssertionAxiom);
            }
            return axioms;
        }
        if (owlEntity instanceof OWLLiteral) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            FindLiterals v = new FindLiterals((OWLLiteral)owlEntity);
            AxiomType.AXIOM_TYPES.stream().flatMap(t -> this.getAxioms((AxiomType)t).stream()).filter(ax -> ax.accept(v)).forEach(axioms::add);
            return axioms;
        }
        return CollectionFactory.emptySet();
    }

    public <A extends OWLAxiom> Set<A> getAxioms(@Nonnull Class<A> type, @Nonnull OWLObject entity, Imports includeImports, Navigation forSubPosition) {
        if (includeImports == Imports.EXCLUDED) {
            return this.getAxioms(type, (Class<? extends OWLObject>)entity.getClass(), entity, Imports.EXCLUDED, forSubPosition);
        }
        Set result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getAxioms(type, entity, Imports.EXCLUDED, forSubPosition));
        }
        return result;
    }

    public <A extends OWLAxiom> Set<A> getAxioms(@Nonnull Class<A> type, @Nonnull Class<? extends OWLObject> explicitClass, @Nonnull OWLObject entity, @Nonnull Imports includeImports, @Nonnull Navigation forSubPosition) {
        if (includeImports == Imports.EXCLUDED) {
            Optional<MapPointer<OWLObject, A>> optional = this.ints.get(explicitClass, type, forSubPosition);
            if (optional.isPresent()) {
                return OWLImmutableOntologyImpl.asSet(optional.get().getValues(entity));
            }
            HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : this.getAxioms(AxiomType.getTypeForClass(type))) {
                if (!ax.getSignature().contains(entity)) continue;
                toReturn.add(ax);
            }
            return toReturn;
        }
        Set result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getAxioms(type, entity, Imports.EXCLUDED, forSubPosition));
        }
        return result;
    }

    @Override
    @Nonnull
    public <T extends OWLAxiom> Collection<T> filterAxioms(@Nonnull OWLAxiomSearchFilter filter, @Nonnull Object key, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.filterAxioms(filter, key);
        }
        HashSet toReturn = new HashSet();
        for (OWLOntology o : this.getImportsClosure()) {
            toReturn.addAll(o.filterAxioms(filter, key, Imports.EXCLUDED));
        }
        return toReturn;
    }

    @Override
    public boolean contains(@Nonnull OWLAxiomSearchFilter filter, @Nonnull Object key, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.contains(filter, key);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.contains(filter, key, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLClassAxiom> getAxioms(OWLClass cls) {
        return this.getAxioms(cls, false);
    }

    @Override
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property) {
        return this.getAxioms(property, Imports.EXCLUDED);
    }

    @Override
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property) {
        return this.getAxioms(property, Imports.EXCLUDED);
    }

    @Override
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        return this.getAxioms(individual, Imports.EXCLUDED);
    }

    @Override
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property) {
        return this.getAxioms(property, Imports.EXCLUDED);
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype) {
        return this.getAxioms(datatype, Imports.EXCLUDED);
    }

    @Override
    public Set<OWLClassAxiom> getAxioms(OWLClass cls, boolean includeImportsClosure) {
        return this.getAxioms(cls, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property, boolean includeImportsClosure) {
        return this.getAxioms(property, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property, boolean includeImportsClosure) {
        return this.getAxioms(property, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual, boolean includeImportsClosure) {
        return this.getAxioms(individual, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property, boolean includeImportsClosure) {
        return this.getAxioms(property, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype, boolean includeImportsClosure) {
        return this.getAxioms(datatype, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public void saveOntology() throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology(this);
    }

    @Override
    public void saveOntology(IRI documentIRI) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, documentIRI);
    }

    @Override
    public void saveOntology(OutputStream outputStream) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, outputStream);
    }

    @Override
    public void saveOntology(OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, ontologyFormat);
    }

    @Override
    public void saveOntology(OWLDocumentFormat ontologyFormat, IRI documentIRI) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, ontologyFormat, documentIRI);
    }

    @Override
    public void saveOntology(OWLDocumentFormat ontologyFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, ontologyFormat, outputStream);
    }

    @Override
    public void saveOntology(OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, documentTarget);
    }

    @Override
    public void saveOntology(OWLDocumentFormat ontologyFormat, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, ontologyFormat, documentTarget);
    }

    @Override
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClassExpression ce) {
        if (ce.isAnonymous()) {
            this.getAxioms(AxiomType.CLASS_ASSERTION).stream().filter(x -> x.getClassExpression().equals(ce)).collect(Collectors.toSet());
        }
        return super.getClassAssertionAxioms(ce);
    }

    @Override
    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        return this.ints.anyEntities(type);
    }

    @Override
    public boolean containsDatatypeInSignature(IRI owlDatatypeIRI) {
        return this.containsDatatypeInSignature(owlDatatypeIRI, Imports.EXCLUDED);
    }

    @Override
    public boolean containsEntityInSignature(IRI entityIRI) {
        return this.containsEntityInSignature(entityIRI, Imports.EXCLUDED);
    }

    @Override
    public boolean containsClassInSignature(IRI owlClassIRI) {
        return this.containsClassInSignature(owlClassIRI, Imports.EXCLUDED);
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI owlObjectPropertyIRI) {
        return this.containsObjectPropertyInSignature(owlObjectPropertyIRI, Imports.EXCLUDED);
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI owlDataPropertyIRI) {
        return this.containsDataPropertyInSignature(owlDataPropertyIRI, Imports.EXCLUDED);
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI owlAnnotationPropertyIRI) {
        return this.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI, Imports.EXCLUDED);
    }

    @Override
    public boolean containsIndividualInSignature(IRI owlIndividualIRI) {
        return this.containsIndividualInSignature(owlIndividualIRI, Imports.EXCLUDED);
    }

    @Override
    public boolean containsReference(OWLEntity entity) {
        return this.containsReference(entity, Imports.EXCLUDED);
    }

    @Override
    public Set<OWLClass> getClassesInSignature(boolean includeImportsClosure) {
        return this.getClassesInSignature(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean includeImportsClosure) {
        return this.getObjectPropertiesInSignature(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean includeImportsClosure) {
        return this.getDataPropertiesInSignature(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean includeImportsClosure) {
        return this.getIndividualsInSignature(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(boolean includeImportsClosure) {
        return this.getReferencedAnonymousIndividuals(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature(boolean includeImportsClosure) {
        return this.getDatatypesInSignature(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(boolean includeImportsClosure) {
        return this.getAnnotationPropertiesInSignature(Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity, boolean includeImportsClosure) {
        return this.containsEntityInSignature(owlEntity, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public boolean containsEntityInSignature(IRI entityIRI, boolean includeImportsClosure) {
        return this.containsEntityInSignature(entityIRI, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public boolean containsClassInSignature(IRI owlClassIRI, boolean includeImportsClosure) {
        return this.containsClassInSignature(owlClassIRI, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI owlObjectPropertyIRI, boolean includeImportsClosure) {
        return this.containsObjectPropertyInSignature(owlObjectPropertyIRI, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI owlDataPropertyIRI, boolean includeImportsClosure) {
        return this.containsDataPropertyInSignature(owlDataPropertyIRI, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI owlAnnotationPropertyIRI, boolean includeImportsClosure) {
        return this.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public boolean containsDatatypeInSignature(IRI owlDatatypeIRI, boolean includeImportsClosure) {
        return this.containsDatatypeInSignature(owlDatatypeIRI, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public boolean containsIndividualInSignature(IRI owlIndividualIRI, boolean includeImportsClosure) {
        return this.containsIndividualInSignature(owlIndividualIRI, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean includeImportsClosure) {
        return this.getEntitiesInSignature(iri, Imports.fromBoolean(includeImportsClosure));
    }

    @Override
    public boolean containsReference(OWLEntity entity, boolean includeImportsClosure) {
        return this.containsReference(entity, Imports.fromBoolean(includeImportsClosure));
    }
}

