/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IntContainer;
import com.carrotsearch.hppcrt.IntDeque;
import com.carrotsearch.hppcrt.IntIndexedContainer;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.lists.IntLinkedList;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.procedures.IntProcedure;
import com.carrotsearch.hppcrt.sorting.IntSort;
import com.carrotsearch.hppcrt.strategies.IntComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayDeque
extends AbstractIntCollection
implements IntDeque,
IntIndexedContainer,
Cloneable {
    public int[] buffer;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<IntCursor, DescendingValueIterator> descendingValueIteratorPool;
    protected final IteratorPool<IntCursor, ValueIterator> valueIteratorPool;

    public IntArrayDeque() {
        this(8);
    }

    public IntArrayDeque(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public IntArrayDeque(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = IntArrayDeque.this.head >= 1 ? IntArrayDeque.this.head - 1 : IntArrayDeque.this.buffer.length - 1;
                obj.remaining = IntArrayDeque.this.size();
            }

            @Override
            public void reset(ValueIterator obj) {
            }
        });
        this.descendingValueIteratorPool = new IteratorPool(new ObjectFactory<DescendingValueIterator>(){

            @Override
            public DescendingValueIterator create() {
                return new DescendingValueIterator();
            }

            @Override
            public void initialize(DescendingValueIterator obj) {
                obj.cursor.index = IntArrayDeque.this.tail;
                obj.remaining = IntArrayDeque.this.size();
            }

            @Override
            public void reset(DescendingValueIterator obj) {
            }
        });
    }

    public IntArrayDeque(IntContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(int e1) {
        int h2;
        int n = h2 = this.head >= 1 ? this.head - 1 : this.buffer.length - 1;
        if (h2 == this.tail) {
            this.ensureBufferSpace(1);
            h2 = this.head >= 1 ? this.head - 1 : this.buffer.length - 1;
        }
        this.head = h2;
        this.buffer[this.head] = e1;
    }

    public void addFirst(int ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addFirst(elements[i]);
        }
    }

    public int addFirst(IntContainer container) {
        return this.addFirst((Iterable<? extends IntCursor>)container);
    }

    public int addFirst(Iterable<? extends IntCursor> iterable) {
        int size = 0;
        for (IntCursor intCursor : iterable) {
            this.addFirst(intCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(int e1) {
        int t;
        int n = t = this.tail + 1 == this.buffer.length ? 0 : this.tail + 1;
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = this.tail + 1 == this.buffer.length ? 0 : this.tail + 1;
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public void addLast(int ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public int addLast(IntContainer container) {
        return this.addLast((Iterable<? extends IntCursor>)container);
    }

    public int addLast(Iterable<? extends IntCursor> iterable) {
        int size = 0;
        for (IntCursor intCursor : iterable) {
            this.addLast(intCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public int removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        int result = this.buffer[this.head];
        this.head = this.head + 1 == this.buffer.length ? 0 : this.head + 1;
        return result;
    }

    @Override
    public int removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = this.tail >= 1 ? this.tail - 1 : this.buffer.length - 1;
        int result = this.buffer[this.tail];
        return result;
    }

    @Override
    public int getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public int getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.tail >= 1 ? this.tail - 1 : this.buffer.length - 1];
    }

    @Override
    public int removeFirst(int e1) {
        int pos = -1;
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            pos = this.bufferIndexToPosition(index);
            this.removeBufferIndicesRange(index, index + 1 == this.buffer.length ? 0 : index + 1);
        }
        return pos;
    }

    public int bufferIndexOf(int e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int[] buffer = this.buffer;
        int i = this.head;
        while (i != last) {
            if (e1 == buffer[i]) {
                return i;
            }
            i = i + 1 == bufLen ? 0 : i + 1;
        }
        return -1;
    }

    @Override
    public int removeLast(int e1) {
        int pos = -1;
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            pos = this.bufferIndexToPosition(index);
            this.removeBufferIndicesRange(index, index + 1 == this.buffer.length ? 0 : index + 1);
        }
        return pos;
    }

    public int lastBufferIndexOf(int e1) {
        int i;
        int bufLen = this.buffer.length;
        int last = this.head >= 1 ? this.head - 1 : bufLen - 1;
        int[] buffer = this.buffer;
        int n = i = this.tail >= 1 ? this.tail - 1 : bufLen - 1;
        while (i != last) {
            if (e1 == buffer[i]) {
                return i;
            }
            i = i >= 1 ? i - 1 : bufLen - 1;
        }
        return -1;
    }

    @Override
    public int indexOf(int e1) {
        return this.bufferIndexToPosition(this.bufferIndexOf(e1));
    }

    @Override
    public int lastIndexOf(int e1) {
        return this.bufferIndexToPosition(this.lastBufferIndexOf(e1));
    }

    @Override
    public int removeAll(int e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int[] buffer = this.buffer;
        int from = to = this.head;
        while (from != last) {
            if (e1 == buffer[from]) {
                ++removed;
            } else {
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                to = to + 1 == bufLen ? 0 : to + 1;
            }
            from = from + 1 == bufLen ? 0 : from + 1;
        }
        this.tail = to;
        return removed;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public void clear() {
        this.tail = 0;
        this.head = 0;
    }

    private void compactBeforeSorting() {
        if (this.head > this.tail) {
            int size = this.size();
            System.arraycopy(this.buffer, this.head, this.buffer, this.tail, this.buffer.length - this.head);
            this.head = 0;
            this.tail = size;
        }
    }

    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = new int[8];
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int elementsCount;
        int bufferLen = this.buffer == null ? 0 : this.buffer.length;
        int n = elementsCount = this.buffer == null ? 0 : this.size();
        if (elementsCount + 1 > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions);
            if (this.buffer == null) {
                ++newSize;
            }
            try {
                int[] newBuffer = new int[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public int[] toArray(int[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public IntArrayDeque clone() {
        IntArrayDeque cloned = new IntArrayDeque(8, this.resizer);
        cloned.buffer = (int[])this.buffer.clone();
        cloned.head = this.head;
        cloned.tail = this.tail;
        return cloned;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    public DescendingValueIterator descendingIterator() {
        return (DescendingValueIterator)this.descendingValueIteratorPool.borrow();
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure) {
        this.internalForEach(procedure, this.head, this.tail);
        return procedure;
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return procedure;
        }
        int bufferPositionStart = this.indexToBufferPosition(fromIndex);
        int endBufferPosInclusive = this.indexToBufferPosition(toIndex - 1);
        this.internalForEach(procedure, bufferPositionStart, endBufferPosInclusive + 1 == this.buffer.length ? 0 : endBufferPosInclusive + 1);
        return procedure;
    }

    private void internalForEach(IntProcedure procedure, int fromIndexBuffer, int toIndexBuffer) {
        int[] buffer = this.buffer;
        int i = fromIndexBuffer;
        while (i != toIndexBuffer) {
            procedure.apply(buffer[i]);
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate) {
        this.internalForEach(predicate, this.head, this.tail);
        return predicate;
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return predicate;
        }
        int bufferPositionStart = this.indexToBufferPosition(fromIndex);
        int endBufferPosInclusive = this.indexToBufferPosition(toIndex - 1);
        this.internalForEach(predicate, bufferPositionStart, endBufferPosInclusive + 1 == this.buffer.length ? 0 : endBufferPosInclusive + 1);
        return predicate;
    }

    private void internalForEach(IntPredicate predicate, int fromIndexBuffer, int toIndexBuffer) {
        int[] buffer = this.buffer;
        int i = fromIndexBuffer;
        while (i != toIndexBuffer && predicate.apply(buffer[i])) {
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
    }

    @Override
    public <T extends IntProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(IntProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        int[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = i >= 1 ? i - 1 : buffer.length - 1;
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends IntPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(IntPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        int[] buffer = this.buffer;
        int i = toIndex;
        do {
            int n = i = i >= 1 ? i - 1 : buffer.length - 1;
        } while (predicate.apply(buffer[i]) && i != fromIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(IntPredicate predicate) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int[] buffer = this.buffer;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(buffer[from])) {
                    ++removed;
                } else {
                    if (to != from) {
                        buffer[to] = buffer[from];
                    }
                    to = to + 1 == bufLen ? 0 : to + 1;
                }
                from = from + 1 == bufLen ? 0 : from + 1;
            }
        }
        catch (Throwable throwable) {
            while (from != last) {
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                to = to + 1 == bufLen ? 0 : to + 1;
                from = from + 1 == bufLen ? 0 : from + 1;
            }
            this.tail = to;
            throw throwable;
        }
        while (from != last) {
            if (to != from) {
                buffer[to] = buffer[from];
            }
            to = to + 1 == bufLen ? 0 : to + 1;
            from = from + 1 == bufLen ? 0 : from + 1;
        }
        this.tail = to;
        return removed;
    }

    @Override
    public boolean contains(int e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        int[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (e == buffer[i]) {
                return true;
            }
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        int[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h2 = 31 * h2 + BitMixer.mix(buffer[i]);
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IntLinkedList) {
                IntLinkedList other = (IntLinkedList)obj;
                if (other.size() != this.size()) {
                    return false;
                }
                ValueIterator it = this.iterator();
                IntLinkedList.ValueIterator itOther = other.iterator();
                while (it.hasNext()) {
                    int myVal = ((IntCursor)it.next()).value;
                    int otherVal = ((IntCursor)itOther.next()).value;
                    if (myVal == otherVal) continue;
                    it.release();
                    itOther.release();
                    return false;
                }
                itOther.release();
                return true;
            }
            if (obj instanceof IntIndexedContainer) {
                IntIndexedContainer other = (IntIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean allIndexesEqual(IntIndexedContainer b1, IntIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            int o2;
            int o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static IntArrayDeque newInstance() {
        return new IntArrayDeque();
    }

    public static IntArrayDeque newInstance(int initialCapacity) {
        return new IntArrayDeque(initialCapacity);
    }

    public static IntArrayDeque from(int ... elements) {
        IntArrayDeque coll = new IntArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    public static IntArrayDeque from(IntContainer container) {
        return new IntArrayDeque(container);
    }

    public void sort(int beginIndex, int endIndex) {
        this.checkRangeBounds(beginIndex, endIndex);
        if (beginIndex == endIndex) {
            return;
        }
        int bufferPosStart = this.indexToBufferPosition(beginIndex);
        int bufferPosEndInclusive = this.indexToBufferPosition(endIndex - 1);
        if (bufferPosEndInclusive > bufferPosStart) {
            IntSort.quicksort(this.buffer, bufferPosStart, bufferPosEndInclusive + 1);
        } else {
            IntSort.quicksort(this, beginIndex, endIndex);
        }
    }

    public void sort(int beginIndex, int endIndex, IntComparator comp) {
        this.checkRangeBounds(beginIndex, endIndex);
        if (beginIndex == endIndex) {
            return;
        }
        int bufferPosStart = this.indexToBufferPosition(beginIndex);
        int bufferPosEndInclusive = this.indexToBufferPosition(endIndex - 1);
        if (bufferPosEndInclusive > bufferPosStart) {
            IntSort.quicksort(this.buffer, bufferPosStart, bufferPosEndInclusive + 1, comp);
        } else {
            IntSort.quicksort(this, beginIndex, endIndex, comp);
        }
    }

    public void sort() {
        if (this.size() > 1) {
            this.compactBeforeSorting();
            IntSort.quicksort(this.buffer, this.head, this.tail);
        }
    }

    public void sort(IntComparator comp) {
        if (this.size() > 1) {
            this.compactBeforeSorting();
            IntSort.quicksort(this.buffer, this.head, this.tail, comp);
        }
    }

    @Override
    public void add(int e1) {
        this.addLast(e1);
    }

    @Override
    public void insert(int index, int e1) {
        throw new UnsupportedOperationException("insert(final int index, final KType e1) operation is not supported on KTypeArrayDeque");
    }

    @Override
    public int set(int index, int e1) {
        int indexInBuffer = this.indexToBufferPosition(index);
        int previous = this.buffer[indexInBuffer];
        this.buffer[indexInBuffer] = e1;
        return previous;
    }

    @Override
    public int get(int index) {
        return this.buffer[this.indexToBufferPosition(index)];
    }

    @Override
    public int remove(int index) {
        int indexInBuffer = this.indexToBufferPosition(index);
        int previous = this.buffer[indexInBuffer];
        this.removeBufferIndicesRange(indexInBuffer, indexInBuffer + 1 == this.buffer.length ? 0 : indexInBuffer + 1);
        return previous;
    }

    private void removeBufferIndicesRange(int fromBufferIndex, int toBufferIndex) {
        int to;
        int bufLen = this.buffer.length;
        int[] buffer = this.buffer;
        if (fromBufferIndex == toBufferIndex) {
            return;
        }
        long nbToBeRemoved = (long)toBufferIndex - (long)fromBufferIndex;
        if (nbToBeRemoved < 0L) {
            nbToBeRemoved += (long)bufLen;
        }
        int last = this.tail;
        long removed = 0L;
        int from = to = fromBufferIndex;
        while (from != last) {
            if (removed < nbToBeRemoved) {
                ++removed;
            } else {
                buffer[to] = buffer[from];
                to = to + 1 == bufLen ? 0 : to + 1;
            }
            from = from + 1 == bufLen ? 0 : from + 1;
        }
        this.tail = to;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int bufferPositionStart = this.indexToBufferPosition(fromIndex);
        int bufferPositionEndInclusive = this.indexToBufferPosition(toIndex - 1);
        this.removeBufferIndicesRange(bufferPositionStart, bufferPositionEndInclusive + 1 == this.buffer.length ? 0 : bufferPositionEndInclusive + 1);
    }

    private int bufferIndexToPosition(int bufferIndex) {
        int pos = -1;
        if (bufferIndex >= 0 && (pos = bufferIndex - this.head) < 0) {
            pos += this.buffer.length;
        }
        return pos;
    }

    private int indexToBufferPosition(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds [" + 0 + ", size=" + this.size() + "[.");
        }
        long bufferPos = (long)index + (long)this.head;
        if (bufferPos >= (long)this.buffer.length) {
            bufferPos -= (long)this.buffer.length;
        }
        return (int)bufferPos;
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.size() + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DescendingValueIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = IntArrayDeque.this.tail;
            this.remaining = IntArrayDeque.this.size();
        }

        @Override
        protected IntCursor fetch() {
            if (this.remaining == 0) {
                return (IntCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = this.cursor.index >= 1 ? this.cursor.index - 1 : IntArrayDeque.this.buffer.length - 1;
            this.cursor.value = IntArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = IntArrayDeque.this.head >= 1 ? IntArrayDeque.this.head - 1 : IntArrayDeque.this.buffer.length - 1;
            this.remaining = IntArrayDeque.this.size();
        }

        @Override
        protected IntCursor fetch() {
            if (this.remaining == 0) {
                return (IntCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = this.cursor.index + 1 == IntArrayDeque.this.buffer.length ? 0 : this.cursor.index + 1;
            this.cursor.value = IntArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

