/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import com.google.common.base.Optional;
import java.io.IOException;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

public class Obo2Owl
extends OWLAPIObo2Owl {
    @Deprecated
    public static final String DEFAULT_IRI_PREFIX = "http://purl.obolibrary.org/obo/";

    public Obo2Owl() {
        this(OWLManager.createOWLOntologyManager());
    }

    public Obo2Owl(OWLOntologyManager manager) {
        super(manager);
    }

    public static void convertURL(String iri, String outFile) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException, OBOFormatParserException {
        Obo2Owl.convertURL(iri, outFile, OWLManager.createOWLOntologyManager());
    }

    public OWLOntology convert(OBODoc obodoc, boolean useFreshManager) throws OWLOntologyCreationException {
        this.obodoc = obodoc;
        if (useFreshManager) {
            this.init(OWLManager.createOWLOntologyManager());
        } else {
            this.init(this.manager);
        }
        return this.tr();
    }

    private OWLOntology tr() throws OWLOntologyCreationException {
        Frame hf = this.obodoc.getHeaderFrame();
        Clause ontClause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY);
        if (ontClause != null) {
            String ontOboId;
            this.defaultIDSpace = ontOboId = (String)ontClause.getValue();
            Optional<IRI> ontIRI = ontOboId.contains(":") ? Optional.of(IRI.create(ontOboId)) : Optional.of(IRI.create(DEFAULT_IRI_PREFIX + ontOboId + ".owl"));
            Clause dvclause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION);
            if (dvclause != null) {
                String dv = dvclause.getValue().toString();
                Optional<IRI> vIRI = Optional.of(IRI.create(DEFAULT_IRI_PREFIX + ontOboId + "/" + dv + "/" + ontOboId + ".owl"));
                OWLOntologyID oid = new OWLOntologyID(ontIRI, vIRI);
                this.owlOntology = this.manager.createOntology(oid);
            } else {
                this.owlOntology = this.manager.createOntology(ontIRI.get());
            }
        } else {
            this.defaultIDSpace = "TEMP";
            IRI ontIRI = IRI.create(DEFAULT_IRI_PREFIX + this.defaultIDSpace);
            this.owlOntology = this.manager.createOntology(ontIRI);
        }
        this.trHeaderFrame(hf);
        for (Frame f : this.obodoc.getTypedefFrames()) {
            this.trTypedefToAnnotationProperty(f);
        }
        for (Frame f : this.obodoc.getTypedefFrames()) {
            this.trTypedefFrame(f);
        }
        for (Frame f : this.obodoc.getTermFrames()) {
            this.trTermFrame(f);
        }
        for (Clause cl : hf.getClauses(OBOFormatConstants.OboFormatTag.TAG_IMPORT)) {
            String path = Obo2Owl.getURI(cl.getValue().toString());
            IRI importIRI = IRI.create(path);
            this.manager.loadOntology(importIRI);
            AddImport ai = new AddImport(this.owlOntology, this.fac.getOWLImportsDeclaration(importIRI));
            this.manager.applyChange(ai);
        }
        this.postProcess(this.owlOntology);
        return this.owlOntology;
    }
}

