/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import com.carrotsearch.hppcrt.maps.ObjectIntHashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFTriple
implements Serializable,
Comparable<RDFTriple> {
    private static final long serialVersionUID = 40000L;
    static final ObjectIntHashMap<IRI> specialPredicateRanks = RDFTriple.initMap();
    @Nonnull
    private final RDFResource subject;
    @Nonnull
    private final RDFResourceIRI predicate;
    @Nonnull
    private final RDFNode object;

    public RDFTriple(@Nonnull RDFResource subject, @Nonnull RDFResourceIRI predicate, @Nonnull RDFNode object) {
        this.subject = OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        this.predicate = OWLAPIPreconditions.checkNotNull(predicate, "predicate cannot be null");
        this.object = OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
    }

    public RDFTriple(@Nonnull IRI subject, boolean subjectAnon, boolean subjectAxiom, @Nonnull IRI predicate, @Nonnull IRI object, boolean objectAnon, boolean objectAxiom) {
        this(RDFTriple.getResource(subject, subjectAnon, subjectAxiom), new RDFResourceIRI(predicate), RDFTriple.getResource(object, objectAnon, objectAxiom));
    }

    @Nonnull
    private static RDFResource getResource(@Nonnull IRI iri, boolean anon, boolean axiom) {
        if (anon) {
            return new RDFResourceBlankNode(iri, true, true, axiom);
        }
        return new RDFResourceIRI(iri);
    }

    static ObjectIntHashMap<IRI> initMap() {
        ObjectIntHashMap<IRI> predicates = new ObjectIntHashMap<IRI>();
        AtomicInteger nextId = new AtomicInteger(1);
        List<OWLRDFVocabulary> ORDERED_URIS = Arrays.asList(OWLRDFVocabulary.RDF_TYPE, OWLRDFVocabulary.RDFS_LABEL, OWLRDFVocabulary.OWL_DEPRECATED, OWLRDFVocabulary.RDFS_COMMENT, OWLRDFVocabulary.RDFS_IS_DEFINED_BY, OWLRDFVocabulary.RDF_FIRST, OWLRDFVocabulary.RDF_REST, OWLRDFVocabulary.OWL_EQUIVALENT_CLASS, OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY, OWLRDFVocabulary.RDFS_SUBCLASS_OF, OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF, OWLRDFVocabulary.RDFS_DOMAIN, OWLRDFVocabulary.RDFS_RANGE, OWLRDFVocabulary.OWL_DISJOINT_WITH, OWLRDFVocabulary.OWL_ON_PROPERTY, OWLRDFVocabulary.OWL_DATA_RANGE, OWLRDFVocabulary.OWL_ON_CLASS, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY, OWLRDFVocabulary.OWL_ANNOTATED_TARGET);
        ORDERED_URIS.forEach(iri -> predicates.put(iri.getIRI(), nextId.getAndIncrement()));
        Stream.of(OWLRDFVocabulary.values()).forEach(iri -> predicates.putIfAbsent(iri.getIRI(), nextId.getAndIncrement()));
        return predicates;
    }

    private static int comparePredicates(RDFResourceIRI predicate, RDFResourceIRI otherPredicate) {
        IRI predicateIRI = predicate.getIRI();
        int specialPredicateRank = specialPredicateRanks.get(predicateIRI);
        IRI otherPredicateIRI = otherPredicate.getIRI();
        int otherSpecialPredicateRank = specialPredicateRanks.get(otherPredicateIRI);
        if (specialPredicateRank != specialPredicateRanks.getDefaultValue()) {
            if (otherSpecialPredicateRank != specialPredicateRanks.getDefaultValue()) {
                return Integer.compare(specialPredicateRank, otherSpecialPredicateRank);
            }
            return -1;
        }
        if (otherSpecialPredicateRank != specialPredicateRanks.getDefaultValue()) {
            return 1;
        }
        return predicateIRI.compareTo(otherPredicateIRI);
    }

    public RDFTriple(@Nonnull IRI subject, boolean subjectAnon, boolean axiom, @Nonnull IRI predicate, @Nonnull OWLLiteral object) {
        this(RDFTriple.getResource(subject, subjectAnon, axiom), new RDFResourceIRI(predicate), new RDFLiteral(object));
    }

    public boolean isSubjectSameAsObject() {
        return this.subject.equals(this.object);
    }

    @Nonnull
    public RDFResource getSubject() {
        return this.subject;
    }

    @Nonnull
    public RDFResourceIRI getPredicate() {
        return this.predicate;
    }

    @Nonnull
    public RDFNode getObject() {
        return this.object;
    }

    public int hashCode() {
        return this.subject.hashCode() * 37 + this.predicate.hashCode() * 17 + this.object.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDFTriple)) {
            return false;
        }
        RDFTriple other = (RDFTriple)obj;
        return this.subject.equals(other.subject) && this.predicate.equals(other.predicate) && this.object.equals(other.object);
    }

    public String toString() {
        return String.format("%s %s %s.\n", this.subject, this.predicate, this.object);
    }

    @Override
    public int compareTo(RDFTriple o) {
        int diff = RDFTriple.comparePredicates(this.predicate, o.predicate);
        if (diff == 0) {
            diff = this.subject.compareTo(o.subject);
        }
        if (diff == 0) {
            diff = this.object.compareTo(o.object);
        }
        return diff;
    }
}

