/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.renderer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.krss2.renderer.KRSSVocabulary;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class KRSSObjectRenderer
extends OWLObjectVisitorAdapter {
    @Nonnull
    private static final String OPEN_BRACKET = "(";
    @Nonnull
    private static final String CLOSE_BRACKET = ")";
    @Nonnull
    private static final String NEWLINE = "\n";
    @Nonnull
    protected final OWLOntology ont;
    @Nonnull
    protected final Writer writer;
    private int pos = 0;
    private int lastNewLinePos = 0;

    public KRSSObjectRenderer(@Nonnull OWLOntology ontology, @Nonnull Writer writer) {
        this.ont = OWLAPIPreconditions.checkNotNull(ontology);
        this.writer = new PrintWriter(writer);
    }

    @Nonnull
    protected static <T extends OWLObject> List<T> sort(@Nonnull Collection<T> objects) {
        return CollectionFactory.sortOptionally(objects);
    }

    @Nonnull
    protected static <T extends OWLObject> List<T> sort(@Nonnull Iterable<T> objects) {
        ArrayList<OWLObject> sortedDescriptions = new ArrayList<OWLObject>();
        for (OWLObject t : objects) {
            sortedDescriptions.add(t);
        }
        return CollectionFactory.sortOptionally(sortedDescriptions);
    }

    protected void writeOpenBracket() {
        this.write(OPEN_BRACKET);
    }

    protected void writeCloseBracket() {
        this.write(CLOSE_BRACKET);
    }

    protected void write(int i) {
        this.write(" " + i);
    }

    protected void write(@Nonnull IRI iri) {
        this.write(iri.toString());
    }

    protected void write(@Nonnull KRSSVocabulary v) {
        this.write(v.toString());
    }

    protected void writeSpace() {
        this.write(" ");
    }

    protected void write(@Nonnull String s2) {
        try {
            int newLineIndex = s2.indexOf(10);
            if (newLineIndex != -1) {
                this.lastNewLinePos = this.pos + newLineIndex;
            }
            this.pos += s2.length();
            this.writer.write(s2);
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    protected int getIndent() {
        return this.pos - this.lastNewLinePos - 1;
    }

    protected void writeIndent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.writeSpace();
        }
    }

    protected void writeln() {
        this.write(NEWLINE);
    }

    protected void write(@Nonnull OWLClassExpression obj) {
        this.writeSpace();
        obj.accept(this);
    }

    protected void write(@Nonnull OWLIndividual ind) {
        this.writeSpace();
        ind.accept(this);
    }

    protected void write(@Nonnull OWLPropertyExpression obj) {
        this.writeSpace();
        obj.accept(this);
    }

    protected void write(@Nonnull OWLDataRange obj) {
        this.writeSpace();
        obj.accept(this);
    }

    protected void flattenProperties(@Nonnull Iterable<OWLObjectPropertyExpression> properties, @Nullable KRSSVocabulary junctor) {
        List<OWLObjectPropertyExpression> props = KRSSObjectRenderer.sort(properties);
        int size = props.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            this.write(properties.iterator().next());
            return;
        }
        if (junctor != null) {
            this.writeOpenBracket();
            this.write(junctor);
        }
        this.write(props.get(0));
        int indent = this.getIndent();
        for (int i = 1; i < size; ++i) {
            this.writeln();
            this.writeIndent(indent);
            this.write(props.get(i));
        }
        if (junctor != null) {
            this.writeCloseBracket();
        }
    }

    protected void flatten(@Nonnull Iterable<OWLClassExpression> description, @Nonnull KRSSVocabulary junctor) {
        List<OWLClassExpression> descs = KRSSObjectRenderer.sort(description);
        int size = descs.size();
        if (size == 0) {
            return;
        }
        this.write(descs.get(0));
        if (size == 1) {
            return;
        }
        this.writeOpenBracket();
        this.write(junctor);
        int indent = this.getIndent();
        for (int i = 1; i < size; ++i) {
            this.writeln();
            this.writeIndent(indent);
            this.write(descs.get(i));
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLOntology ontology) {
        Set<OWLClass> classes = ontology.getClassesInSignature();
        classes.remove(ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing());
        classes.remove(ontology.getOWLOntologyManager().getOWLDataFactory().getOWLNothing());
        for (OWLClass eachClass : KRSSObjectRenderer.sort(classes)) {
            boolean primitive;
            boolean bl = primitive = !EntitySearcher.isDefined(eachClass, ontology);
            if (primitive) {
                this.writeOpenBracket();
                this.write(KRSSVocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write(eachClass);
                this.writeSpace();
                Collection<OWLClassExpression> supclasses = Searcher.sup(ontology.getSubClassAxiomsForSubClass(eachClass), OWLClassExpression.class);
                this.flatten(supclasses, KRSSVocabulary.AND);
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSSVocabulary.DEFINE_CONCEPT);
            this.write(eachClass);
            Collection<OWLClassExpression> equivalentClasses = Searcher.equivalent(ontology.getEquivalentClassesAxioms(eachClass));
            this.flatten(equivalentClasses, KRSSVocabulary.AND);
            this.writeCloseBracket();
            this.writeln();
        }
        for (OWLObjectProperty property : KRSSObjectRenderer.sort(ontology.getObjectPropertiesInSignature())) {
            boolean isDefined;
            this.writeOpenBracket();
            Collection<Object> properties = Searcher.equivalent(ontology.getEquivalentObjectPropertiesAxioms(property));
            boolean bl = isDefined = !properties.isEmpty();
            if (isDefined) {
                this.write(KRSSVocabulary.DEFINE_ROLE);
                this.write(property);
                properties.remove(property);
                if (!properties.isEmpty()) {
                    this.write((OWLPropertyExpression)properties.iterator().next());
                }
            } else {
                this.write(KRSSVocabulary.DEFINE_PRIMITIVE_ROLE);
                this.write(property);
                this.writeSpace();
                Collection axioms = ontology.filterAxioms(Filters.subObjectPropertyWithSub, property, Imports.INCLUDED);
                properties = Searcher.sup(axioms, OWLObjectPropertyExpression.class);
                if (!properties.isEmpty()) {
                    this.write((OWLPropertyExpression)properties.iterator().next());
                }
            }
            this.writeCloseBracket();
            this.writeln();
        }
        for (OWLAxiom axiom : ontology.getAxioms()) {
            axiom.accept(this);
        }
        try {
            this.writer.flush();
        }
        catch (IOException io) {
            throw new OWLRuntimeException(io);
        }
    }

    @Override
    public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        List<OWLClassExpression> classes = KRSSObjectRenderer.sort(axiom.getClassExpressions());
        int size = classes.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSSVocabulary.DISJOINT);
                this.write(classes.get(i));
                this.write(classes.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.DOMAIN);
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.write(axiom.getDomain());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
        List<OWLIndividual> individuals = KRSSObjectRenderer.sort(axiom.getIndividuals());
        int size = individuals.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSSVocabulary.DISTINCT);
                this.write(individuals.get(i));
                this.write(individuals.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.RANGE);
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.write((OWLClassExpression)axiom.getRange());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.RELATED);
        this.write(axiom.getSubject());
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.write((OWLIndividual)axiom.getObject());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.INSTANCE);
        this.write(axiom.getIndividual());
        this.write(axiom.getClassExpression());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.TRANSITIVE);
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
        List<OWLIndividual> individuals = KRSSObjectRenderer.sort(axiom.getIndividuals());
        int size = individuals.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSSVocabulary.EQUAL);
                this.write(individuals.get(i));
                this.write(individuals.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(@Nonnull OWLClass ce) {
        this.write(ce.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLObjectIntersectionOf ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AND);
        List<OWLClassExpression> operands = KRSSObjectRenderer.sort(ce.getOperands());
        int size = operands.size();
        if (size > 0) {
            int indent = this.getIndent();
            this.write(operands.get(0));
            for (int i = 1; i < size; ++i) {
                this.writeln();
                this.writeIndent(indent);
                this.write(operands.get(i));
            }
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectUnionOf ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.OR);
        List<OWLClassExpression> operands = KRSSObjectRenderer.sort(ce.getOperands());
        int size = operands.size();
        if (size > 0) {
            int indent = this.getIndent();
            this.write(operands.get(0));
            for (int i = 1; i < size; ++i) {
                this.writeln();
                this.writeIndent(indent);
                this.write(operands.get(i));
            }
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectComplementOf ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.NOT);
        this.write(ce.getOperand());
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectSomeValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.SOME);
        this.write(ce.getProperty());
        this.write((OWLClassExpression)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectAllValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.ALL);
        this.write(ce.getProperty());
        this.write((OWLClassExpression)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectMinCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_LEAST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectExactCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.EXACTLY);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectMaxCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_MOST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLDataSomeValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.SOME);
        this.write(ce.getProperty());
        this.write((OWLDataRange)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLDataAllValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.ALL);
        this.write(ce.getProperty());
        this.write((OWLDataRange)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLDataMinCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_LEAST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLDataExactCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.EXACTLY);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLDataMaxCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_MOST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLLiteral node) {
        this.write(node.getLiteral());
    }

    @Override
    public void visit(@Nonnull OWLObjectProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLObjectInverseOf property) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.INVERSE);
        this.writeSpace();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLDataProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLNamedIndividual individual) {
        this.write(individual.getIRI());
    }
}

