/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.owlxml.parser.AbstractIRIElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnnotationPropertyElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnonymousIndividualElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLLiteralElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserHandler;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

class OWLAnnotationElementHandler
extends OWLElementHandler<OWLAnnotation> {
    @Nonnull
    final Set<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
    OWLAnnotationProperty property;
    OWLAnnotationValue object;

    OWLAnnotationElementHandler(@Nonnull OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    void startElement(String name) {
        super.startElement(name);
    }

    @Override
    void endElement() {
        this.getParentHandler().handleChild(this);
    }

    @Override
    void attribute(@Nonnull String localName, @Nonnull String value) {
        super.attribute(localName, value);
        if (localName.equals(OWLXMLVocabulary.ANNOTATION_URI.getShortForm())) {
            IRI iri = this.handler.getIRI(value);
            this.property = this.df.getOWLAnnotationProperty(iri);
        }
    }

    @Override
    void handleChild(@Nonnull OWLAnnotationElementHandler h2) {
        this.annotations.add(h2.getOWLObject());
    }

    @Override
    void handleChild(@Nonnull OWLAnonymousIndividualElementHandler h2) {
        this.object = h2.getOWLObject();
    }

    @Override
    void handleChild(@Nonnull OWLLiteralElementHandler h2) {
        this.object = h2.getOWLObject();
    }

    @Override
    void handleChild(@Nonnull OWLAnnotationPropertyElementHandler h2) {
        this.property = h2.getOWLObject();
    }

    @Override
    void handleChild(@Nonnull AbstractIRIElementHandler h2) {
        this.object = (OWLAnnotationValue)h2.getOWLObject();
    }

    @Override
    OWLAnnotation getOWLObject() {
        return this.df.getOWLAnnotation(OWLAPIPreconditions.verifyNotNull(this.property), OWLAPIPreconditions.verifyNotNull(this.object), this.annotations);
    }
}

