/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.owlxml.parser.AbstractClassExpressionElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLAxiomElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLDataRangeHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnnotationElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserHandler;

class OWLOntologyHandler
extends OWLElementHandler<OWLOntology> {
    OWLOntologyHandler(@Nonnull OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    void startElement(String name) {
    }

    @Override
    void attribute(@Nonnull String localName, String value) {
        OWLOntologyID newID;
        if (localName.equals("ontologyIRI")) {
            newID = new OWLOntologyID(IRI.create(value), this.handler.getOntology().getOntologyID().getVersionIRI().orNull());
            this.handler.getOWLOntologyManager().applyChange(new SetOntologyID(this.handler.getOntology(), newID));
        }
        if (localName.equals("versionIRI")) {
            newID = new OWLOntologyID(this.handler.getOntology().getOntologyID().getOntologyIRI().orNull(), IRI.create(value));
            this.handler.getOWLOntologyManager().applyChange(new SetOntologyID(this.handler.getOntology(), newID));
        }
    }

    @Override
    void handleChild(@Nonnull AbstractOWLAxiomElementHandler h2) {
        OWLAxiom axiom = h2.getOWLObject();
        if (!axiom.isAnnotationAxiom() || this.handler.getConfiguration().isLoadAnnotationAxioms()) {
            this.handler.getOWLOntologyManager().applyChange(new AddAxiom(this.handler.getOntology(), axiom));
        }
    }

    @Override
    void handleChild(AbstractOWLDataRangeHandler h2) {
    }

    @Override
    void handleChild(AbstractClassExpressionElementHandler h2) {
    }

    @Override
    void handleChild(@Nonnull OWLAnnotationElementHandler h2) {
        this.handler.getOWLOntologyManager().applyChange(new AddOntologyAnnotation(this.handler.getOntology(), h2.getOWLObject()));
    }

    @Override
    void endElement() {
    }

    @Override
    OWLOntology getOWLObject() {
        return this.handler.getOntology();
    }

    @Override
    void setParentHandler(OWLElementHandler<?> handler) {
    }
}

