/*
 * Decompiled with CFR 0.152.
 */
package owltools.ncbi;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import owltools.ncbi.OWLConverter;

public class NCBIConverter
extends OWLConverter {
    protected static final Logger logger = Logger.getLogger(OWLConverter.class);

    protected static IRI createNCBIIRI(String id) {
        if (id.equals("taxonomic_rank") || id.equals("species_group") || id.equals("species_subgroup")) {
            return IRI.create("http://purl.obolibrary.org/obo/NCBITaxon#_" + id);
        }
        return IRI.create("http://purl.obolibrary.org/obo/NCBITaxon_" + id);
    }

    protected static IRI createNCBIIRI(int id) {
        return IRI.create("http://purl.obolibrary.org/obo/NCBITaxon_" + id);
    }

    protected static OWLSubClassOfAxiom assertSubClass(OWLOntology ontology, OWLClass child, String parentID) {
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        IRI iri = NCBIConverter.createNCBIIRI(parentID);
        OWLClass parent = dataFactory.getOWLClass(iri);
        return NCBIConverter.assertSubClass(ontology, child, parent);
    }

    public static String getTaxonID(OWLClass taxon) {
        IRI iri = taxon.getIRI();
        String iriString = iri.toString();
        if (iriString.startsWith("http://purl.obolibrary.org/obo/NCBITaxon_")) {
            return iriString.replaceFirst("^http://purl.obolibrary.org/obo/NCBITaxon_", "");
        }
        return null;
    }

    public static OWLClass createTaxon(OWLOntology ontology, String id) {
        IRI iri = NCBIConverter.createNCBIIRI(id);
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLClass taxon = dataFactory.getOWLClass(iri);
        NCBIConverter.declare(ontology, taxon);
        NCBIConverter.annotate(ontology, (OWLEntity)taxon, "oio:hasOBONamespace", "ncbi_taxonomy");
        return taxon;
    }

    public static Boolean checkTaxon(OWLOntology ontology, OWLClass taxon) {
        String id = NCBIConverter.getTaxonID(taxon);
        String label = NCBIConverter.getFirstLiteral(ontology, (OWLEntity)taxon, "rdfs:label");
        if (label == null || label.trim().length() == 0) {
            logger.error("No SCIENTIFIC NAME provided for " + id);
            return false;
        }
        Set<OWLSubClassOfAxiom> axioms = ontology.getSubClassAxiomsForSubClass(taxon);
        HashSet<OWLClassExpression> superClasses = new HashSet<OWLClassExpression>();
        for (OWLSubClassOfAxiom ax : axioms) {
            superClasses.add(ax.getSuperClass());
        }
        if (superClasses.size() < 1 && !id.equals("1")) {
            logger.error("No PARENT ID for " + id);
            return false;
        }
        if (superClasses.size() > 1) {
            logger.error("Multiple PARENT IDs for " + id);
            return false;
        }
        return true;
    }
}

