/*
 * Decompiled with CFR 0.152.
 */
package owltools.ncbi;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.DefaultPrefixManager;

public class OWLConverter {
    protected static final String OBO = "http://purl.obolibrary.org/obo/";
    protected static final String OIO = "http://www.geneontology.org/formats/oboInOwl#";
    protected static final String IAO = "http://purl.obolibrary.org/obo/IAO_";
    protected static final String NCBI = "http://purl.obolibrary.org/obo/NCBITaxon_";
    protected static final Logger logger = Logger.getLogger(OWLConverter.class);
    protected static RDFXMLDocumentFormat format = OWLConverter.initializeFormat();

    protected static RDFXMLDocumentFormat initializeFormat() {
        RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
        format.copyPrefixesFrom(new DefaultPrefixManager());
        format.setPrefix("obo", OBO);
        format.setPrefix("oio", OIO);
        format.setPrefix("iao", IAO);
        format.setPrefix("ncbi", NCBI);
        format.setPrefix("ncbitaxon", "http://purl.obolibrary.org/obo/ncbitaxon#");
        return format;
    }

    protected static String reformatName(String name) {
        return name.replaceAll("\\s", "_").replaceAll("-", "_");
    }

    protected static OWLAnnotationProperty createAnnotationProperty(OWLOntology ontology, IRI iri) {
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLAnnotationProperty property = dataFactory.getOWLAnnotationProperty(iri);
        OWLConverter.declare(ontology, property);
        return property;
    }

    protected static OWLAnnotationProperty createAnnotationProperty(OWLOntology ontology, String curie) {
        return OWLConverter.createAnnotationProperty(ontology, format.getIRI(curie));
    }

    protected static OWLAnnotationProperty createAnnotationProperty(OWLOntology ontology, Obo2OWLConstants.Obo2OWLVocabulary term) {
        OWLAnnotationProperty property = OWLConverter.createAnnotationProperty(ontology, term.getIRI());
        OWLConverter.annotate(ontology, (OWLEntity)property, "rdfs:label", term.getLabel());
        return property;
    }

    protected static OWLDeclarationAxiom declare(OWLOntology ontology, OWLEntity subject) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory dataFactory = manager.getOWLDataFactory();
        OWLDeclarationAxiom axiom = dataFactory.getOWLDeclarationAxiom(subject);
        manager.addAxiom(ontology, axiom);
        return axiom;
    }

    protected static OWLAnnotationAssertionAxiom annotate(OWLOntology ontology, OWLEntity subject, OWLAnnotationProperty property, OWLAnnotationValue value) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory dataFactory = manager.getOWLDataFactory();
        OWLAnnotationAssertionAxiom axiom = dataFactory.getOWLAnnotationAssertionAxiom(property, subject.getIRI(), value);
        manager.addAxiom(ontology, axiom);
        return axiom;
    }

    protected static OWLAnnotationAssertionAxiom annotate(OWLOntology ontology, OWLEntity subject, String propertyCURIE, OWLAnnotationValue value) {
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        IRI iri = format.getIRI(propertyCURIE);
        OWLAnnotationProperty property = dataFactory.getOWLAnnotationProperty(iri);
        return OWLConverter.annotate(ontology, subject, property, value);
    }

    protected static OWLAnnotationAssertionAxiom annotate(OWLOntology ontology, OWLEntity subject, String propertyCURIE, String value) {
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLLiteral literal = dataFactory.getOWLLiteral(value);
        return OWLConverter.annotate(ontology, subject, propertyCURIE, (OWLAnnotationValue)literal);
    }

    protected static OWLAnnotationAssertionAxiom annotate(OWLOntology ontology, OWLEntity subject, String propertyCURIE, boolean value) {
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLLiteral literal = dataFactory.getOWLLiteral(value);
        return OWLConverter.annotate(ontology, subject, propertyCURIE, (OWLAnnotationValue)literal);
    }

    protected static OWLAnnotation annotate(OWLOntology ontology, String propertyCURIE, IRI value) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory dataFactory = manager.getOWLDataFactory();
        IRI iri = format.getIRI(propertyCURIE);
        OWLAnnotationProperty property = dataFactory.getOWLAnnotationProperty(iri);
        OWLAnnotation annotation = dataFactory.getOWLAnnotation(property, value);
        manager.applyChange(new AddOntologyAnnotation(ontology, annotation));
        return annotation;
    }

    protected static OWLAnnotation annotate(OWLOntology ontology, String propertyCURIE, String value) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory dataFactory = manager.getOWLDataFactory();
        IRI iri = format.getIRI(propertyCURIE);
        OWLAnnotationProperty property = dataFactory.getOWLAnnotationProperty(iri);
        OWLLiteral literal = dataFactory.getOWLLiteral(value);
        OWLAnnotation annotation = dataFactory.getOWLAnnotation(property, literal);
        manager.applyChange(new AddOntologyAnnotation(ontology, annotation));
        return annotation;
    }

    protected static OWLAnnotationAssertionAxiom updateAnnotation(OWLOntology ontology, OWLEntity subject, String propertyCURIE, String value) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLLiteral literal = factory.getOWLLiteral(value);
        IRI iri = format.getIRI(propertyCURIE);
        OWLAnnotationProperty property = factory.getOWLAnnotationProperty(iri);
        Set<OWLAnnotationAssertionAxiom> axioms = ontology.getAnnotationAssertionAxioms(subject.getIRI());
        for (OWLAnnotationAssertionAxiom axiom : axioms) {
            if (!property.equals(axiom.getProperty())) continue;
            manager.removeAxiom(ontology, axiom);
        }
        OWLAnnotationAssertionAxiom axiom = factory.getOWLAnnotationAssertionAxiom(property, subject.getIRI(), literal);
        manager.addAxiom(ontology, axiom);
        return axiom;
    }

    protected static OWLAnnotationAssertionAxiom synonym(OWLOntology ontology, OWLEntity subject, OWLAnnotationValue type, OWLAnnotationProperty property, OWLAnnotationValue value) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory dataFactory = manager.getOWLDataFactory();
        OWLAnnotationProperty hasSynonymType = dataFactory.getOWLAnnotationProperty(format.getIRI("oio:hasSynonymType"));
        OWLAnnotation annotation = dataFactory.getOWLAnnotation(hasSynonymType, type);
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        annotations.add(annotation);
        OWLAnnotationAssertionAxiom axiom = dataFactory.getOWLAnnotationAssertionAxiom(property, subject.getIRI(), value, annotations);
        manager.addAxiom(ontology, axiom);
        return axiom;
    }

    protected static OWLAnnotationAssertionAxiom synonym(OWLOntology ontology, OWLEntity subject, String typeCURIE, String propertyCURIE, String value) {
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        IRI type = format.getIRI(typeCURIE);
        OWLAnnotationProperty property = dataFactory.getOWLAnnotationProperty(format.getIRI(propertyCURIE));
        OWLLiteral literal = dataFactory.getOWLLiteral(value);
        return OWLConverter.synonym(ontology, subject, type, property, literal);
    }

    protected static OWLSubClassOfAxiom assertSubClass(OWLOntology ontology, OWLClass child, OWLClass parent) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory dataFactory = manager.getOWLDataFactory();
        OWLSubClassOfAxiom axiom = dataFactory.getOWLSubClassOfAxiom(child, parent);
        ontology.getOWLOntologyManager().addAxiom(ontology, axiom);
        return axiom;
    }

    protected static OWLSubAnnotationPropertyOfAxiom assertSubAnnotationProperty(OWLOntology ontology, OWLAnnotationProperty child, OWLAnnotationProperty parent) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory dataFactory = manager.getOWLDataFactory();
        OWLSubAnnotationPropertyOfAxiom axiom = dataFactory.getOWLSubAnnotationPropertyOfAxiom(child, parent);
        manager.addAxiom(ontology, axiom);
        return axiom;
    }

    protected static String getFirstLiteral(OWLOntology ontology, OWLEntity taxon, OWLAnnotationProperty property) {
        Set<OWLAnnotationAssertionAxiom> axioms = ontology.getAnnotationAssertionAxioms(taxon.getIRI());
        for (OWLAnnotationAssertionAxiom axiom : axioms) {
            OWLAnnotationValue value;
            if (!property.equals(axiom.getProperty()) || !((value = axiom.getValue()) instanceof OWLLiteral)) continue;
            OWLLiteral literal = (OWLLiteral)value;
            return literal.getLiteral();
        }
        return null;
    }

    protected static String getFirstLiteral(OWLOntology ontology, OWLEntity subject, IRI propertyIRI) {
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLAnnotationProperty property = dataFactory.getOWLAnnotationProperty(propertyIRI);
        return OWLConverter.getFirstLiteral(ontology, subject, property);
    }

    protected static String getFirstLiteral(OWLOntology ontology, OWLEntity subject, String propertyCURIE) {
        IRI propertyIRI = format.getIRI(propertyCURIE);
        return OWLConverter.getFirstLiteral(ontology, subject, propertyIRI);
    }
}

