/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.JSONLDMode;
import org.eclipse.rdf4j.rio.helpers.JSONLDSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.jsonld.JSONLDHierarchicalProcessor;
import org.eclipse.rdf4j.rio.jsonld.JSONLDInternalRDFParser;

public class JSONLDWriter
extends AbstractRDFWriter
implements RDFWriter,
CharSink {
    private final Model model = new LinkedHashModel();
    private final StatementCollector statementCollector = new StatementCollector(this.model);
    private final String baseURI;
    private final Writer writer;

    public JSONLDWriter(OutputStream outputStream) {
        this(outputStream, null);
    }

    public JSONLDWriter(OutputStream outputStream, String baseURI) {
        this.baseURI = baseURI;
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    public JSONLDWriter(Writer writer) {
        this(writer, null);
    }

    public JSONLDWriter(Writer writer, String baseURI) {
        this.baseURI = baseURI;
        this.writer = writer;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.checkWritingStarted();
        this.model.setNamespace(prefix, uri);
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        this.statementCollector.clear();
        this.model.clear();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        JSONLDInternalRDFParser serialiser = new JSONLDInternalRDFParser();
        try {
            JsonLdOptions opts = new JsonLdOptions();
            WriterConfig writerConfig = this.getWriterConfig();
            opts.setCompactArrays(writerConfig.get(JSONLDSettings.COMPACT_ARRAYS));
            opts.setProduceGeneralizedRdf(writerConfig.get(JSONLDSettings.PRODUCE_GENERALIZED_RDF));
            opts.setUseRdfType(writerConfig.get(JSONLDSettings.USE_RDF_TYPE));
            opts.setUseNativeTypes(writerConfig.get(JSONLDSettings.USE_NATIVE_TYPES));
            Map<String, Object> output = JsonLdProcessor.fromRDF(this.model, opts, serialiser);
            JSONLDMode mode = this.getWriterConfig().get(JSONLDSettings.JSONLD_MODE);
            if (writerConfig.get(JSONLDSettings.HIERARCHICAL_VIEW).booleanValue()) {
                output = JSONLDHierarchicalProcessor.fromJsonLdObject(output);
            }
            if (this.baseURI != null && writerConfig.get(BasicWriterSettings.BASE_DIRECTIVE).booleanValue()) {
                opts.setBase(this.baseURI);
            }
            if (mode == JSONLDMode.EXPAND) {
                output = JsonLdProcessor.expand(output, opts);
            }
            Object inframe = null;
            if (mode == JSONLDMode.FLATTEN) {
                output = JsonLdProcessor.flatten(output, inframe, opts);
            }
            if (mode == JSONLDMode.COMPACT) {
                LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
                JSONLDWriter.addPrefixes(ctx, this.model.getNamespaces());
                HashMap<String, LinkedHashMap<String, Object>> localCtx = new HashMap<String, LinkedHashMap<String, Object>>();
                localCtx.put("@context", ctx);
                output = JsonLdProcessor.compact(output, localCtx, opts);
            }
            if (writerConfig.get(BasicWriterSettings.PRETTY_PRINT).booleanValue()) {
                JsonUtils.writePrettyPrint(this.writer, output);
            } else {
                JsonUtils.write(this.writer, output);
            }
        }
        catch (JsonLdError | IOException e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
    }

    @Override
    public void consumeStatement(Statement st) throws RDFHandlerException {
        this.statementCollector.handleStatement(st);
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.checkWritingStarted();
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(BasicWriterSettings.PRETTY_PRINT);
        result.add(BasicWriterSettings.BASE_DIRECTIVE);
        result.add(JSONLDSettings.COMPACT_ARRAYS);
        result.add(JSONLDSettings.HIERARCHICAL_VIEW);
        result.add(JSONLDSettings.JSONLD_MODE);
        result.add(JSONLDSettings.PRODUCE_GENERALIZED_RDF);
        result.add(JSONLDSettings.USE_RDF_TYPE);
        result.add(JSONLDSettings.USE_NATIVE_TYPES);
        return result;
    }

    private static void addPrefixes(Map<String, Object> ctx, Set<Namespace> namespaces) {
        for (Namespace ns : namespaces) {
            ctx.put(ns.getPrefix().isEmpty() ? "@vocab" : ns.getPrefix(), ns.getName());
        }
    }
}

