/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.obolibrary.gui.GuiTools;
import org.obolibrary.gui.SelectDialog;

public class GuiAdvancedPanel
extends GuiTools.SizedJPanel {
    private static final long serialVersionUID = -1694788715411761694L;
    final Frame frame;
    final JTextArea downloadOntologies;
    final JTextArea omitDownloadOntologies;
    final JCheckBox downloadOntologiesCheckBox;
    final JCheckBox omitDownloadOntologiesCheckBox;
    final JTextField ontologyDownloadFolderField;

    public GuiAdvancedPanel(Frame frame, Collection<String> defaultDownloadOntologies, Collection<String> defaultOmitDownloadOntologies, String defaultBuildDir) {
        this.frame = frame;
        this.downloadOntologies = new JTextArea(0, 1);
        boolean downloadOntologiesCheckBoxIsActive = false;
        if (defaultDownloadOntologies != null && !defaultDownloadOntologies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String url : defaultDownloadOntologies) {
                sb.append(url);
                sb.append('\n');
            }
            this.downloadOntologies.setText(sb.toString());
            downloadOntologiesCheckBoxIsActive = true;
        }
        this.downloadOntologiesCheckBox = new JCheckBox("Download Ontologies", downloadOntologiesCheckBoxIsActive);
        this.omitDownloadOntologies = new JTextArea(0, 1);
        boolean omitDownloadOntologiesCheckBoxIsActive = false;
        if (defaultOmitDownloadOntologies != null && !defaultOmitDownloadOntologies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String url : defaultOmitDownloadOntologies) {
                sb.append(url);
                sb.append('\n');
            }
            this.omitDownloadOntologies.setText(sb.toString());
            omitDownloadOntologiesCheckBoxIsActive = true;
        }
        this.omitDownloadOntologiesCheckBox = new JCheckBox("Omit Download Ontologies", omitDownloadOntologiesCheckBoxIsActive);
        this.ontologyDownloadFolderField = GuiTools.createTextField(defaultBuildDir);
        this.setLayout(new GridBagLayout());
        GuiTools.GBHelper pos = new GuiTools.GBHelper();
        this.add((Component)new JLabel("ADVANCED"), pos);
        GuiTools.addRowGap(this, pos, 10);
        this.createOntologiesPanel(pos, this.downloadOntologies, this.downloadOntologiesCheckBox);
        GuiTools.addRowGap(this, pos, 5);
        this.createDownloadDirPanel(pos, defaultBuildDir);
        GuiTools.addRowGap(this, pos, 5);
        this.createOntologiesPanel(pos, this.omitDownloadOntologies, this.omitDownloadOntologiesCheckBox);
        GuiTools.addRowGap(this, pos, 5);
    }

    private void createDownloadDirPanel(GuiTools.GBHelper pos, String defaultFolder) {
        final SelectDialog dialog = SelectDialog.getFolderSelector(this.frame, defaultFolder, "Work directory choose dialog");
        JButton selectButton = new JButton("Select");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.show();
                String selected = dialog.getSelectedCanonicalPath();
                if (selected != null) {
                    GuiAdvancedPanel.this.ontologyDownloadFolderField.setText(selected);
                }
            }
        });
        this.add((Component)new JLabel("Download Directory"), pos.nextRow());
        this.add((Component)this.ontologyDownloadFolderField, pos.nextCol().expandW().fill());
        this.add((Component)selectButton, pos.nextCol().indentLeft(10));
    }

    private void createOntologiesPanel(GuiTools.GBHelper pos, final JTextArea ontologyList, final JCheckBox checkBox) {
        ontologyList.setEditable(checkBox.isSelected());
        ontologyList.setEnabled(checkBox.isSelected());
        JScrollPane scrollPane = new JScrollPane(ontologyList);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = checkBox.isSelected();
                ontologyList.setEditable(selected);
                ontologyList.setEnabled(selected);
            }
        });
        scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)checkBox, pos.nextRow());
        this.add((Component)scrollPane, pos.nextCol().expandW().expandH().anchorCenter().fill().height(3));
        pos.nextRow();
        pos.nextRow();
    }
}

