/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.rdf.rdfxml.parser.IRIProvider;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParserException;
import org.semanticweb.owlapi.rdf.rdfxml.parser.StartRDF;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SAXParsers;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class RDFParser
extends DefaultHandler
implements IRIProvider {
    private static final String WRONGRESOLVE = "IRI '%s' cannot be resolved against current base IRI %s reason is: %s";
    @Nonnull
    protected static final Locator nullDocumentLocator = new LocatorImpl();
    private final Map<String, String> resolvedIRIs = new HashMap<String, String>();
    protected final Map<String, IRI> uriCache = new HashMap<String, IRI>();
    protected ErrorHandler errorHandler = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) {
        }
    };
    protected final LinkedList<IRI> baseIRIs = new LinkedList();
    private final Map<IRI, URI> baseURICache = new HashMap<IRI, URI>();
    protected IRI baseIRI;
    @Nonnull
    protected final LinkedList<String> languages = new LinkedList();
    protected String language;
    protected RDFConsumer consumer;
    protected State state;
    protected final List<State> states = new ArrayList<State>();
    protected Locator documentLocator;

    @Nonnull
    protected IRI getBaseIRI() {
        return OWLAPIPreconditions.verifyNotNull(this.baseIRI, "base IRI has not been set yet");
    }

    @Nonnull
    protected Locator getDocumentLocator() {
        if (this.documentLocator != null) {
            return OWLAPIPreconditions.verifyNotNull(this.documentLocator);
        }
        return nullDocumentLocator;
    }

    public void parse(@Nonnull InputSource source, @Nonnull RDFConsumer inputConsumer) throws SAXException, IOException {
        InputSource s2 = OWLAPIPreconditions.checkNotNull(source, "source cannot be null");
        OWLAPIPreconditions.checkNotNull(inputConsumer, "consumer cannot be null");
        String systemID = s2.getSystemId();
        try {
            if (systemID == null) {
                throw new SAXException("Supplied InputSource object myst have systemId property set, which is needed for IRI resolution.");
            }
            this.baseIRI = IRI.create(new URI(source.getSystemId()));
            this.consumer = inputConsumer;
            inputConsumer.startModel(this.getBaseIRI());
            DeclHandler handler = new DeclHandler(){

                @Override
                public void internalEntityDecl(String name, String value) {
                    RDFParser.this.consumer.addPrefix(name, value);
                }

                @Override
                public void externalEntityDecl(String name, String publicId, String systemId) {
                }

                @Override
                public void elementDecl(String name, String model) {
                }

                @Override
                public void attributeDecl(String eName, String aName, String type, String mode, String value) {
                }
            };
            SAXParsers.initParserWithOWLAPIStandards(handler, inputConsumer.getConfiguration().getEntityExpansionLimit()).parse(source, (DefaultHandler)this);
            inputConsumer.endModel();
        }
        catch (URISyntaxException e) {
            throw new SAXException("Invalid SystemID '" + systemID + "'of the supplied input source.", e);
        }
        finally {
            this.state = null;
            this.states.clear();
            this.baseIRIs.clear();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.documentLocator = OWLAPIPreconditions.checkNotNull(locator, "locator cannot be null");
    }

    public void setErrorHandler(@Nonnull ErrorHandler errorHandler) {
        this.errorHandler = OWLAPIPreconditions.checkNotNull(errorHandler, "errorHandler cannot be null");
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.errorHandler.warning(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errorHandler.error(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.errorHandler.fatalError(e);
    }

    @Override
    public void startDocument() {
        this.states.clear();
        this.pushState(new StartRDF(this));
    }

    @Override
    public void endDocument() {
        this.verify(this.state != null, "RDF content not finished.");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.processXMLBase(attributes);
        this.processXMLLanguage(attributes);
        this.state.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.state.endElement(uri, localName, qName);
        this.baseIRI = this.baseIRIs.remove(0);
        this.language = this.languages.remove(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.state.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) {
        if ("include-rdf".equals(target)) {
            Map<String, String> arguments = this.parseStringArguments(data);
            this.verify(arguments.size() > 2, "Incorrect number of arguments for 'include-rdf' processing instruction.");
            String logicalIRI = arguments.get("logicalIRI");
            String physicalIRI = arguments.get("physicalIRI");
            if (physicalIRI != null) {
                physicalIRI = this.resolveIRI(physicalIRI);
            }
            this.consumer.includeModel(logicalIRI, physicalIRI);
        }
    }

    public void pushState(State s2) {
        this.states.add(s2);
        this.state = s2;
    }

    public void popState() {
        int size = this.states.size();
        this.verify(size == 0, "Internal exception: state stack is empty.");
        this.state = size == 1 ? null : this.states.get(size - 2);
        this.states.remove(size - 1);
    }

    @Nonnull
    private IRI resolveFromDelegate(@Nonnull IRI iri, @Nonnull String value) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        OWLAPIPreconditions.checkNotNull(value, "value cannot be null");
        if (NodeID.isAnonymousNodeIRI(value)) {
            return IRI.create(value, null);
        }
        if (!this.baseURICache.containsKey(this.getBaseIRI())) {
            this.baseURICache.put(this.getBaseIRI(), this.getBaseIRI().toURI());
        }
        URI delegateURI = this.baseURICache.get(this.getBaseIRI());
        assert (delegateURI != null);
        URI resolve = delegateURI.resolve(value.replace(" ", "%20"));
        assert (resolve != null);
        return IRI.create(resolve);
    }

    private void processXMLBase(@Nonnull Attributes atts) {
        OWLAPIPreconditions.checkNotNull(atts, "atts cannot be null");
        this.baseIRIs.add(0, this.getBaseIRI());
        String value = atts.getValue("http://www.w3.org/XML/1998/namespace", "base");
        if (value != null) {
            try {
                this.baseIRI = this.resolveFromDelegate(this.getBaseIRI(), value);
                this.resolvedIRIs.clear();
            }
            catch (IllegalArgumentException e) {
                throw new RDFParserException(e, String.format(WRONGRESOLVE, value, this.getBaseIRI(), e.getMessage()), this.getDocumentLocator());
            }
        }
    }

    private void processXMLLanguage(@Nonnull Attributes atts) {
        OWLAPIPreconditions.checkNotNull(atts, "atts cannot be null");
        this.languages.add(0, this.language);
        String value = atts.getValue("xml:lang");
        if (value != null) {
            this.language = value;
        }
    }

    @Nonnull
    public String resolveIRI(@Nonnull String iri) {
        OWLAPIPreconditions.checkNotNull(iri, "uri cannot be null");
        if (iri.isEmpty()) {
            String namespace = this.getBaseIRI().getNamespace();
            if (namespace.charAt(namespace.length() - 1) == '#') {
                return namespace.substring(0, namespace.length() - 1);
            }
            String base = this.getBaseIRI().toString();
            int hashIndex = base.indexOf(35);
            if (hashIndex != -1) {
                return base.substring(0, hashIndex);
            }
            return base;
        }
        try {
            String resolved = this.resolvedIRIs.get(iri);
            if (resolved != null) {
                return resolved;
            }
            IRI theIRI = this.resolveFromDelegate(this.getBaseIRI(), iri);
            String u = theIRI.toString();
            this.uriCache.put(u, theIRI);
            this.resolvedIRIs.put(iri, u);
            return u;
        }
        catch (IllegalArgumentException e) {
            throw new RDFParserException(e, String.format(WRONGRESOLVE, iri, this.getBaseIRI(), e.getMessage()), this.getDocumentLocator());
        }
    }

    public void statementWithResourceValue(@Nonnull String subject, @Nonnull String predicate, @Nonnull String object, @Nullable String reificationID) {
        String remappedSubject = this.consumer.remapOnlyIfRemapped(subject);
        this.consumer.statementWithResourceValue(remappedSubject, predicate, object);
        if (reificationID != null) {
            this.consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#statement");
            this.consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", remappedSubject);
            this.consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", predicate);
            this.consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", object);
        }
    }

    public void statementWithLiteralValue(@Nonnull String subject, @Nonnull String predicate, @Nonnull String object, @Nullable String dataType, @Nullable String reificationID) {
        this.consumer.statementWithLiteralValue(subject, predicate, object, this.language, dataType);
        if (reificationID != null) {
            this.consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#statement");
            this.consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", subject);
            this.consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", predicate);
            this.consumer.statementWithLiteralValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", object, this.language, dataType);
        }
    }

    private Map<String, String> parseStringArguments(String string) {
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(string));
            HashMap<String, String> result = new HashMap<String, String>();
            tokenizer.nextToken();
            while (tokenizer.ttype != -1) {
                this.verify(tokenizer.ttype != -3, "Invalid processing instruction argument.");
                String name = tokenizer.sval;
                this.verify(61 != tokenizer.nextToken(), "Expecting token '='");
                tokenizer.nextToken();
                this.verify(tokenizer.ttype != 34 && tokenizer.ttype != 39, "Invalid processing instruction argument.");
                String value = tokenizer.sval;
                result.put(name, value);
                tokenizer.nextToken();
            }
            return result;
        }
        catch (IOException e) {
            throw new RDFParserException(e, "I/O error", this.getDocumentLocator());
        }
    }

    @Override
    @Nonnull
    public IRI getIRI(@Nonnull String s2) {
        return this.uriCache.get(OWLAPIPreconditions.checkNotNull(s2, "s cannot be null"));
    }

    public void verify(boolean b, @Nonnull String message) {
        if (b) {
            throw new RDFParserException(message, this.getDocumentLocator());
        }
    }
}

