/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.LongContainer;
import com.carrotsearch.hppcrt.LongDeque;
import com.carrotsearch.hppcrt.LongIndexedContainer;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.lists.LongLinkedList;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.procedures.LongProcedure;
import com.carrotsearch.hppcrt.sorting.LongSort;
import com.carrotsearch.hppcrt.strategies.LongComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayDeque
extends AbstractLongCollection
implements LongDeque,
LongIndexedContainer,
Cloneable {
    public long[] buffer;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<LongCursor, DescendingValueIterator> descendingValueIteratorPool;
    protected final IteratorPool<LongCursor, ValueIterator> valueIteratorPool;

    public LongArrayDeque() {
        this(8);
    }

    public LongArrayDeque(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public LongArrayDeque(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = LongArrayDeque.this.head >= 1 ? LongArrayDeque.this.head - 1 : LongArrayDeque.this.buffer.length - 1;
                obj.remaining = LongArrayDeque.this.size();
            }

            @Override
            public void reset(ValueIterator obj) {
            }
        });
        this.descendingValueIteratorPool = new IteratorPool(new ObjectFactory<DescendingValueIterator>(){

            @Override
            public DescendingValueIterator create() {
                return new DescendingValueIterator();
            }

            @Override
            public void initialize(DescendingValueIterator obj) {
                obj.cursor.index = LongArrayDeque.this.tail;
                obj.remaining = LongArrayDeque.this.size();
            }

            @Override
            public void reset(DescendingValueIterator obj) {
            }
        });
    }

    public LongArrayDeque(LongContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(long e1) {
        int h2;
        int n = h2 = this.head >= 1 ? this.head - 1 : this.buffer.length - 1;
        if (h2 == this.tail) {
            this.ensureBufferSpace(1);
            h2 = this.head >= 1 ? this.head - 1 : this.buffer.length - 1;
        }
        this.head = h2;
        this.buffer[this.head] = e1;
    }

    public void addFirst(long ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addFirst(elements[i]);
        }
    }

    public int addFirst(LongContainer container) {
        return this.addFirst((Iterable<? extends LongCursor>)container);
    }

    public int addFirst(Iterable<? extends LongCursor> iterable) {
        int size = 0;
        for (LongCursor longCursor : iterable) {
            this.addFirst(longCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(long e1) {
        int t;
        int n = t = this.tail + 1 == this.buffer.length ? 0 : this.tail + 1;
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = this.tail + 1 == this.buffer.length ? 0 : this.tail + 1;
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public void addLast(long ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public int addLast(LongContainer container) {
        return this.addLast((Iterable<? extends LongCursor>)container);
    }

    public int addLast(Iterable<? extends LongCursor> iterable) {
        int size = 0;
        for (LongCursor longCursor : iterable) {
            this.addLast(longCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public long removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        long result = this.buffer[this.head];
        this.head = this.head + 1 == this.buffer.length ? 0 : this.head + 1;
        return result;
    }

    @Override
    public long removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = this.tail >= 1 ? this.tail - 1 : this.buffer.length - 1;
        long result = this.buffer[this.tail];
        return result;
    }

    @Override
    public long getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public long getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.tail >= 1 ? this.tail - 1 : this.buffer.length - 1];
    }

    @Override
    public int removeFirst(long e1) {
        int pos = -1;
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            pos = this.bufferIndexToPosition(index);
            this.removeBufferIndicesRange(index, index + 1 == this.buffer.length ? 0 : index + 1);
        }
        return pos;
    }

    public int bufferIndexOf(long e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        long[] buffer = this.buffer;
        int i = this.head;
        while (i != last) {
            if (e1 == buffer[i]) {
                return i;
            }
            i = i + 1 == bufLen ? 0 : i + 1;
        }
        return -1;
    }

    @Override
    public int removeLast(long e1) {
        int pos = -1;
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            pos = this.bufferIndexToPosition(index);
            this.removeBufferIndicesRange(index, index + 1 == this.buffer.length ? 0 : index + 1);
        }
        return pos;
    }

    public int lastBufferIndexOf(long e1) {
        int i;
        int bufLen = this.buffer.length;
        int last = this.head >= 1 ? this.head - 1 : bufLen - 1;
        long[] buffer = this.buffer;
        int n = i = this.tail >= 1 ? this.tail - 1 : bufLen - 1;
        while (i != last) {
            if (e1 == buffer[i]) {
                return i;
            }
            i = i >= 1 ? i - 1 : bufLen - 1;
        }
        return -1;
    }

    @Override
    public int indexOf(long e1) {
        return this.bufferIndexToPosition(this.bufferIndexOf(e1));
    }

    @Override
    public int lastIndexOf(long e1) {
        return this.bufferIndexToPosition(this.lastBufferIndexOf(e1));
    }

    @Override
    public int removeAll(long e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        long[] buffer = this.buffer;
        int from = to = this.head;
        while (from != last) {
            if (e1 == buffer[from]) {
                ++removed;
            } else {
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                to = to + 1 == bufLen ? 0 : to + 1;
            }
            from = from + 1 == bufLen ? 0 : from + 1;
        }
        this.tail = to;
        return removed;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public void clear() {
        this.tail = 0;
        this.head = 0;
    }

    private void compactBeforeSorting() {
        if (this.head > this.tail) {
            int size = this.size();
            System.arraycopy(this.buffer, this.head, this.buffer, this.tail, this.buffer.length - this.head);
            this.head = 0;
            this.tail = size;
        }
    }

    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = new long[8];
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int elementsCount;
        int bufferLen = this.buffer == null ? 0 : this.buffer.length;
        int n = elementsCount = this.buffer == null ? 0 : this.size();
        if (elementsCount + 1 > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions);
            if (this.buffer == null) {
                ++newSize;
            }
            try {
                long[] newBuffer = new long[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public long[] toArray(long[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public LongArrayDeque clone() {
        LongArrayDeque cloned = new LongArrayDeque(8, this.resizer);
        cloned.buffer = (long[])this.buffer.clone();
        cloned.head = this.head;
        cloned.tail = this.tail;
        return cloned;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    public DescendingValueIterator descendingIterator() {
        return (DescendingValueIterator)this.descendingValueIteratorPool.borrow();
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure) {
        this.internalForEach(procedure, this.head, this.tail);
        return procedure;
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return procedure;
        }
        int bufferPositionStart = this.indexToBufferPosition(fromIndex);
        int endBufferPosInclusive = this.indexToBufferPosition(toIndex - 1);
        this.internalForEach(procedure, bufferPositionStart, endBufferPosInclusive + 1 == this.buffer.length ? 0 : endBufferPosInclusive + 1);
        return procedure;
    }

    private void internalForEach(LongProcedure procedure, int fromIndexBuffer, int toIndexBuffer) {
        long[] buffer = this.buffer;
        int i = fromIndexBuffer;
        while (i != toIndexBuffer) {
            procedure.apply(buffer[i]);
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate) {
        this.internalForEach(predicate, this.head, this.tail);
        return predicate;
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return predicate;
        }
        int bufferPositionStart = this.indexToBufferPosition(fromIndex);
        int endBufferPosInclusive = this.indexToBufferPosition(toIndex - 1);
        this.internalForEach(predicate, bufferPositionStart, endBufferPosInclusive + 1 == this.buffer.length ? 0 : endBufferPosInclusive + 1);
        return predicate;
    }

    private void internalForEach(LongPredicate predicate, int fromIndexBuffer, int toIndexBuffer) {
        long[] buffer = this.buffer;
        int i = fromIndexBuffer;
        while (i != toIndexBuffer && predicate.apply(buffer[i])) {
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
    }

    @Override
    public <T extends LongProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(LongProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        long[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = i >= 1 ? i - 1 : buffer.length - 1;
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends LongPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(LongPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        long[] buffer = this.buffer;
        int i = toIndex;
        do {
            int n = i = i >= 1 ? i - 1 : buffer.length - 1;
        } while (predicate.apply(buffer[i]) && i != fromIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(LongPredicate predicate) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        long[] buffer = this.buffer;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(buffer[from])) {
                    ++removed;
                } else {
                    if (to != from) {
                        buffer[to] = buffer[from];
                    }
                    to = to + 1 == bufLen ? 0 : to + 1;
                }
                from = from + 1 == bufLen ? 0 : from + 1;
            }
        }
        catch (Throwable throwable) {
            while (from != last) {
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                to = to + 1 == bufLen ? 0 : to + 1;
                from = from + 1 == bufLen ? 0 : from + 1;
            }
            this.tail = to;
            throw throwable;
        }
        while (from != last) {
            if (to != from) {
                buffer[to] = buffer[from];
            }
            to = to + 1 == bufLen ? 0 : to + 1;
            from = from + 1 == bufLen ? 0 : from + 1;
        }
        this.tail = to;
        return removed;
    }

    @Override
    public boolean contains(long e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (e == buffer[i]) {
                return true;
            }
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h2 = 31 * h2 + BitMixer.mix(buffer[i]);
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LongLinkedList) {
                LongLinkedList other = (LongLinkedList)obj;
                if (other.size() != this.size()) {
                    return false;
                }
                ValueIterator it = this.iterator();
                LongLinkedList.ValueIterator itOther = other.iterator();
                while (it.hasNext()) {
                    long myVal = ((LongCursor)it.next()).value;
                    long otherVal = ((LongCursor)itOther.next()).value;
                    if (myVal == otherVal) continue;
                    it.release();
                    itOther.release();
                    return false;
                }
                itOther.release();
                return true;
            }
            if (obj instanceof LongIndexedContainer) {
                LongIndexedContainer other = (LongIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean allIndexesEqual(LongIndexedContainer b1, LongIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            long o2;
            long o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static LongArrayDeque newInstance() {
        return new LongArrayDeque();
    }

    public static LongArrayDeque newInstance(int initialCapacity) {
        return new LongArrayDeque(initialCapacity);
    }

    public static LongArrayDeque from(long ... elements) {
        LongArrayDeque coll = new LongArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    public static LongArrayDeque from(LongContainer container) {
        return new LongArrayDeque(container);
    }

    public void sort(int beginIndex, int endIndex) {
        this.checkRangeBounds(beginIndex, endIndex);
        if (beginIndex == endIndex) {
            return;
        }
        int bufferPosStart = this.indexToBufferPosition(beginIndex);
        int bufferPosEndInclusive = this.indexToBufferPosition(endIndex - 1);
        if (bufferPosEndInclusive > bufferPosStart) {
            LongSort.quicksort(this.buffer, bufferPosStart, bufferPosEndInclusive + 1);
        } else {
            LongSort.quicksort(this, beginIndex, endIndex);
        }
    }

    public void sort(int beginIndex, int endIndex, LongComparator comp) {
        this.checkRangeBounds(beginIndex, endIndex);
        if (beginIndex == endIndex) {
            return;
        }
        int bufferPosStart = this.indexToBufferPosition(beginIndex);
        int bufferPosEndInclusive = this.indexToBufferPosition(endIndex - 1);
        if (bufferPosEndInclusive > bufferPosStart) {
            LongSort.quicksort(this.buffer, bufferPosStart, bufferPosEndInclusive + 1, comp);
        } else {
            LongSort.quicksort(this, beginIndex, endIndex, comp);
        }
    }

    public void sort() {
        if (this.size() > 1) {
            this.compactBeforeSorting();
            LongSort.quicksort(this.buffer, this.head, this.tail);
        }
    }

    public void sort(LongComparator comp) {
        if (this.size() > 1) {
            this.compactBeforeSorting();
            LongSort.quicksort(this.buffer, this.head, this.tail, comp);
        }
    }

    @Override
    public void add(long e1) {
        this.addLast(e1);
    }

    @Override
    public void insert(int index, long e1) {
        throw new UnsupportedOperationException("insert(final int index, final KType e1) operation is not supported on KTypeArrayDeque");
    }

    @Override
    public long set(int index, long e1) {
        int indexInBuffer = this.indexToBufferPosition(index);
        long previous = this.buffer[indexInBuffer];
        this.buffer[indexInBuffer] = e1;
        return previous;
    }

    @Override
    public long get(int index) {
        return this.buffer[this.indexToBufferPosition(index)];
    }

    @Override
    public long remove(int index) {
        int indexInBuffer = this.indexToBufferPosition(index);
        long previous = this.buffer[indexInBuffer];
        this.removeBufferIndicesRange(indexInBuffer, indexInBuffer + 1 == this.buffer.length ? 0 : indexInBuffer + 1);
        return previous;
    }

    private void removeBufferIndicesRange(int fromBufferIndex, int toBufferIndex) {
        int to;
        int bufLen = this.buffer.length;
        long[] buffer = this.buffer;
        if (fromBufferIndex == toBufferIndex) {
            return;
        }
        long nbToBeRemoved = (long)toBufferIndex - (long)fromBufferIndex;
        if (nbToBeRemoved < 0L) {
            nbToBeRemoved += (long)bufLen;
        }
        int last = this.tail;
        long removed = 0L;
        int from = to = fromBufferIndex;
        while (from != last) {
            if (removed < nbToBeRemoved) {
                ++removed;
            } else {
                buffer[to] = buffer[from];
                to = to + 1 == bufLen ? 0 : to + 1;
            }
            from = from + 1 == bufLen ? 0 : from + 1;
        }
        this.tail = to;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int bufferPositionStart = this.indexToBufferPosition(fromIndex);
        int bufferPositionEndInclusive = this.indexToBufferPosition(toIndex - 1);
        this.removeBufferIndicesRange(bufferPositionStart, bufferPositionEndInclusive + 1 == this.buffer.length ? 0 : bufferPositionEndInclusive + 1);
    }

    private int bufferIndexToPosition(int bufferIndex) {
        int pos = -1;
        if (bufferIndex >= 0 && (pos = bufferIndex - this.head) < 0) {
            pos += this.buffer.length;
        }
        return pos;
    }

    private int indexToBufferPosition(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds [" + 0 + ", size=" + this.size() + "[.");
        }
        long bufferPos = (long)index + (long)this.head;
        if (bufferPos >= (long)this.buffer.length) {
            bufferPos -= (long)this.buffer.length;
        }
        return (int)bufferPos;
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.size() + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DescendingValueIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = LongArrayDeque.this.tail;
            this.remaining = LongArrayDeque.this.size();
        }

        @Override
        protected LongCursor fetch() {
            if (this.remaining == 0) {
                return (LongCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = this.cursor.index >= 1 ? this.cursor.index - 1 : LongArrayDeque.this.buffer.length - 1;
            this.cursor.value = LongArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = LongArrayDeque.this.head >= 1 ? LongArrayDeque.this.head - 1 : LongArrayDeque.this.buffer.length - 1;
            this.remaining = LongArrayDeque.this.size();
        }

        @Override
        protected LongCursor fetch() {
            if (this.remaining == 0) {
                return (LongCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = this.cursor.index + 1 == LongArrayDeque.this.buffer.length ? 0 : this.cursor.index + 1;
            this.cursor.value = LongArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

