/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractByteCollection;
import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.ByteArrays;
import com.carrotsearch.hppcrt.ByteContainer;
import com.carrotsearch.hppcrt.ByteFloatAssociativeContainer;
import com.carrotsearch.hppcrt.ByteFloatMap;
import com.carrotsearch.hppcrt.ByteLookupContainer;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.cursors.ByteFloatCursor;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.ByteFloatPredicate;
import com.carrotsearch.hppcrt.predicates.BytePredicate;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.procedures.ByteFloatProcedure;
import com.carrotsearch.hppcrt.procedures.ByteProcedure;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteFloatHashMap
implements ByteFloatMap,
Cloneable {
    protected float defaultValue = 0.0f;
    public byte[] keys;
    public float[] values;
    public boolean allocatedDefaultKey = false;
    public float allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ByteFloatCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ByteFloatHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public ByteFloatHashMap() {
        this(8);
    }

    public ByteFloatHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ByteFloatHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ByteFloatHashMap(ByteFloatAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public float put(byte key, float value) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                float oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(ByteFloatAssociativeContainer container) {
        return this.putAll((Iterable<? extends ByteFloatCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends ByteFloatCursor> iterable) {
        int count = this.size();
        for (ByteFloatCursor byteFloatCursor : iterable) {
            this.put(byteFloatCursor.key, byteFloatCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(byte key, float value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(byte key, float putValue, float incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public float addTo(byte key, float incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(byte pendingKey, float pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        byte[] oldKeys = this.keys;
        float[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        byte key = 0;
        float value = 0.0f;
        int slot = -1;
        byte[] keys = this.keys;
        float[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            byte[] keys = new byte[capacity];
            float[] values = new float[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public float remove(byte key) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                float value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        float[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            byte existing = keys[slot];
            float existingValue = values[slot];
            if (existing == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public int removeAll(ByteContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof ByteLookupContainer) {
            if (this.allocatedDefaultKey && other.contains((byte)0)) {
                this.allocatedDefaultKey = false;
            }
            byte[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                byte existing = keys[i];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (ByteCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(BytePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((byte)0)) {
            this.allocatedDefaultKey = false;
        }
        byte[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            byte existing = keys[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ByteFloatPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((byte)0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        byte[] keys = this.keys;
        float[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            byte existing = keys[i];
            if (existing != 0 && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public float get(byte key) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(byte key) {
        byte existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ByteArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        byte[] keys = this.keys;
        float[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            byte existing = keys[i];
            if (existing == 0) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ByteFloatHashMap other = (ByteFloatHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                ByteFloatCursor c = (ByteFloatCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                float otherValue = other.get(c.key);
                if (Float.floatToIntBits(c.value) == Float.floatToIntBits(otherValue)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ByteFloatProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply((byte)0, this.allocatedDefaultKeyValue);
        }
        byte[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte existing = keys[i];
            if (existing == 0) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ByteFloatPredicate> T forEach(T predicate) {
        byte existing;
        if (this.allocatedDefaultKey && !predicate.apply((byte)0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        byte[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public ByteFloatHashMap clone() {
        ByteFloatHashMap cloned = new ByteFloatHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ByteFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ByteFloatHashMap from(byte[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteFloatHashMap map = new ByteFloatHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static ByteFloatHashMap from(ByteFloatAssociativeContainer container) {
        return new ByteFloatHashMap(container);
    }

    public static ByteFloatHashMap newInstance() {
        return new ByteFloatHashMap();
    }

    public static ByteFloatHashMap newInstance(int initialCapacity, double loadFactor) {
        return new ByteFloatHashMap(initialCapacity, loadFactor);
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(float defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            if (this.cursor.index == ByteFloatHashMap.this.values.length + 1) {
                if (ByteFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ByteFloatHashMap.this.values.length;
                    this.cursor.value = ByteFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ByteFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteFloatHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteFloatHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractFloatCollection {
        private final ByteFloatHashMap owner;
        protected final IteratorPool<FloatCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ByteFloatHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = ByteFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(float value) {
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(value) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                return true;
            }
            byte[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0 || Float.floatToIntBits(value) != Float.floatToIntBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            byte[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            byte[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == 0 || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(float e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(e) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            byte[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && Float.floatToIntBits(e) == Float.floatToIntBits(values[slot])) {
                    ByteFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            byte[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && predicate.apply(values[slot])) {
                    ByteFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public float[] toArray(float[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            byte[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == 0) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<ByteCursor> {
        public final ByteCursor cursor = new ByteCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            if (this.cursor.index == ByteFloatHashMap.this.keys.length + 1) {
                if (ByteFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ByteFloatHashMap.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = ByteFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteFloatHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteFloatHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractByteCollection
    implements ByteLookupContainer {
        private final ByteFloatHashMap owner;
        protected final IteratorPool<ByteCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ByteFloatHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = ByteFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(byte e) {
            return ByteFloatHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply((byte)0);
            }
            byte[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte existing = keys[i];
                if (existing == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            byte existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply((byte)0)) {
                return predicate;
            }
            byte[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(byte e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public byte[] toArray(byte[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0;
            }
            byte[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                byte existing = keys[i];
                if (existing == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ByteFloatCursor> {
        public final ByteFloatCursor cursor = new ByteFloatCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteFloatCursor fetch() {
            int i;
            if (this.cursor.index == ByteFloatHashMap.this.keys.length + 1) {
                if (ByteFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ByteFloatHashMap.this.keys.length;
                    this.cursor.key = 0;
                    this.cursor.value = ByteFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ByteFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteFloatHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ByteFloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ByteFloatHashMap.this.keys[i];
            this.cursor.value = ByteFloatHashMap.this.values[i];
            return this.cursor;
        }
    }
}

