/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractCharCollection;
import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.CharArrays;
import com.carrotsearch.hppcrt.CharContainer;
import com.carrotsearch.hppcrt.CharFloatAssociativeContainer;
import com.carrotsearch.hppcrt.CharFloatMap;
import com.carrotsearch.hppcrt.CharLookupContainer;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.CharCursor;
import com.carrotsearch.hppcrt.cursors.CharFloatCursor;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.CharFloatPredicate;
import com.carrotsearch.hppcrt.predicates.CharPredicate;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.procedures.CharFloatProcedure;
import com.carrotsearch.hppcrt.procedures.CharProcedure;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharFloatHashMap
implements CharFloatMap,
Cloneable {
    protected float defaultValue = 0.0f;
    public char[] keys;
    public float[] values;
    public boolean allocatedDefaultKey = false;
    public float allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<CharFloatCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = CharFloatHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public CharFloatHashMap() {
        this(8);
    }

    public CharFloatHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public CharFloatHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public CharFloatHashMap(CharFloatAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public float put(char key, float value) {
        char existing;
        if (key == '\u0000') {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                float oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(CharFloatAssociativeContainer container) {
        return this.putAll((Iterable<? extends CharFloatCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends CharFloatCursor> iterable) {
        int count = this.size();
        for (CharFloatCursor charFloatCursor : iterable) {
            this.put(charFloatCursor.key, charFloatCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(char key, float value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(char key, float putValue, float incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public float addTo(char key, float incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(char pendingKey, float pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != '\u0000');
        char[] oldKeys = this.keys;
        float[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        char key = '\u0000';
        float value = 0.0f;
        int slot = -1;
        char[] keys = this.keys;
        float[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == '\u0000') continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            char[] keys = new char[capacity];
            float[] values = new float[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public float remove(char key) {
        char existing;
        if (key == '\u0000') {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                float value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        float[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            char existing = keys[slot];
            float existingValue = values[slot];
            if (existing == '\u0000') break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        --this.assigned;
    }

    @Override
    public int removeAll(CharContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof CharLookupContainer) {
            if (this.allocatedDefaultKey && other.contains('\u0000')) {
                this.allocatedDefaultKey = false;
            }
            char[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                char existing = keys[i];
                if (existing != '\u0000' && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (CharCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply('\u0000')) {
            this.allocatedDefaultKey = false;
        }
        char[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            char existing = keys[i];
            if (existing != '\u0000' && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(CharFloatPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply('\u0000', this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        char[] keys = this.keys;
        float[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            char existing = keys[i];
            if (existing != '\u0000' && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public float get(char key) {
        char existing;
        if (key == '\u0000') {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(char key) {
        char existing;
        if (key == '\u0000') {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        CharArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        char[] keys = this.keys;
        float[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            char existing = keys[i];
            if (existing == '\u0000') continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            CharFloatHashMap other = (CharFloatHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                CharFloatCursor c = (CharFloatCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                float otherValue = other.get(c.key);
                if (Float.floatToIntBits(c.value) == Float.floatToIntBits(otherValue)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends CharFloatProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply('\u0000', this.allocatedDefaultKeyValue);
        }
        char[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char existing = keys[i];
            if (existing == '\u0000') continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends CharFloatPredicate> T forEach(T predicate) {
        char existing;
        if (this.allocatedDefaultKey && !predicate.apply('\u0000', this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        char[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == '\u0000' || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public CharFloatHashMap clone() {
        CharFloatHashMap cloned = new CharFloatHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static CharFloatHashMap from(char[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharFloatHashMap map = new CharFloatHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static CharFloatHashMap from(CharFloatAssociativeContainer container) {
        return new CharFloatHashMap(container);
    }

    public static CharFloatHashMap newInstance() {
        return new CharFloatHashMap();
    }

    public static CharFloatHashMap newInstance(int initialCapacity, double loadFactor) {
        return new CharFloatHashMap(initialCapacity, loadFactor);
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(float defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            if (this.cursor.index == CharFloatHashMap.this.values.length + 1) {
                if (CharFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = CharFloatHashMap.this.values.length;
                    this.cursor.value = CharFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = CharFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && CharFloatHashMap.this.keys[i] == '\u0000'; --i) {
            }
            if (i == -1) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharFloatHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractFloatCollection {
        private final CharFloatHashMap owner;
        protected final IteratorPool<FloatCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = CharFloatHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = CharFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(float value) {
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(value) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                return true;
            }
            char[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == '\u0000' || Float.floatToIntBits(value) != Float.floatToIntBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            char[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == '\u0000') continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            char[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == '\u0000' || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(float e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(e) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            char[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != '\u0000' && Float.floatToIntBits(e) == Float.floatToIntBits(values[slot])) {
                    CharFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            char[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != '\u0000' && predicate.apply(values[slot])) {
                    CharFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public float[] toArray(float[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            char[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == '\u0000') continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<CharCursor> {
        public final CharCursor cursor = new CharCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            if (this.cursor.index == CharFloatHashMap.this.keys.length + 1) {
                if (CharFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = CharFloatHashMap.this.keys.length;
                    this.cursor.value = '\u0000';
                    return this.cursor;
                }
                this.cursor.index = CharFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && CharFloatHashMap.this.keys[i] == '\u0000'; --i) {
            }
            if (i == -1) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharFloatHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharFloatHashMap owner;
        protected final IteratorPool<CharCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = CharFloatHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = CharFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(char e) {
            return CharFloatHashMap.this.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply('\u0000');
            }
            char[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                char existing = keys[i];
                if (existing == '\u0000') continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            char existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply('\u0000')) {
                return predicate;
            }
            char[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == '\u0000' || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(char e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public char[] toArray(char[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = '\u0000';
            }
            char[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                char existing = keys[i];
                if (existing == '\u0000') continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<CharFloatCursor> {
        public final CharFloatCursor cursor = new CharFloatCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected CharFloatCursor fetch() {
            int i;
            if (this.cursor.index == CharFloatHashMap.this.keys.length + 1) {
                if (CharFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = CharFloatHashMap.this.keys.length;
                    this.cursor.key = '\u0000';
                    this.cursor.value = CharFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = CharFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && CharFloatHashMap.this.keys[i] == '\u0000'; --i) {
            }
            if (i == -1) {
                return (CharFloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = CharFloatHashMap.this.keys[i];
            this.cursor.value = CharFloatHashMap.this.values[i];
            return this.cursor;
        }
    }
}

