/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.obolibrary.gui.GuiTools;

public class GuiAdvancedDirectionSpecificPanel
extends GuiTools.SizedJPanel {
    private static final long serialVersionUID = -6706259947812407420L;
    final JCheckBox danglingCheckbox;
    final JCheckBox followImportsCheckBox;
    final JCheckBox expandMacrosCheckbox;
    final JTextField defaultOntologyField;
    final JCheckBox strictCheckBox;
    final JRadioButton formatRDFButton;
    final JRadioButton formatOWLXMLButton;
    final JRadioButton formatManchesterButton;
    private final List<JComponent> obo2owlComponents = new ArrayList<JComponent>();
    private final List<JComponent> owl2oboComponents = new ArrayList<JComponent>();

    public GuiAdvancedDirectionSpecificPanel(boolean allowDanglingDefault, boolean expandMacrosDefault, boolean followImports, String defaultOntologyConfigValue, boolean isObo2Owl, boolean strictConversion) {
        this.danglingCheckbox = new JCheckBox("Allow Dangling", allowDanglingDefault);
        this.followImportsCheckBox = new JCheckBox("Follow Imports", followImports);
        this.expandMacrosCheckbox = new JCheckBox("Expand OWL Macros", expandMacrosDefault);
        this.defaultOntologyField = GuiTools.createTextField(defaultOntologyConfigValue);
        this.formatRDFButton = new JRadioButton("RDF/XML", true);
        this.formatOWLXMLButton = new JRadioButton("OWL/XML");
        this.formatManchesterButton = new JRadioButton("Manchester");
        this.strictCheckBox = new JCheckBox("Strict Conversion", strictConversion);
        this.setLayout(new GridBagLayout());
        GuiTools.GBHelper pos = new GuiTools.GBHelper();
        this.add((Component)new JLabel("OBO2OWL"), pos);
        GuiTools.addRowGap(this, pos, 10);
        this.createOntologyFormatPanel(pos);
        GuiTools.addRowGap(this, pos, 5);
        this.createDanglingPanel(pos);
        GuiTools.addRowGap(this, pos, 5);
        this.createFollowImportsPanel(pos);
        GuiTools.addRowGap(this, pos, 10);
        this.createExpandMacros(pos);
        GuiTools.addRowGap(this, pos, 20);
        this.createDefaultOntologyPanel(pos);
        GuiTools.addRowGap(this, pos, 10);
        JSeparator separator = new JSeparator(0);
        separator.setSize(new Dimension(-1, 1));
        this.add((Component)separator, pos.nextRow().width(2).fill().expandW());
        GuiTools.addRowGap(this, pos, 10);
        this.add((Component)new JLabel("OWL2OBO"), pos.nextRow());
        this.createStrictPanel(pos);
        GuiTools.addRowGap(this, pos, 5);
        this.setObo2Owl(isObo2Owl);
    }

    private void createOntologyFormatPanel(GuiTools.GBHelper pos) {
        JLabel label = new JLabel("OWL Format");
        this.obo2owlComponents.add(label);
        this.add((Component)label, pos.nextRow().nextCol());
        ButtonGroup formatGroup = new ButtonGroup();
        formatGroup.add(this.formatRDFButton);
        formatGroup.add(this.formatOWLXMLButton);
        formatGroup.add(this.formatManchesterButton);
        JPanel formatPanel = new JPanel(new GridLayout(1, 0));
        formatPanel.add(this.formatRDFButton);
        formatPanel.add(this.formatOWLXMLButton);
        formatPanel.add(this.formatManchesterButton);
        this.obo2owlComponents.add(this.formatRDFButton);
        this.obo2owlComponents.add(this.formatOWLXMLButton);
        this.obo2owlComponents.add(this.formatManchesterButton);
        this.add((Component)formatPanel, pos.nextRow().nextCol());
    }

    private void createDanglingPanel(GuiTools.GBHelper pos) {
        this.obo2owlComponents.add(this.danglingCheckbox);
        this.add((Component)this.danglingCheckbox, pos.nextRow().nextCol());
    }

    private void createFollowImportsPanel(GuiTools.GBHelper pos) {
        this.obo2owlComponents.add(this.followImportsCheckBox);
        this.add((Component)this.followImportsCheckBox, pos.nextRow().nextCol());
    }

    private void createExpandMacros(GuiTools.GBHelper pos) {
        this.obo2owlComponents.add(this.expandMacrosCheckbox);
        this.add((Component)this.expandMacrosCheckbox, pos.nextRow().nextCol());
    }

    private void createDefaultOntologyPanel(GuiTools.GBHelper pos) {
        JLabel label = new JLabel("DefaultOntology");
        this.obo2owlComponents.add(label);
        this.add((Component)label, pos.nextRow().nextCol());
        this.obo2owlComponents.add(this.defaultOntologyField);
        this.add((Component)this.defaultOntologyField, pos.nextRow().nextCol().expandW().fill());
    }

    private void createStrictPanel(GuiTools.GBHelper pos) {
        this.owl2oboComponents.add(this.strictCheckBox);
        this.add((Component)this.strictCheckBox, pos.nextRow().nextCol().expandH());
    }

    void setObo2Owl(boolean isObo2Owl) {
        for (JComponent component : this.obo2owlComponents) {
            component.setEnabled(isObo2Owl);
        }
        for (JComponent component : this.owl2oboComponents) {
            component.setEnabled(!isObo2Owl);
        }
    }
}

