/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.obolibrary.cli.OBORunnerConfiguration;
import org.obolibrary.gui.GuiAdvancedDirectionSpecificPanel;
import org.obolibrary.gui.GuiAdvancedPanel;
import org.obolibrary.gui.GuiLogPanel;
import org.obolibrary.gui.GuiMainPanel;
import org.obolibrary.gui.GuiTools;

public class GuiMainFrame
extends JFrame {
    private static final long serialVersionUID = 8368019495775583185L;
    private JPanel allPanel;
    private GuiMainPanel mainPanel;
    private GuiAdvancedPanel advancedPanel;
    private GuiAdvancedDirectionSpecificPanel specificAdvancedPanel;
    private GuiLogPanel logPanel;
    private final BlockingQueue<String> logQueue;
    private final OBORunnerConfiguration config;
    private JTabbedPane tabbedPane;
    private JButton runButton;

    public GuiMainFrame() {
        this(new ArrayBlockingQueue<String>(100), new OBORunnerConfiguration());
    }

    public GuiMainFrame(BlockingQueue<String> logQueue, OBORunnerConfiguration config) {
        this.logQueue = logQueue;
        this.config = config;
        this.initialize();
    }

    private void initialize() {
        this.setSize(800, 500);
        this.setContentPane(new JScrollPane(this.getAllPanel()));
        this.setTitle("OBOFormatConverter");
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private JPanel getAllPanel() {
        if (this.allPanel == null) {
            this.allPanel = new JPanel(new BorderLayout(10, 10));
            JTabbedPane tabbedPane = this.getTabbedPane();
            this.allPanel.add((Component)tabbedPane, "Center");
            JPanel controlPanel = this.createControlPanel();
            this.allPanel.add((Component)controlPanel, "Last");
        }
        return this.allPanel;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.addTab(this.tabbedPane, "Input/Output", this.getMainPanel());
            this.addTab(this.tabbedPane, "Advanced", this.getSpecificAdvancedPanel());
            this.addTab(this.tabbedPane, "Download Ontologies", this.getAdvancedPanel());
            this.addTab(this.tabbedPane, "Logs", this.getLogPanel());
        }
        return this.tabbedPane;
    }

    private void addTab(JTabbedPane tabbedPane, String title, GuiTools.SizedJPanel panel) {
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        tabbedPane.addTab(title, panel);
    }

    private JPanel createControlPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
        this.runButton = new JButton("Run Conversion");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GuiMainFrame.this.updateConfigurationFromGUI(GuiMainFrame.this.config)) {
                    GuiMainFrame.this.tabbedPane.setSelectedComponent(GuiMainFrame.this.logPanel);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GuiMainFrame.this.executeConversion(GuiMainFrame.this.config);
                        }
                    });
                }
            }
        });
        panel.add((Component)this.runButton, "After");
        return panel;
    }

    private boolean updateConfigurationFromGUI(OBORunnerConfiguration config) {
        List<String> strings;
        String inputFile = this.mainPanel.inputFileTextField.getText();
        config.paths.setValue(inputFile);
        config.outFile.setValue(this.mainPanel.outputFileTextField.getText());
        if (config.outFile.isEmpty() && config.outputdir.isEmpty()) {
            this.renderInputError("Configuration error. Please specify at least one fo the following in the main panel: Output Folder OR Output File");
            return false;
        }
        config.isOboToOwl.setRealValue(this.mainPanel.obo2owlButton.isSelected());
        config.defaultOnt.setValue(this.specificAdvancedPanel.defaultOntologyField.getText());
        if (this.specificAdvancedPanel.formatOWLXMLButton.isSelected()) {
            config.format.setValue("owlxml");
        } else if (this.specificAdvancedPanel.formatManchesterButton.isSelected()) {
            config.format.setValue("manchester");
        } else {
            config.format.setValue("RDF");
        }
        config.allowDangling.setRealValue(this.specificAdvancedPanel.danglingCheckbox.isSelected());
        config.followImports.setRealValue(this.specificAdvancedPanel.followImportsCheckBox.isSelected());
        config.strictConversion.setRealValue(this.specificAdvancedPanel.strictCheckBox.isSelected());
        config.isExpandMacros.setRealValue(this.specificAdvancedPanel.expandMacrosCheckbox.isSelected());
        if (this.advancedPanel.downloadOntologiesCheckBox.isSelected()) {
            strings = GuiTools.getStrings(this.advancedPanel.downloadOntologies);
            for (String string : strings) {
                config.ontsToDownload.setValue(string);
            }
            String buildDir = this.advancedPanel.ontologyDownloadFolderField.getText();
            if (strings.size() > 0 && (buildDir == null || buildDir.length() <= 0)) {
                this.renderInputError("Configuration error. Please specify also a download directory.");
                return false;
            }
            config.buildDir.setValue(buildDir);
        }
        if (this.advancedPanel.omitDownloadOntologiesCheckBox.isSelected()) {
            strings = GuiTools.getStrings(this.advancedPanel.omitDownloadOntologies);
            for (String string : strings) {
                config.omitOntsToDownload.setValue(string);
            }
        }
        return true;
    }

    private void renderInputError(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    protected void executeConversion(OBORunnerConfiguration config) {
        Iterable<OBORunnerConfiguration.Variable<?>> variables = config.getVariables();
        StringBuilder sb = new StringBuilder("-------------------------\n");
        for (OBORunnerConfiguration.Variable<?> variable : variables) {
            sb.append(variable.getName());
            sb.append(":   ");
            sb.append(variable.getValue());
            sb.append('\n');
        }
        this.logQueue.add(sb.toString());
    }

    private GuiTools.SizedJPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new GuiMainPanel(this, (Iterable<String>)this.config.paths.getValue(), this.config.outFile.getValue(), this.config.isOboToOwl.getValue());
        }
        return this.mainPanel;
    }

    private GuiAdvancedPanel getAdvancedPanel() {
        if (this.advancedPanel == null) {
            this.advancedPanel = new GuiAdvancedPanel(this, (Collection<String>)this.config.ontsToDownload.getValue(), (Collection<String>)this.config.omitOntsToDownload.getValue(), this.config.buildDir.getValue());
        }
        return this.advancedPanel;
    }

    synchronized GuiAdvancedDirectionSpecificPanel getSpecificAdvancedPanel() {
        if (this.specificAdvancedPanel == null) {
            this.specificAdvancedPanel = new GuiAdvancedDirectionSpecificPanel(this.config.allowDangling.getValue(), this.config.isExpandMacros.getValue(), this.config.followImports.getValue(), this.config.defaultOnt.getValue(), this.config.isOboToOwl.getValue(), this.config.strictConversion.getValue());
        }
        return this.specificAdvancedPanel;
    }

    private GuiTools.SizedJPanel getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new GuiLogPanel(this.logQueue);
        }
        return this.logPanel;
    }

    protected void disableRunButton() {
        this.runButton.setEnabled(false);
    }

    protected void enableRunButton() {
        this.runButton.setEnabled(true);
    }
}

