/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZOutputStream;

public class XZFileDocumentTarget
implements OWLOntologyDocumentTarget,
AutoCloseable {
    @Nonnull
    private final File out;
    private final FilterOptions[] filterOptions;
    private OutputStream outputStream;

    public XZFileDocumentTarget(@Nonnull File os, FilterOptions ... filterOptions) {
        this.out = os;
        this.filterOptions = filterOptions;
    }

    public XZFileDocumentTarget(@Nonnull File os, int presetLevel) throws UnsupportedOptionsException {
        this(os, new LZMA2Options(presetLevel));
    }

    public XZFileDocumentTarget(@Nonnull File file) {
        this(file, new LZMA2Options());
    }

    @Override
    public boolean isWriterAvailable() {
        return this.isOutputStreamAvailable();
    }

    @Override
    @Nonnull
    public Writer getWriter() {
        if (!this.isWriterAvailable()) {
            throw new UnsupportedOperationException("writer not available; check with isWriterAvailable() first.");
        }
        return new OutputStreamWriter(this.getOutputStream());
    }

    @Override
    public boolean isOutputStreamAvailable() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.out));
                this.outputStream = new XZOutputStream((OutputStream)bufferedOutputStream, this.filterOptions);
            }
            catch (IOException e) {
                throw new OWLRuntimeException(e);
            }
        }
        return OWLAPIPreconditions.verifyNotNull(this.outputStream);
    }

    @Override
    public boolean isDocumentIRIAvailable() {
        return true;
    }

    @Override
    public IRI getDocumentIRI() {
        return IRI.create(this.out);
    }

    @Override
    public void close() throws Exception {
        OutputStream output = this.outputStream;
        this.outputStream = null;
        if (output != null) {
            output.close();
        }
    }
}

