/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.google.common.base.Optional;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLOntologyID
implements Comparable<OWLOntologyID>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLOntologyID.class);
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private static final AtomicInteger COUNTER = new AtomicInteger();
    @Nonnull
    private static final String ANON_PREFIX = "Anonymous-";
    @Nonnull
    private Optional<String> internalID = Optional.absent();
    @Nonnull
    private final Optional<IRI> ontologyIRI;
    @Nonnull
    private final Optional<IRI> versionIRI;
    private int hashCode;

    @Deprecated
    public OWLOntologyID(IRI iri) {
        this(OWLOntologyID.opt(iri), Optional.absent());
    }

    @Deprecated
    public OWLOntologyID(IRI iri, IRI versionIRI) {
        this(OWLOntologyID.opt(iri), OWLOntologyID.opt(versionIRI));
    }

    @Nonnull
    private static Optional<IRI> opt(@Nullable IRI i) {
        if (NodeID.isAnonymousNodeIRI(i) || i == null) {
            return Optional.absent();
        }
        if (!i.isAbsolute()) {
            LOGGER.error("Ontology IRIs must be absolute; IRI {} is relative and will be made absolute by prefixing urn:absolute: to it", (Object)i);
            return Optional.fromNullable(IRI.create("urn:absolute:" + i));
        }
        return Optional.fromNullable(i);
    }

    @Nonnull
    private static Optional<IRI> opt(Optional<IRI> i) {
        if (i.isPresent()) {
            return OWLOntologyID.opt(i.get());
        }
        return Optional.absent();
    }

    @Nonnull
    private static <T> Optional<T> opt(T i) {
        return Optional.fromNullable(i);
    }

    public OWLOntologyID(@Nonnull Optional<IRI> iri, @Nonnull Optional<IRI> version) {
        this.ontologyIRI = OWLOntologyID.opt(iri);
        this.hashCode = 17;
        if (this.ontologyIRI.isPresent()) {
            this.hashCode += 37 * this.ontologyIRI.hashCode();
        } else {
            this.internalID = OWLOntologyID.opt(ANON_PREFIX + COUNTER.getAndIncrement());
            this.hashCode += 37 * this.internalID.hashCode();
        }
        this.versionIRI = OWLOntologyID.opt(version);
        if (this.versionIRI.isPresent()) {
            if (!this.ontologyIRI.isPresent()) {
                throw new IllegalArgumentException("If the ontology IRI is null then it is not possible to specify a version IRI");
            }
            this.hashCode += 37 * this.versionIRI.hashCode();
        }
    }

    public OWLOntologyID() {
        this(Optional.absent(), Optional.absent());
    }

    public boolean isOWL2DLOntologyID() {
        return !this.ontologyIRI.isPresent() || !this.ontologyIRI.get().isReservedVocabulary() && (!this.versionIRI.isPresent() || !this.versionIRI.get().isReservedVocabulary());
    }

    @Override
    public int compareTo(OWLOntologyID o) {
        return this.toString().compareTo(o.toString());
    }

    @Nonnull
    public Optional<IRI> getOntologyIRI() {
        return this.ontologyIRI;
    }

    @Nonnull
    public Optional<IRI> getVersionIRI() {
        return this.versionIRI;
    }

    @Nonnull
    public Optional<IRI> getDefaultDocumentIRI() {
        if (this.ontologyIRI.isPresent()) {
            if (this.versionIRI.isPresent()) {
                return this.versionIRI;
            }
            return this.ontologyIRI;
        }
        return Optional.absent();
    }

    public boolean isAnonymous() {
        return !this.ontologyIRI.isPresent();
    }

    @Nonnull
    public String toString() {
        if (this.ontologyIRI.isPresent()) {
            String template = "OntologyID(OntologyIRI(<%s>) VersionIRI(<%s>))";
            return String.format(template, this.ontologyIRI.get(), this.versionIRI.orNull());
        }
        return "OntologyID(" + this.internalID.orNull() + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntologyID)) {
            return false;
        }
        OWLOntologyID other = (OWLOntologyID)obj;
        if (this.isAnonymous() && other.isAnonymous()) {
            return this.internalID.equals(other.internalID);
        }
        if (this.isAnonymous() != other.isAnonymous()) {
            return false;
        }
        if (!this.isAnonymous()) {
            boolean toReturn = this.ontologyIRI.equals(other.ontologyIRI);
            if (!toReturn) {
                return toReturn;
            }
            toReturn = this.versionIRI.equals(other.versionIRI);
            return toReturn;
        }
        return false;
    }
}

