/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatImpl;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.rdf.model.RDFGraph;
import org.semanticweb.owlapi.util.AxiomAppearance;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.IndividualAppearance;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectDesharer;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTranslator<N extends Serializable, R extends N, P extends N, L extends N>
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTranslator.class);
    private final OWLOntologyManager manager;
    protected final OWLOntology ont;
    protected final OWLDocumentFormat format;
    private final boolean useStrongTyping;
    protected final IndividualAppearance multipleOccurrences;
    protected final AxiomAppearance axiomOccurrences;
    protected RDFGraph graph = new RDFGraph();
    private final AtomicInteger nextBlankNodeId;
    private final Map<Object, Integer> blankNodeMap;
    @Nonnull
    private final Map<OWLObject, N> nodeMap = new ConcurrentHashMap<OWLObject, N>(16, 0.75f, 1);
    private final Map<OWLObject, N> expressionMap = new IdentityHashMap<OWLObject, N>();
    private final Map<OWLObject, OWLObject[]> expressionContext = new ConcurrentHashMap<OWLObject, OWLObject[]>(16, 0.75f, 1);
    private final OWLObjectDesharer desharer;
    private final Set<OWLAxiom> translatedAxioms;
    @Nonnull
    private final Set<OWLIndividual> currentIndividuals = new HashSet<OWLIndividual>();

    public AbstractTranslator(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntology ontology, @Nullable OWLDocumentFormat format, boolean useStrongTyping, IndividualAppearance multiple, AxiomAppearance appearance, AtomicInteger nextNode, Map<Object, Integer> blankNodeMap, Set<OWLAxiom> translatedAxioms) {
        this.ont = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        this.manager = OWLAPIPreconditions.checkNotNull(manager, "manager cannot be null");
        this.useStrongTyping = useStrongTyping;
        this.multipleOccurrences = multiple;
        this.axiomOccurrences = appearance;
        this.nextBlankNodeId = nextNode;
        this.blankNodeMap = blankNodeMap;
        this.format = format;
        this.desharer = new OWLObjectDesharer(manager);
        this.translatedAxioms = translatedAxioms;
    }

    public void translate(OWLObject input) {
        if (input instanceof OWLAxiom) {
            if (this.translatedAxioms.add((OWLAxiom)input)) {
                input.accept(this);
            } else {
                LOGGER.debug("Axiom {} is being rendered twice, second pass skipped.", (Object)input);
            }
        } else {
            input.accept(this);
        }
    }

    @Nonnull
    protected RDFResourceBlankNode getBlankNodeFor(Object key, boolean isIndividual, boolean needId, boolean isAxiom) {
        Integer id = this.blankNodeMap.get(key);
        if (id == null) {
            id = this.nextBlankNodeId.getAndIncrement();
            this.blankNodeMap.put(key, id);
        }
        return new RDFResourceBlankNode(id, isIndividual, needId, isAxiom);
    }

    @Override
    public void visit(@Nonnull OWLDeclarationAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getIRI(), axiom.getEntity().accept(OWLEntityTypeProvider.INSTANCE));
    }

    @Override
    public void visit(@Nonnull OWLObjectInverseOf property) {
        this.translateAnonymousNode(property);
        this.addTriple((OWLObject)property, OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), (OWLObject)property.getInverse());
    }

    @Override
    public void visit(@Nonnull OWLDataIntersectionOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples(node, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), node.getOperands());
    }

    @Override
    public void visit(@Nonnull OWLDataUnionOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples(node, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), node.getOperands());
    }

    @Override
    public void visit(@Nonnull OWLDataComplementOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF.getIRI(), (OWLObject)node.getDataRange());
    }

    @Override
    public void visit(@Nonnull OWLDataOneOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples(node, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), node.getValues());
    }

    @Override
    public void visit(@Nonnull OWLDatatypeRestriction node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_ON_DATA_TYPE.getIRI(), (OWLObject)node.getDatatype());
        this.addListTriples(node, OWLRDFVocabulary.OWL_WITH_RESTRICTIONS.getIRI(), node.getFacetRestrictions());
    }

    @Override
    public void visit(@Nonnull OWLObjectIntersectionOf ce) {
        this.translateAnonymousNode(ce);
        this.addListTriples(ce, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), ce.getOperands());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLObjectUnionOf ce) {
        this.translateAnonymousNode(ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples(ce, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), ce.getOperands());
    }

    @Override
    public void visit(@Nonnull OWLObjectComplementOf ce) {
        this.translateAnonymousNode(ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI(), (OWLObject)ce.getOperand());
    }

    @Override
    public void visit(@Nonnull OWLObjectOneOf ce) {
        this.translateAnonymousNode(ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples(ce, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), ce.getIndividuals());
        this.processIfAnonymous(ce.getIndividuals(), null);
    }

    private void addRestrictionCommonTriplePropertyRange(@Nonnull OWLRestriction desc, @Nonnull OWLPropertyExpression property) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)property);
    }

    private void addRestrictionCommonTriplePropertyExpression(@Nonnull OWLRestriction desc, @Nonnull OWLPropertyExpression property) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)property);
    }

    private void addObjectCardinalityRestrictionTriples(@Nonnull OWLCardinalityRestriction<OWLClassExpression> ce, @Nonnull OWLPropertyExpression p, @Nonnull OWLRDFVocabulary cardiPredicate) {
        this.addRestrictionCommonTriplePropertyRange(ce, p);
        this.addTriple((OWLObject)ce, cardiPredicate.getIRI(), (OWLObject)this.toTypedConstant(ce.getCardinality()));
        if (ce.isQualified()) {
            if (ce.isObjectRestriction()) {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), ce.getFiller());
            } else {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), ce.getFiller());
            }
        }
    }

    private void addDataCardinalityRestrictionTriples(@Nonnull OWLCardinalityRestriction<OWLDataRange> ce, @Nonnull OWLPropertyExpression p, @Nonnull OWLRDFVocabulary cardiPredicate) {
        this.addRestrictionCommonTriplePropertyRange(ce, p);
        this.addTriple((OWLObject)ce, cardiPredicate.getIRI(), (OWLObject)this.toTypedConstant(ce.getCardinality()));
        if (ce.isQualified()) {
            if (ce.isObjectRestriction()) {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), ce.getFiller());
            } else {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), ce.getFiller());
            }
        }
    }

    @Override
    public void visit(@Nonnull OWLObjectSomeValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), ce.getFiller());
    }

    @Override
    public void visit(@Nonnull OWLObjectAllValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), ce.getFiller());
    }

    @Override
    public void visit(@Nonnull OWLObjectHasValue ce) {
        this.addRestrictionCommonTriplePropertyExpression(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), (OWLObject)ce.getFiller());
        this.processIfAnonymous((OWLIndividual)ce.getFiller());
    }

    @Override
    public void visit(@Nonnull OWLObjectHasSelf ce) {
        this.translateAnonymousNode(ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_HAS_SELF.getIRI(), (OWLObject)this.manager.getOWLDataFactory().getOWLLiteral(true));
    }

    @Override
    public void visit(@Nonnull OWLObjectMinCardinality ce) {
        if (ce.isQualified()) {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    @Override
    public void visit(@Nonnull OWLObjectMaxCardinality ce) {
        if (ce.isQualified()) {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    @Override
    public void visit(@Nonnull OWLObjectExactCardinality ce) {
        if (ce.isQualified()) {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    @Override
    public void visit(@Nonnull OWLDataSomeValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), ce.getFiller());
    }

    @Override
    public void visit(@Nonnull OWLDataAllValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), ce.getFiller());
    }

    @Override
    public void visit(@Nonnull OWLDataHasValue ce) {
        this.addRestrictionCommonTriplePropertyExpression(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(@Nonnull OWLDataMinCardinality ce) {
        if (ce.isQualified()) {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    @Override
    public void visit(@Nonnull OWLDataMaxCardinality ce) {
        if (ce.isQualified()) {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    @Override
    public void visit(@Nonnull OWLDataExactCardinality ce) {
        if (ce.isQualified()) {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    @Override
    public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubClass(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI(), (OWLObject)axiom.getSuperClass());
    }

    @Override
    public void visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2) {
            this.addPairwise(axiom, axiom.getClassExpressions(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
        } else {
            for (OWLEquivalentClassesAxiom ax : AbstractTranslator.sort(axiom.splitToAnnotatedPairs())) {
                ax.accept(this);
            }
            this.processIfNotAnonymous(axiom.getClassExpressionsAsList().stream().filter(IsAnonymous::isNamed).map(OWLClassExpression::asOWLClass));
        }
    }

    @Override
    public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2) {
            this.addPairwiseClassExpressions(axiom, axiom.getClassExpressions(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getClassExpressions());
            this.translateAnnotations(axiom);
        }
    }

    @Override
    public void visit(@Nonnull OWLDisjointUnionAxiom axiom) {
        Set<OWLClassExpression> classExpressions = axiom.getClassExpressions();
        ArrayList<OWLClassExpression> list = new ArrayList<OWLClassExpression>(classExpressions);
        Collections.sort(list);
        this.addSingleTripleAxiom((OWLAxiom)axiom, (R)axiom.getOWLClass(), (P)OWLRDFVocabulary.OWL_DISJOINT_UNION_OF.getIRI(), (N)list);
    }

    @Override
    public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(@Nonnull OWLSubPropertyChainOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (R)axiom.getSuperProperty(), (P)OWLRDFVocabulary.OWL_PROPERTY_CHAIN_AXIOM.getIRI(), (N)axiom.getPropertyChain());
    }

    @Override
    public void visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        } else {
            for (OWLEquivalentObjectPropertiesAxiom ax : AbstractTranslator.sort(axiom.splitToAnnotatedPairs())) {
                ax.accept(this);
            }
            this.processIfNotAnonymous(axiom.getProperties().stream().filter(IsAnonymous::isNamed).map(OWLObjectPropertyExpression::asOWLObjectProperty));
        }
    }

    @Override
    public void visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.translateAnnotations(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getProperties());
        }
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), axiom.getRange());
    }

    @Override
    public void visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getFirstProperty(), OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), (OWLObject)axiom.getSecondProperty());
    }

    @Override
    public void visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_INVERSE_FUNCTIONAL_PROPERTY.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_REFLEXIVE_PROPERTY.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_IRREFLEXIVE_PROPERTY.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_SYMMETRIC_PROPERTY.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_TRANSITIVE_PROPERTY.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        } else {
            for (OWLEquivalentDataPropertiesAxiom ax : axiom.splitToAnnotatedPairs()) {
                ax.accept(this);
            }
            this.processIfNotAnonymous(axiom.getProperties().stream().filter(IsAnonymous::isNamed).map(OWLDataPropertyExpression::asOWLDataProperty));
        }
    }

    @Override
    public void visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.translateAnnotations(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getProperties());
        }
    }

    @Override
    public void visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    @Override
    public void visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), axiom.getRange());
    }

    @Override
    public void visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    @Override
    public void visit(@Nonnull OWLDatatypeDefinitionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getDatatype(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), (OWLObject)axiom.getDataRange());
    }

    @Override
    public void visit(@Nonnull OWLHasKeyAxiom axiom) {
        Set<OWLPropertyExpression> propertyExpressions = axiom.getPropertyExpressions();
        ArrayList<OWLPropertyExpression> list = new ArrayList<OWLPropertyExpression>(propertyExpressions);
        Collections.sort(list);
        this.addSingleTripleAxiom((OWLAxiom)axiom, (R)axiom.getClassExpression(), (P)OWLRDFVocabulary.OWL_HAS_KEY.getIRI(), (N)list);
    }

    @Override
    public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
        axiom.splitToAnnotatedPairs().forEach(a -> this.addSingleTripleAxiom((OWLAxiom)a, (OWLObject)a.getIndividualsAsList().get(0), OWLRDFVocabulary.OWL_SAME_AS.getIRI(), (OWLObject)a.getIndividualsAsList().get(1)));
        this.processIfAnonymous(axiom.getIndividuals(), (OWLAxiom)axiom);
        this.processIfNotAnonymous(axiom.getIndividualsAsList().stream().filter(IsAnonymous::isNamed).map(OWLIndividual::asOWLNamedIndividual));
    }

    @Override
    public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
        if (axiom.getIndividuals().size() == 2) {
            this.addPairwise(axiom, axiom.getIndividuals(), OWLRDFVocabulary.OWL_DIFFERENT_FROM.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DIFFERENT.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS.getIRI(), axiom.getIndividuals());
            this.translateAnnotations(axiom);
            this.processIfAnonymous(axiom.getIndividuals(), (OWLAxiom)axiom);
            this.processIfNotAnonymous(axiom.getIndividualsAsList().stream().filter(IsAnonymous::isNamed).map(OWLIndividual::asOWLNamedIndividual));
        }
    }

    @Override
    public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getIndividual(), OWLRDFVocabulary.RDF_TYPE.getIRI(), (OWLObject)axiom.getClassExpression());
        this.processIfAnonymous(axiom.getIndividual(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
        OWLObjectPropertyAssertionAxiom simplified = axiom.getSimplified();
        this.addSingleTripleAxiom((OWLAxiom)simplified, (OWLObject)simplified.getSubject(), simplified.getProperty(), (OWLObject)simplified.getObject());
        this.processIfAnonymous((OWLIndividual)simplified.getObject(), (OWLAxiom)axiom);
        this.processIfAnonymous(simplified.getSubject(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), (OWLObject)axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL.getIRI(), (OWLObject)axiom.getObject());
        this.translateAnnotations(axiom);
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
        this.processIfAnonymous((OWLIndividual)axiom.getObject(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), axiom.getProperty(), (OWLObject)axiom.getObject());
    }

    @Override
    public void visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), (OWLObject)axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), (OWLObject)axiom.getObject());
        this.translateAnnotations(axiom);
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), axiom.getProperty(), (OWLObject)axiom.getValue());
        if (axiom.getValue() instanceof OWLAnonymousIndividual) {
            this.processIfAnonymous((OWLAnonymousIndividual)axiom.getValue(), (OWLAxiom)axiom);
        }
    }

    @Override
    public void visit(@Nonnull OWLSubAnnotationPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(@Nonnull OWLAnnotationPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), axiom.getDomain());
    }

    @Override
    public void visit(@Nonnull OWLAnnotationPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), axiom.getRange());
    }

    @Override
    public void visit(@Nonnull OWLClass ce) {
        this.storeNodeIfNotPresent(ce, this.getResourceNode(ce.getIRI()));
        this.addStrongTyping(ce);
    }

    @Override
    public void visit(@Nonnull OWLDatatype node) {
        this.storeNodeIfNotPresent(node, this.getResourceNode(node.getIRI()));
        this.addStrongTyping(node);
    }

    @Override
    public void visit(@Nonnull OWLFacetRestriction node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, node.getFacet().getIRI(), (OWLObject)node.getFacetValue());
    }

    @Override
    public void visit(IRI iri) {
        this.storeNodeIfNotPresent(iri, this.getResourceNode(iri));
    }

    @Override
    public void visit(OWLLiteral node) {
        this.storeNodeIfNotPresent(node, this.getLiteralNode(node));
    }

    @Override
    public void visit(@Nonnull OWLDataProperty property) {
        this.storeNodeIfNotPresent(property, this.getPredicateNode(property.getIRI()));
        this.addStrongTyping(property);
    }

    @Override
    public void visit(@Nonnull OWLObjectProperty property) {
        this.storeNodeIfNotPresent(property, this.getPredicateNode(property.getIRI()));
        this.addStrongTyping(property);
    }

    @Override
    public void visit(@Nonnull OWLAnnotationProperty property) {
        this.storeNodeIfNotPresent(property, this.getPredicateNode(property.getIRI()));
        this.addStrongTyping(property);
    }

    @Override
    public void visit(@Nonnull OWLNamedIndividual individual) {
        this.storeNodeIfNotPresent(individual, this.getResourceNode(individual.getIRI()));
        this.addStrongTyping(individual);
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.translateAnonymousNode(individual);
    }

    @Override
    public void visit(@Nonnull OWLOntology ontology) {
        if (ontology.getOntologyID().getOntologyIRI().isPresent()) {
            this.storeNodeIfNotPresent(ontology, this.getResourceNode(ontology.getOntologyID().getOntologyIRI().get()));
        } else {
            this.translateAnonymousNode(ontology);
        }
        this.addTriple((OWLObject)ontology, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ONTOLOGY.getIRI());
        this.addVersionIRIToOntologyHeader(ontology);
        this.addImportsDeclarationsToOntologyHeader(ontology);
        this.addAnnotationsToOntologyHeader(ontology);
        this.graph.setOntology((RDFResource)this.getMappedNode(ontology));
    }

    private void addVersionIRIToOntologyHeader(OWLOntology ontology) {
        OWLOntologyID ontID = ontology.getOntologyID();
        if (ontID.getVersionIRI().isPresent()) {
            this.addTriple((OWLObject)ontology, OWLRDFVocabulary.OWL_VERSION_IRI.getIRI(), ontID.getVersionIRI().get());
        }
    }

    private void addImportsDeclarationsToOntologyHeader(OWLOntology ontology) {
        ontology.getImportsDeclarations().forEach(decl -> this.addTriple((OWLObject)ontology, OWLRDFVocabulary.OWL_IMPORTS.getIRI(), decl.getIRI()));
    }

    private void addAnnotationsToOntologyHeader(OWLOntology ontology) {
        ontology.getAnnotations().forEach(a -> this.translateAnnotation(ontology, (OWLAnnotation)a));
    }

    @Override
    public void visit(@Nonnull SWRLRule rule) {
        this.translateAnonymousNode(rule);
        this.translateAnnotations(rule);
        this.addTriple((OWLObject)rule, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.IMP.getIRI());
        Set<SWRLAtom> antecedent = rule.getBody();
        this.addTriple(rule, SWRLVocabulary.BODY.getIRI(), antecedent, SWRLVocabulary.ATOM_LIST.getIRI());
        Set<SWRLAtom> consequent = rule.getHead();
        this.addTriple(rule, SWRLVocabulary.HEAD.getIRI(), consequent, SWRLVocabulary.ATOM_LIST.getIRI());
    }

    @Override
    public void visit(@Nonnull SWRLClassAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.CLASS_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.CLASS_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    @Override
    public void visit(@Nonnull SWRLDataRangeAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATA_RANGE_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.DATA_RANGE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLDArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    @Override
    public void visit(@Nonnull SWRLObjectPropertyAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.INDIVIDUAL_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(@Nonnull SWRLDataPropertyAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATAVALUED_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLDArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(@Nonnull SWRLBuiltInAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.BUILT_IN_ATOM.getIRI());
        this.addTriple((OWLObject)node, SWRLVocabulary.BUILT_IN.getIRI(), node.getPredicate());
        this.addTriple(this.getResourceNode(node.getPredicate()), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(SWRLVocabulary.BUILT_IN_CLASS.getIRI()));
        this.addTriple(this.getResourceNode(node), this.getPredicateNode(SWRLVocabulary.ARGUMENTS.getIRI()), this.translateList(new ArrayList<SWRLDArgument>(node.getArguments())));
    }

    @Override
    public void visit(@Nonnull SWRLDifferentIndividualsAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DIFFERENT_INDIVIDUALS_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(@Nonnull SWRLSameIndividualAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.SAME_INDIVIDUAL_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(@Nonnull SWRLVariable node) {
        this.storeNodeIfNotPresent(node, this.getResourceNode(node.getIRI()));
        if (!this.ont.containsIndividualInSignature(node.getIRI())) {
            this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.VARIABLE.getIRI());
        }
    }

    @Override
    public void visit(@Nonnull SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
        this.storeNodeIfNotPresent(node, (Serializable)this.nodeMap.get(node.getIndividual()));
    }

    @Override
    public void visit(@Nonnull SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
        this.storeNodeIfNotPresent(node, (Serializable)this.nodeMap.get(node.getLiteral()));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull OWLObject obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), (Serializable)this.getNode(obj, subject, pred));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull IRI obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(obj));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull OWLObject subj, @Nonnull IRI pred, @Nonnull List<? extends OWLObject> obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.translateList(obj));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull OWLObject subj, @Nonnull OWLObject pred, @Nonnull OWLObject obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.getNode(obj));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull R subject, @Nonnull P predicate, @Nonnull N object) {
        this.addTriple(subject, predicate, object);
        if (ax.getAnnotations().isEmpty()) {
            return;
        }
        this.translateAnonymousNode(ax);
        this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(OWLRDFVocabulary.OWL_AXIOM.getIRI()));
        this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI()), subject);
        this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI()), predicate);
        this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI()), object);
        this.translateAnnotations(ax);
    }

    private void translateAnnotations(@Nonnull OWLAxiom ax) {
        this.translateAnonymousNode(ax);
        for (OWLAnnotation anno : AbstractTranslator.sort(ax.getAnnotations())) {
            assert (anno != null);
            this.translateAnnotation(ax, anno);
        }
    }

    private void translateAnnotation(@Nonnull OWLObject subject, @Nonnull OWLAnnotation annotation) {
        Set<OWLAnnotation> annotations;
        this.addTriple(subject, annotation.getProperty().getIRI(), (OWLObject)annotation.getValue());
        annotation.getProperty().accept(this);
        if (annotation.getValue() instanceof OWLAnonymousIndividual) {
            OWLAnonymousIndividual ind = (OWLAnonymousIndividual)annotation.getValue();
            this.translateAnonymousNode(ind);
            this.processIfAnonymous(ind);
        }
        if ((annotations = annotation.getAnnotations()).isEmpty()) {
            return;
        }
        this.translateAnonymousNode(annotation);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATION.getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI(), subject);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI(), annotation.getProperty().getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI(), (OWLObject)annotation.getValue());
        for (OWLAnnotation anno : AbstractTranslator.sort(annotations)) {
            assert (anno != null);
            this.translateAnnotation(annotation, anno);
        }
    }

    @Override
    public void visit(OWLAnnotation node) {
        throw new OWLRuntimeException("The translator should not be used directly on instances of OWLAnnotation because an annotation cannot be translated without a subject.");
    }

    private void translateAnonymousNode(@Nonnull OWLObject object) {
        this.storeNode(object, this.getAnonymousNode(object));
    }

    private void storeNode(@Nonnull OWLObject object, N value) {
        if (!RDFRendererBase.isNotAnonymousExpression(object)) {
            this.expressionMap.put(object, value);
        } else {
            this.nodeMap.put(object, value);
        }
    }

    private void storeNodeIfNotPresent(@Nonnull OWLObject object, N value) {
        Object v = this.getMappedNode(object);
        if (v == null) {
            this.storeNode(object, value);
        }
    }

    public <T extends N> T getMappedNode(OWLObject object) {
        if (!RDFRendererBase.isNotAnonymousExpression(object)) {
            return (T)((Serializable)this.expressionMap.get(object));
        }
        return (T)((Serializable)this.nodeMap.get(object));
    }

    public void addTriple(R subject, IRI pred, IRI object) {
        this.addTriple(subject, this.getPredicateNode(pred), this.getResourceNode(object));
    }

    public void addTriple(R subject, IRI pred, OWLObject object) {
        this.addTriple(subject, this.getPredicateNode(pred), this.getNode(object));
    }

    @Nonnull
    protected abstract R getResourceNode(@Nonnull IRI var1);

    @Nonnull
    protected abstract P getPredicateNode(@Nonnull IRI var1);

    @Nonnull
    protected abstract R getAnonymousNode(@Nonnull Object var1);

    @Nonnull
    protected abstract R getAnonymousNodeForExpressions(@Nonnull Object var1, boolean var2);

    @Nonnull
    protected abstract L getLiteralNode(@Nonnull OWLLiteral var1);

    protected abstract void addTriple(@Nonnull R var1, @Nonnull P var2, @Nonnull N var3);

    @Nonnull
    private R getResourceNode(@Nonnull OWLObject object) {
        Object r = this.getMappedNode(object);
        if (r == null) {
            object.accept(this);
            r = this.getMappedNode(object);
            if (r == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + object);
            }
        }
        return (R)r;
    }

    @Nonnull
    private P getPredicateNode(@Nonnull OWLObject object) {
        Object p = this.getMappedNode(object);
        if (p == null) {
            object.accept(this);
            p = this.getMappedNode(object);
            if (p == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + object);
            }
        }
        return (P)p;
    }

    @Nonnull
    private N getNode(@Nonnull OWLObject object) {
        Object node = this.getMappedNode(object);
        if (node == null) {
            object.accept(this);
            node = this.getMappedNode(object);
            if (node == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + object);
            }
        }
        return (N)node;
    }

    private boolean isAnonymousExpression(OWLObject o) {
        return !(o instanceof OWLAxiom) && !(o instanceof OWLIndividual) && !(o instanceof OWLOntology) && !o.isIRI() && !(this instanceof OWLLiteral) && o.isAnonymous();
    }

    private <O> O getNode(OWLObject obj, OWLObject s2, IRI p) {
        if (this.isAnonymousExpression(obj)) {
            OWLObject[] context = this.expressionContext.get(obj);
            if (context == null) {
                context = new OWLObject[]{s2, p, obj};
                this.expressionContext.put(obj, context);
                return (O)this.getNode(obj);
            }
            if (context[0].equals(s2) && context[1].equals(p)) {
                return (O)this.getNode(context[2]);
            }
            context = new OWLObject[]{s2, p, obj};
            this.expressionContext.put(obj, context);
            return (O)this.getNode(obj);
        }
        return (O)this.getNode(obj);
    }

    @Nonnull
    private R translateList(@Nonnull List<? extends OWLObject> list) {
        return this.translateList(list, OWLRDFVocabulary.RDF_LIST.getIRI());
    }

    @Nonnull
    private R translateList(@Nonnull List<? extends OWLObject> list, @Nonnull IRI listType) {
        int listSize;
        if (list.isEmpty()) {
            return this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        }
        R main = this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        for (int i = listSize = list.size() - 1; i >= 0; --i) {
            R anonNode = this.getAnonymousNode(list.subList(i, listSize));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(listType));
            OWLObject obj = list.get(i);
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_FIRST.getIRI()), this.getNode(obj));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_REST.getIRI()), main);
            main = anonNode;
        }
        return main;
    }

    private void addTriple(@Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull IRI object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(object));
    }

    private void addTriple(@Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull OWLObject object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getNode(object));
    }

    private void addListTriples(@Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull Set<? extends OWLObject> objects) {
        ArrayList<? extends OWLObject> list = new ArrayList<OWLObject>(objects);
        Collections.sort(list);
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(list));
    }

    private void addTriple(@Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull Set<? extends OWLObject> objects, @Nonnull IRI listType) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(objects), listType));
    }

    @Nonnull
    private OWLLiteral toTypedConstant(int i) {
        return this.manager.getOWLDataFactory().getOWLLiteral(Integer.toString(i), this.manager.getOWLDataFactory().getOWLDatatype(XSDVocabulary.NON_NEGATIVE_INTEGER.getIRI()));
    }

    private void processIfAnonymous(@Nonnull Set<OWLIndividual> inds, OWLAxiom root) {
        for (OWLIndividual ind : CollectionFactory.sortOptionally(inds)) {
            assert (ind != null);
            this.processIfAnonymous(ind, root);
        }
    }

    private void processIfNotAnonymous(@Nonnull Stream<OWLEntity> inds) {
        inds.forEach(this.graph::addRootIRIs);
    }

    private void processIfAnonymous(@Nonnull OWLIndividual ind, @Nullable OWLAxiom root) {
        this.process(ind, x -> !Objects.equals(x, root));
    }

    protected void process(OWLIndividual ind, Predicate<OWLAxiom> include) {
        if (!this.currentIndividuals.contains(ind)) {
            this.currentIndividuals.add(ind);
            if (ind.isAnonymous()) {
                for (OWLAxiom oWLAxiom : this.getSortedIndividualAxioms(ind)) {
                    if (!include.test(oWLAxiom)) continue;
                    this.translate(this.desharer.deshareObject(oWLAxiom));
                }
                for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : AbstractTranslator.sort(this.getAnnotationAssertionsForAnonymous(ind))) {
                    if (!include.test(oWLAnnotationAssertionAxiom)) continue;
                    this.translate(this.desharer.deshareObject(oWLAnnotationAssertionAxiom));
                }
            }
            this.currentIndividuals.remove(ind);
        }
    }

    private void processIfAnonymous(@Nonnull OWLIndividual ind) {
        this.process(ind, x -> true);
    }

    @Nonnull
    private static <T extends OWLObject> List<T> sort(Collection<T> axioms) {
        return CollectionFactory.sortOptionally(axioms);
    }

    @Nonnull
    private Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionsForAnonymous(@Nonnull OWLIndividual ind) {
        OWLAnonymousIndividual owlAnonymousIndividual = ind.asOWLAnonymousIndividual();
        return this.ont.getAnnotationAssertionAxioms(owlAnonymousIndividual);
    }

    @Nonnull
    private List<OWLIndividualAxiom> getSortedIndividualAxioms(@Nonnull OWLIndividual ind) {
        return AbstractTranslator.sort(this.ont.getAxioms(ind, Imports.EXCLUDED));
    }

    private void addPairwise(@Nonnull OWLAxiom axiom, @Nonnull Collection<? extends OWLObject> objects, @Nonnull IRI iri) {
        ArrayList<? extends OWLObject> objectList = new ArrayList<OWLObject>(objects);
        Collections.sort(objectList);
        for (int i = 0; i < objectList.size(); ++i) {
            for (int j = i; j < objectList.size(); ++j) {
                if (i == j) continue;
                this.addSingleTripleAxiom(axiom, (OWLObject)objectList.get(i), iri, (OWLObject)objectList.get(j));
            }
        }
    }

    private void addPairwiseClassExpressions(@Nonnull OWLAxiom axiom, @Nonnull Set<OWLClassExpression> classExpressions, @Nonnull IRI iri) {
        this.addPairwise(axiom, classExpressions, iri);
    }

    private void addStrongTyping(@Nonnull OWLEntity entity) {
        if (!this.useStrongTyping) {
            return;
        }
        if (!OWLDocumentFormatImpl.isMissingType(entity, this.ont)) {
            return;
        }
        this.addTriple((OWLObject)entity, OWLRDFVocabulary.RDF_TYPE.getIRI(), entity.accept(OWLEntityTypeProvider.INSTANCE));
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    public void reset() {
        this.graph = new RDFGraph();
    }

    private static class OWLEntityTypeProvider
    implements OWLEntityVisitorEx<IRI> {
        @Nonnull
        public static final OWLEntityTypeProvider INSTANCE = new OWLEntityTypeProvider();

        private OWLEntityTypeProvider() {
        }

        @Override
        public IRI visit(OWLClass cls) {
            return OWLRDFVocabulary.OWL_CLASS.getIRI();
        }

        @Override
        public IRI visit(OWLObjectProperty property) {
            return OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI();
        }

        @Override
        public IRI visit(OWLDataProperty property) {
            return OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI();
        }

        @Override
        public IRI visit(OWLNamedIndividual individual) {
            return OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI();
        }

        @Override
        public IRI visit(OWLDatatype datatype) {
            return OWLRDFVocabulary.RDFS_DATATYPE.getIRI();
        }

        @Override
        public IRI visit(OWLAnnotationProperty property) {
            return OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI();
        }
    }
}

