/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;

public class EntitySearcher {
    @Nonnull
    public static Collection<OWLAnnotation> getAnnotations(@Nonnull OWLEntity e, @Nonnull OWLOntology ontology) {
        return EntitySearcher.getAnnotations(e.getIRI(), ontology);
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotations(@Nonnull OWLAnnotationSubject e, @Nonnull OWLOntology ontology) {
        return Searcher.annotations(ontology.getAnnotationAssertionAxioms(e));
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotations(@Nonnull OWLEntity e, @Nonnull OWLOntology ontology, @Nonnull OWLAnnotationProperty annotationProperty) {
        return EntitySearcher.getAnnotations((OWLAnnotationSubject)e.getIRI(), ontology, annotationProperty);
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotations(@Nonnull OWLAnnotationSubject e, @Nonnull OWLOntology ontology, @Nonnull OWLAnnotationProperty annotationProperty) {
        return Searcher.annotations(ontology.getAnnotationAssertionAxioms(e), annotationProperty);
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotations(@Nonnull OWLAnnotationSubject e, @Nonnull Iterable<OWLOntology> ontologies, @Nonnull OWLAnnotationProperty annotationProperty) {
        HashSet<OWLAnnotation> toReturn = new HashSet<OWLAnnotation>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            toReturn.addAll(EntitySearcher.getAnnotations(e, o, annotationProperty));
        }
        return toReturn;
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotations(@Nonnull OWLEntity e, @Nonnull Iterable<OWLOntology> ontologies, @Nonnull OWLAnnotationProperty annotationProperty) {
        HashSet<OWLAnnotation> toReturn = new HashSet<OWLAnnotation>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            toReturn.addAll(EntitySearcher.getAnnotations(e, o, annotationProperty));
        }
        return toReturn;
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotationObjects(@Nonnull OWLEntity e, @Nonnull OWLOntology ontology, @Nullable OWLAnnotationProperty annotationProperty) {
        return EntitySearcher.getAnnotationObjects((OWLAnnotationSubject)e.getIRI(), ontology, annotationProperty);
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotationObjects(@Nonnull OWLEntity e, @Nonnull OWLOntology ontology) {
        return EntitySearcher.getAnnotationObjects((OWLAnnotationSubject)e.getIRI(), ontology, null);
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotationObjects(@Nonnull OWLEntity e, @Nonnull Iterable<OWLOntology> ontologies) {
        return EntitySearcher.getAnnotationObjects((OWLAnnotationSubject)e.getIRI(), ontologies, null);
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotationObjects(@Nonnull OWLAnnotationSubject e, @Nonnull OWLOntology ontology, @Nullable OWLAnnotationProperty annotationProperty) {
        return Searcher.annotationObjects(ontology.getAnnotationAssertionAxioms(e), annotationProperty);
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotationObjects(@Nonnull OWLAnnotationSubject e, @Nonnull Iterable<OWLOntology> ontologies, @Nullable OWLAnnotationProperty annotationProperty) {
        HashSet<OWLAnnotation> toReturn = new HashSet<OWLAnnotation>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            toReturn.addAll(EntitySearcher.getAnnotationObjects(e, o, annotationProperty));
        }
        return toReturn;
    }

    @Nonnull
    public static Collection<OWLAnnotation> getAnnotationObjects(@Nonnull OWLEntity e, @Nonnull Iterable<OWLOntology> ontologies, @Nonnull OWLAnnotationProperty annotationProperty) {
        HashSet<OWLAnnotation> toReturn = new HashSet<OWLAnnotation>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            toReturn.addAll(EntitySearcher.getAnnotationObjects(e, o, annotationProperty));
        }
        return toReturn;
    }

    @Nonnull
    public static Collection<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(@Nonnull OWLEntity e, @Nonnull OWLOntology ontology) {
        return EntitySearcher.getAnnotationAssertionAxioms(e.getIRI(), ontology);
    }

    @Nonnull
    public static Collection<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(@Nonnull OWLAnnotationSubject e, @Nonnull OWLOntology ontology) {
        return ontology.getAnnotationAssertionAxioms(e);
    }

    @Nonnull
    public static Collection<OWLAnnotationProperty> getSubProperties(@Nonnull OWLAnnotationProperty e, @Nonnull OWLOntology ontology) {
        return Searcher.sub(ontology.filterAxioms(Filters.subAnnotationWithSuper, e, Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLAnnotationProperty> getSubProperties(@Nonnull OWLAnnotationProperty e, @Nonnull OWLOntology ontology, boolean imports) {
        return Searcher.sub(ontology.filterAxioms(Filters.subAnnotationWithSuper, e, imports ? Imports.INCLUDED : Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLAnnotationProperty> getSubProperties(@Nonnull OWLAnnotationProperty e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLAnnotationProperty> collection = new ArrayList<OWLAnnotationProperty>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSubProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLAnnotationProperty> getSuperProperties(@Nonnull OWLAnnotationProperty e, @Nonnull OWLOntology ontology) {
        return Searcher.sup(ontology.filterAxioms(Filters.subAnnotationWithSub, e, Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLAnnotationProperty> getSuperProperties(@Nonnull OWLAnnotationProperty e, @Nonnull OWLOntology ontology, boolean imports) {
        return Searcher.sup(ontology.filterAxioms(Filters.subAnnotationWithSub, e, imports ? Imports.INCLUDED : Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLAnnotationProperty> getSuperProperties(@Nonnull OWLAnnotationProperty e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLAnnotationProperty> collection = new ArrayList<OWLAnnotationProperty>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSuperProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getSubProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology ontology) {
        return Searcher.sub(ontology.filterAxioms(Filters.subObjectPropertyWithSuper, e, Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getSubProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology ontology, boolean imports) {
        return Searcher.sub(ontology.filterAxioms(Filters.subObjectPropertyWithSuper, e, imports ? Imports.INCLUDED : Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getSubProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLObjectPropertyExpression> collection = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSubProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getSubProperties(@Nonnull P e, @Nonnull OWLOntology ontology) {
        return Searcher.sub(ontology.filterAxioms(EntitySearcher.subPropertiesFilter(e), e, Imports.EXCLUDED));
    }

    protected static <P extends OWLPropertyExpression> OWLAxiomSearchFilter subPropertiesFilter(P e) {
        if (e.isDataPropertyExpression()) {
            return Filters.subDataPropertyWithSuper;
        }
        if (e.isObjectPropertyExpression()) {
            return Filters.subObjectPropertyWithSuper;
        }
        return Filters.subAnnotationWithSuper;
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getSubProperties(@Nonnull P e, @Nonnull OWLOntology ontology, boolean imports) {
        return Searcher.sub(ontology.filterAxioms(EntitySearcher.subPropertiesFilter(e), e, imports ? Imports.INCLUDED : Imports.EXCLUDED));
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getSubProperties(@Nonnull P e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<P> collection = new ArrayList<P>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSubProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getSuperProperties(@Nonnull P e, @Nonnull OWLOntology ontology) {
        return Searcher.sup(ontology.filterAxioms(EntitySearcher.superPropertiesFilter(e), e, Imports.EXCLUDED));
    }

    protected static <P extends OWLPropertyExpression> OWLAxiomSearchFilter superPropertiesFilter(P e) {
        if (e.isDataPropertyExpression()) {
            return Filters.subDataPropertyWithSub;
        }
        if (e.isObjectPropertyExpression()) {
            return Filters.subObjectPropertyWithSub;
        }
        return Filters.subAnnotationWithSub;
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getSuperProperties(@Nonnull P e, @Nonnull OWLOntology ontology, boolean imports) {
        return Searcher.sub(ontology.filterAxioms(EntitySearcher.superPropertiesFilter(e), e, imports ? Imports.INCLUDED : Imports.EXCLUDED));
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getSuperProperties(@Nonnull P e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<P> collection = new ArrayList<P>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSuperProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getSuperProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology ontology) {
        return Searcher.sup(ontology.filterAxioms(Filters.subObjectPropertyWithSub, e, Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getSuperProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology ontology, boolean imports) {
        return Searcher.sup(ontology.filterAxioms(Filters.subObjectPropertyWithSub, e, imports ? Imports.INCLUDED : Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getSuperProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLObjectPropertyExpression> collection = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSuperProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getSubProperties(@Nonnull OWLDataPropertyExpression e, @Nonnull OWLOntology ontology) {
        return Searcher.sub(ontology.filterAxioms(Filters.subDataPropertyWithSuper, e, Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getSubProperties(@Nonnull OWLDataPropertyExpression e, @Nonnull OWLOntology ontology, boolean imports) {
        return Searcher.sub(ontology.filterAxioms(Filters.subDataPropertyWithSuper, e, imports ? Imports.INCLUDED : Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getSubProperties(@Nonnull OWLDataPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLDataPropertyExpression> collection = new ArrayList<OWLDataPropertyExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSubProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getSuperProperties(@Nonnull OWLDataPropertyExpression e, @Nonnull OWLOntology ontology) {
        return Searcher.sup(ontology.filterAxioms(Filters.subDataPropertyWithSub, e, Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getSuperProperties(@Nonnull OWLDataPropertyExpression e, @Nonnull OWLOntology ontology, boolean imports) {
        return Searcher.sup(ontology.filterAxioms(Filters.subDataPropertyWithSub, e, imports ? Imports.INCLUDED : Imports.EXCLUDED));
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getSuperProperties(@Nonnull OWLDataPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLDataPropertyExpression> collection = new ArrayList<OWLDataPropertyExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSuperProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLClassExpression> getSuperClasses(@Nonnull OWLClass e, @Nonnull OWLOntology ontology) {
        return Searcher.sup(ontology.getSubClassAxiomsForSubClass(e));
    }

    @Nonnull
    public static Collection<OWLClassExpression> getSuperClasses(@Nonnull OWLClass e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLClassExpression> collection = new ArrayList<OWLClassExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSuperClasses(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLClassExpression> getSubClasses(@Nonnull OWLClass e, @Nonnull OWLOntology ontology) {
        return Searcher.sub(ontology.getSubClassAxiomsForSuperClass(e));
    }

    @Nonnull
    public static Collection<OWLClassExpression> getSubClasses(@Nonnull OWLClass e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLClassExpression> collection = new ArrayList<OWLClassExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSubClasses(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLClassExpression> getEquivalentClasses(@Nonnull OWLClass e, @Nonnull OWLOntology ontology) {
        Collection<OWLClassExpression> equivalent = Searcher.equivalent(ontology.getEquivalentClassesAxioms(e));
        equivalent.remove(e);
        return equivalent;
    }

    @Nonnull
    public static Collection<OWLClassExpression> getEquivalentClasses(@Nonnull OWLClass e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLClassExpression> collection = new ArrayList<OWLClassExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getEquivalentClasses(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLClassExpression> getDisjointClasses(@Nonnull OWLClass e, @Nonnull OWLOntology ontology) {
        return Searcher.different(ontology.getDisjointClassesAxioms(e));
    }

    @Nonnull
    public static Collection<OWLClassExpression> getDisjointClasses(@Nonnull OWLClass e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLClassExpression> collection = new ArrayList<OWLClassExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getDisjointClasses(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLIndividual> getDifferentIndividuals(@Nonnull OWLIndividual e, @Nonnull OWLOntology ontology) {
        return Searcher.different(ontology.getDifferentIndividualAxioms(e));
    }

    @Nonnull
    public static Collection<OWLIndividual> getDifferentIndividuals(@Nonnull OWLIndividual e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLIndividual> collection = new ArrayList<OWLIndividual>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getDifferentIndividuals(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLIndividual> getSameIndividuals(@Nonnull OWLIndividual e, @Nonnull OWLOntology ontology) {
        Collection<OWLIndividual> equivalent = Searcher.equivalent(ontology.getSameIndividualAxioms(e));
        equivalent.remove(e);
        return equivalent;
    }

    @Nonnull
    public static Collection<OWLIndividual> getSameIndividuals(@Nonnull OWLIndividual e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLIndividual> collection = new ArrayList<OWLIndividual>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getSameIndividuals(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getEquivalentProperties(@Nonnull OWLDataProperty e, @Nonnull OWLOntology ontology) {
        Collection<OWLDataPropertyExpression> equivalent = Searcher.equivalent(ontology.getEquivalentDataPropertiesAxioms(e));
        equivalent.remove(e);
        return equivalent;
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getEquivalentProperties(@Nonnull OWLDataProperty e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLDataPropertyExpression> collection = new ArrayList<OWLDataPropertyExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getEquivalentProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getEquivalentProperties(@Nonnull P e, @Nonnull OWLOntology ontology) {
        if (e.isDataPropertyExpression()) {
            return Searcher.equivalent(ontology.getEquivalentDataPropertiesAxioms((OWLDataProperty)e));
        }
        return Searcher.equivalent(ontology.getEquivalentObjectPropertiesAxioms((OWLObjectPropertyExpression)e));
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getEquivalentProperties(@Nonnull P e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<P> collection = new ArrayList<P>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getEquivalentProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getDisjointProperties(@Nonnull OWLDataProperty e, @Nonnull OWLOntology ontology) {
        return Searcher.different(ontology.getDisjointDataPropertiesAxioms(e));
    }

    @Nonnull
    public static Collection<OWLDataPropertyExpression> getDisjointProperties(@Nonnull OWLDataProperty e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLDataPropertyExpression> collection = new ArrayList<OWLDataPropertyExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getDisjointProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getDisjointProperties(@Nonnull P e, @Nonnull OWLOntology ontology) {
        if (e.isDataPropertyExpression()) {
            return Searcher.different(ontology.getDisjointDataPropertiesAxioms((OWLDataProperty)e));
        }
        return Searcher.different(ontology.getDisjointObjectPropertiesAxioms((OWLObjectPropertyExpression)e));
    }

    @Nonnull
    public static <P extends OWLPropertyExpression> Collection<P> getDisjointProperties(@Nonnull P e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<P> collection = new ArrayList<P>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getDisjointProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getEquivalentProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology ontology) {
        Collection<OWLObjectPropertyExpression> equivalent = Searcher.equivalent(ontology.getEquivalentObjectPropertiesAxioms(e));
        equivalent.remove(e);
        return equivalent;
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getEquivalentProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLObjectPropertyExpression> collection = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getEquivalentProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getDisjointProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology ontology) {
        return Searcher.different(ontology.getDisjointObjectPropertiesAxioms(e));
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getDisjointProperties(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLObjectPropertyExpression> collection = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getDisjointProperties(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLIndividual> getIndividuals(@Nonnull OWLClass e, @Nonnull OWLOntology ontology) {
        return Searcher.instances(ontology.getClassAssertionAxioms(e));
    }

    @Nonnull
    public static Collection<OWLIndividual> getIndividuals(@Nonnull OWLClass e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLIndividual> list = new ArrayList<OWLIndividual>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            list.addAll(EntitySearcher.getIndividuals(e, o));
        }
        return list;
    }

    @Nonnull
    public static Collection<OWLAxiom> getReferencingAxioms(@Nonnull OWLEntity e, @Nonnull OWLOntology ontology) {
        return ontology.getReferencingAxioms((OWLPrimitive)e, Imports.EXCLUDED);
    }

    @Nonnull
    public static Collection<OWLAxiom> getReferencingAxioms(@Nonnull OWLEntity e, @Nonnull OWLOntology ontology, boolean includeImports) {
        return ontology.getReferencingAxioms((OWLPrimitive)e, includeImports ? Imports.INCLUDED : Imports.EXCLUDED);
    }

    @Nonnull
    public static Collection<OWLClassExpression> getDomains(@Nonnull OWLDataProperty e, @Nonnull OWLOntology ontology) {
        return Searcher.domain(ontology.getDataPropertyDomainAxioms(e));
    }

    @Nonnull
    public static Collection<OWLClassExpression> getDomains(@Nonnull OWLDataProperty e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLClassExpression> list = new ArrayList<OWLClassExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            list.addAll(EntitySearcher.getDomains(e, o));
        }
        return list;
    }

    @Nonnull
    public static Collection<OWLClassExpression> getDomains(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology ontology) {
        return Searcher.domain(ontology.getObjectPropertyDomainAxioms(e));
    }

    @Nonnull
    public static Collection<OWLDataRange> getRanges(@Nonnull OWLDataProperty e, @Nonnull OWLOntology ontology) {
        return Searcher.range(ontology.getDataPropertyRangeAxioms(e));
    }

    @Nonnull
    public static Collection<OWLDataRange> getRanges(@Nonnull OWLDataProperty e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLDataRange> list = new ArrayList<OWLDataRange>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            list.addAll(EntitySearcher.getRanges(e, o));
        }
        return list;
    }

    @Nonnull
    public static Collection<OWLClassExpression> getDomains(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLClassExpression> list = new ArrayList<OWLClassExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            list.addAll(EntitySearcher.getDomains(e, o));
        }
        return list;
    }

    @Nonnull
    public static Collection<OWLClassExpression> getRanges(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology ontology) {
        return Searcher.range(ontology.getObjectPropertyRangeAxioms(e));
    }

    @Nonnull
    public static Collection<OWLClassExpression> getRanges(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLClassExpression> list = new ArrayList<OWLClassExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            list.addAll(EntitySearcher.getRanges(e, o));
        }
        return list;
    }

    @Nonnull
    public static Collection<IRI> getDomains(@Nonnull OWLAnnotationProperty e, @Nonnull OWLOntology ontology) {
        return Searcher.domain(ontology.getAnnotationPropertyDomainAxioms(e));
    }

    @Nonnull
    public static Collection<IRI> getDomains(@Nonnull OWLAnnotationProperty e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<IRI> list = new ArrayList<IRI>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            list.addAll(EntitySearcher.getDomains(e, o));
        }
        return list;
    }

    @Nonnull
    public static Collection<IRI> getRanges(@Nonnull OWLAnnotationProperty e, @Nonnull OWLOntology ontology) {
        return Searcher.range(ontology.getAnnotationPropertyRangeAxioms(e));
    }

    @Nonnull
    public static Collection<IRI> getRanges(@Nonnull OWLAnnotationProperty e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<IRI> list = new ArrayList<IRI>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            list.addAll(EntitySearcher.getRanges(e, o));
        }
        return list;
    }

    public static boolean isTransitive(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology o) {
        return !o.getTransitiveObjectPropertyAxioms(e).isEmpty();
    }

    public static boolean isTransitive(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.isTransitive(e, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSymmetric(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology o) {
        return !o.getSymmetricObjectPropertyAxioms(e).isEmpty();
    }

    public static boolean isSymmetric(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.isSymmetric(e, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAsymmetric(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology o) {
        return !o.getAsymmetricObjectPropertyAxioms(e).isEmpty();
    }

    public static boolean isAsymmetric(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.isAsymmetric(e, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReflexive(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology o) {
        return !o.getReflexiveObjectPropertyAxioms(e).isEmpty();
    }

    public static boolean isReflexive(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.isReflexive(e, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIrreflexive(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology o) {
        return !o.getIrreflexiveObjectPropertyAxioms(e).isEmpty();
    }

    public static boolean isIrreflexive(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.isIrreflexive(e, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInverseFunctional(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology o) {
        return !o.getInverseFunctionalObjectPropertyAxioms(e).isEmpty();
    }

    public static boolean isInverseFunctional(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.isInverseFunctional(e, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFunctional(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology o) {
        return !o.getFunctionalObjectPropertyAxioms(e).isEmpty();
    }

    public static boolean isFunctional(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.isFunctional(e, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFunctional(@Nonnull OWLDataProperty e, @Nonnull OWLOntology o) {
        return !o.getFunctionalDataPropertyAxioms(e).isEmpty();
    }

    public static boolean isFunctional(@Nonnull OWLDataProperty e, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.isFunctional(e, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefined(@Nonnull OWLClass c, @Nonnull OWLOntology o) {
        return !o.getEquivalentClassesAxioms(c).isEmpty();
    }

    public static boolean isDefined(@Nonnull OWLClass c, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.isDefined(c, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAxiom(@Nonnull OWLAxiom a, @Nonnull OWLOntology o, boolean imports) {
        return o.containsAxiom(a, imports ? Imports.INCLUDED : Imports.EXCLUDED, AxiomAnnotations.CONSIDER_AXIOM_ANNOTATIONS);
    }

    public static boolean containsAxiom(@Nonnull OWLAxiom a, @Nonnull Iterable<OWLOntology> ontologies, boolean imports) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.containsAxiom(a, o, imports)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom a, @Nonnull OWLOntology o, boolean imports) {
        return o.containsAxiom(a, imports ? Imports.INCLUDED : Imports.EXCLUDED, AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS);
    }

    public static boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom a, @Nonnull Iterable<OWLOntology> ontologies, boolean imports) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.containsAxiomIgnoreAnnotations(a, o, imports)) continue;
            return true;
        }
        return false;
    }

    public static Collection<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom a, @Nonnull OWLOntology o, boolean imports) {
        return o.getAxiomsIgnoreAnnotations(a, imports ? Imports.INCLUDED : Imports.EXCLUDED);
    }

    @Nonnull
    public static Collection<OWLLiteral> getDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull OWLOntology ontology) {
        return Searcher.values(ontology.getDataPropertyAssertionAxioms(i), p);
    }

    @Nonnull
    public static Collection<OWLLiteral> getDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLLiteral> collection = new ArrayList<OWLLiteral>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getDataPropertyValues(i, p, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLIndividual> getObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull OWLOntology ontology) {
        return Searcher.values(ontology.getObjectPropertyAssertionAxioms(i), p);
    }

    @Nonnull
    public static Collection<OWLIndividual> getObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLIndividual> collection = new ArrayList<OWLIndividual>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getObjectPropertyValues(i, p, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLLiteral> getNegativeDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull OWLOntology ontology) {
        return Searcher.negValues(ontology.getNegativeDataPropertyAssertionAxioms(i), p);
    }

    @Nonnull
    public static Collection<OWLLiteral> getNegativeDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLLiteral> collection = new ArrayList<OWLLiteral>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getNegativeDataPropertyValues(i, p, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLIndividual> getNegativeObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull OWLOntology ontology) {
        return Searcher.negValues(ontology.getNegativeObjectPropertyAssertionAxioms(i), p);
    }

    @Nonnull
    public static Collection<OWLIndividual> getNegativeObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLIndividual> collection = new ArrayList<OWLIndividual>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getNegativeObjectPropertyValues(i, p, o));
        }
        return collection;
    }

    public static boolean hasDataPropertyValues(@Nonnull OWLIndividual i, OWLDataPropertyExpression p, @Nonnull OWLOntology ontology) {
        return !Searcher.values(ontology.getDataPropertyAssertionAxioms(i), p).isEmpty();
    }

    public static boolean hasDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.hasDataPropertyValues(i, p, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull OWLOntology ontology) {
        return !Searcher.values(ontology.getObjectPropertyAssertionAxioms(i), p).isEmpty();
    }

    public static boolean hasObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.hasObjectPropertyValues(i, p, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNegativeDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull OWLOntology ontology) {
        return !Searcher.negValues(ontology.getNegativeDataPropertyAssertionAxioms(i), p).isEmpty();
    }

    public static boolean hasNegativeDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.hasNegativeDataPropertyValues(i, p, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNegativeObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull OWLOntology ontology) {
        return !Searcher.negValues(ontology.getNegativeObjectPropertyAssertionAxioms(i), p).isEmpty();
    }

    public static boolean hasNegativeObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.hasNegativeObjectPropertyValues(i, p, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDataPropertyValue(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull OWLLiteral lit, @Nonnull OWLOntology ontology) {
        return Searcher.values(ontology.getDataPropertyAssertionAxioms(i), p).contains(lit);
    }

    public static boolean hasDataPropertyValue(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull OWLLiteral lit, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.hasDataPropertyValue(i, p, lit, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasObjectPropertyValue(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull OWLIndividual j, @Nonnull OWLOntology ontology) {
        return Searcher.values(ontology.getObjectPropertyAssertionAxioms(i), p).contains(j);
    }

    public static boolean hasObjectPropertyValue(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull OWLIndividual j, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.hasObjectPropertyValue(i, p, j, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNegativeDataPropertyValue(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull OWLLiteral lit, @Nonnull OWLOntology ontology) {
        return Searcher.negValues(ontology.getNegativeDataPropertyAssertionAxioms(i), p).contains(lit);
    }

    public static boolean hasNegativeDataPropertyValue(@Nonnull OWLIndividual i, @Nonnull OWLDataPropertyExpression p, @Nonnull OWLLiteral lit, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.hasNegativeDataPropertyValue(i, p, lit, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNegativeObjectPropertyValue(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull OWLIndividual j, @Nonnull OWLOntology ontology) {
        return Searcher.negValues(ontology.getNegativeObjectPropertyAssertionAxioms(i), p).contains(j);
    }

    public static boolean hasNegativeObjectPropertyValue(@Nonnull OWLIndividual i, @Nonnull OWLObjectPropertyExpression p, @Nonnull OWLIndividual j, @Nonnull Iterable<OWLOntology> ontologies) {
        for (OWLOntology o : ontologies) {
            assert (o != null);
            if (!EntitySearcher.hasNegativeObjectPropertyValue(i, p, j, o)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static Multimap<OWLDataPropertyExpression, OWLLiteral> getDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLOntology ontology) {
        LinkedListMultimap<OWLDataPropertyExpression, OWLLiteral> map = LinkedListMultimap.create();
        for (OWLDataPropertyAssertionAxiom ax : ontology.getDataPropertyAssertionAxioms(i)) {
            map.put((OWLDataPropertyExpression)ax.getProperty(), (OWLLiteral)ax.getObject());
        }
        return map;
    }

    @Nonnull
    public static Multimap<OWLDataPropertyExpression, OWLLiteral> getDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull Iterable<OWLOntology> ontologies) {
        LinkedListMultimap<OWLDataPropertyExpression, OWLLiteral> collection = LinkedListMultimap.create();
        assert (collection != null);
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.putAll(EntitySearcher.getDataPropertyValues(i, o));
        }
        return collection;
    }

    @Nonnull
    public static Multimap<OWLObjectPropertyExpression, OWLIndividual> getObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLOntology ontology) {
        LinkedListMultimap<OWLObjectPropertyExpression, OWLIndividual> map = LinkedListMultimap.create();
        for (OWLObjectPropertyAssertionAxiom ax : ontology.getObjectPropertyAssertionAxioms(i)) {
            map.put((OWLObjectPropertyExpression)ax.getProperty(), (OWLIndividual)ax.getObject());
        }
        return map;
    }

    @Nonnull
    public static Multimap<OWLObjectPropertyExpression, OWLIndividual> getObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull Iterable<OWLOntology> ontologies) {
        LinkedListMultimap<OWLObjectPropertyExpression, OWLIndividual> map = LinkedListMultimap.create();
        for (OWLOntology o : ontologies) {
            map.putAll(EntitySearcher.getObjectPropertyValues(i, o));
        }
        return map;
    }

    @Nonnull
    public static Multimap<OWLObjectPropertyExpression, OWLIndividual> getNegativeObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLOntology ontology) {
        LinkedListMultimap<OWLObjectPropertyExpression, OWLIndividual> map = LinkedListMultimap.create();
        for (OWLNegativeObjectPropertyAssertionAxiom ax : ontology.getNegativeObjectPropertyAssertionAxioms(i)) {
            map.put((OWLObjectPropertyExpression)ax.getProperty(), (OWLIndividual)ax.getObject());
        }
        return map;
    }

    @Nonnull
    public static Multimap<OWLDataPropertyExpression, OWLLiteral> getNegativeDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull OWLOntology ontology) {
        LinkedListMultimap<OWLDataPropertyExpression, OWLLiteral> map = LinkedListMultimap.create();
        for (OWLNegativeDataPropertyAssertionAxiom ax : ontology.getNegativeDataPropertyAssertionAxioms(i)) {
            map.put((OWLDataPropertyExpression)ax.getProperty(), (OWLLiteral)ax.getObject());
        }
        return map;
    }

    @Nonnull
    public static Multimap<OWLObjectPropertyExpression, OWLIndividual> getNegativeObjectPropertyValues(@Nonnull OWLIndividual i, @Nonnull Iterable<OWLOntology> ontologies) {
        LinkedListMultimap<OWLObjectPropertyExpression, OWLIndividual> map = LinkedListMultimap.create();
        for (OWLOntology o : ontologies) {
            map.putAll(EntitySearcher.getNegativeObjectPropertyValues(i, o));
        }
        return map;
    }

    @Nonnull
    public static Multimap<OWLDataPropertyExpression, OWLLiteral> getNegativeDataPropertyValues(@Nonnull OWLIndividual i, @Nonnull Iterable<OWLOntology> ontologies) {
        LinkedListMultimap<OWLDataPropertyExpression, OWLLiteral> map = LinkedListMultimap.create();
        for (OWLOntology o : ontologies) {
            map.putAll(EntitySearcher.getNegativeDataPropertyValues(i, o));
        }
        return map;
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getInverses(@Nonnull OWLObjectPropertyExpression e, @Nonnull OWLOntology ontology) {
        return Searcher.inverse(ontology.getInverseObjectPropertyAxioms(e), e);
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> getInverses(@Nonnull OWLObjectPropertyExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLObjectPropertyExpression> collection = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            collection.addAll(EntitySearcher.getInverses(e, o));
        }
        return collection;
    }

    @Nonnull
    public static Collection<OWLIndividual> getInstances(@Nonnull OWLClassExpression e, @Nonnull OWLOntology ontology) {
        return Searcher.instances(ontology.getClassAssertionAxioms(e));
    }

    @Nonnull
    public static Collection<OWLIndividual> getInstances(@Nonnull OWLClassExpression e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLIndividual> list = new ArrayList<OWLIndividual>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            list.addAll(EntitySearcher.getInstances(e, o));
        }
        return list;
    }

    @Nonnull
    public static Collection<OWLClassExpression> getTypes(@Nonnull OWLIndividual e, @Nonnull OWLOntology ontology) {
        return Searcher.types(ontology.getClassAssertionAxioms(e));
    }

    @Nonnull
    public static Collection<OWLClassExpression> getTypes(@Nonnull OWLIndividual e, @Nonnull Iterable<OWLOntology> ontologies) {
        ArrayList<OWLClassExpression> list = new ArrayList<OWLClassExpression>();
        for (OWLOntology o : ontologies) {
            assert (o != null);
            list.addAll(EntitySearcher.getTypes(e, o));
        }
        return list;
    }
}

