/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.search.DomainVisitor;
import org.semanticweb.owlapi.search.EquivalentVisitor;
import org.semanticweb.owlapi.search.RangeVisitor;
import org.semanticweb.owlapi.search.SupSubVisitor;

public final class Searcher {
    private Searcher() {
    }

    @Nonnull
    public static Collection<OWLLiteral> values(@Nonnull Collection<OWLDataPropertyAssertionAxiom> axioms, @Nullable OWLDataPropertyExpression p) {
        HashSet<OWLLiteral> literals = new HashSet<OWLLiteral>();
        for (OWLDataPropertyAssertionAxiom ax : axioms) {
            if (p != null && !((OWLDataPropertyExpression)ax.getProperty()).equals(p)) continue;
            literals.add((OWLLiteral)ax.getObject());
        }
        return literals;
    }

    @Nonnull
    public static Collection<OWLIndividual> values(@Nonnull Collection<OWLObjectPropertyAssertionAxiom> axioms, @Nullable OWLObjectPropertyExpression p) {
        HashSet<OWLIndividual> objects = new HashSet<OWLIndividual>();
        for (OWLObjectPropertyAssertionAxiom ax : axioms) {
            if (p != null && !((OWLObjectPropertyExpression)ax.getProperty()).equals(p)) continue;
            objects.add((OWLIndividual)ax.getObject());
        }
        return objects;
    }

    @Nonnull
    public static Collection<OWLLiteral> negValues(@Nonnull Collection<OWLNegativeDataPropertyAssertionAxiom> axioms, @Nullable OWLDataPropertyExpression p) {
        HashSet<OWLLiteral> literals = new HashSet<OWLLiteral>();
        for (OWLNegativeDataPropertyAssertionAxiom ax : axioms) {
            if (p != null && !((OWLDataPropertyExpression)ax.getProperty()).equals(p)) continue;
            literals.add((OWLLiteral)ax.getObject());
        }
        return literals;
    }

    @Nonnull
    public static Collection<OWLIndividual> negValues(@Nonnull Collection<OWLNegativeObjectPropertyAssertionAxiom> axioms, @Nullable OWLObjectPropertyExpression p) {
        HashSet<OWLIndividual> objects = new HashSet<OWLIndividual>();
        for (OWLNegativeObjectPropertyAssertionAxiom ax : axioms) {
            if (p != null && !((OWLObjectPropertyExpression)ax.getProperty()).equals(p)) continue;
            objects.add((OWLIndividual)ax.getObject());
        }
        return objects;
    }

    @Nonnull
    public static Collection<OWLClassExpression> types(@Nonnull Collection<OWLClassAssertionAxiom> axioms) {
        HashSet<OWLClassExpression> objects = new HashSet<OWLClassExpression>();
        for (OWLClassAssertionAxiom ax : axioms) {
            objects.add(ax.getClassExpression());
        }
        return objects;
    }

    @Nonnull
    public static Collection<OWLIndividual> instances(@Nonnull Collection<OWLClassAssertionAxiom> axioms) {
        HashSet<OWLIndividual> objects = new HashSet<OWLIndividual>();
        for (OWLClassAssertionAxiom ax : axioms) {
            objects.add(ax.getIndividual());
        }
        return objects;
    }

    @Nonnull
    public static Collection<OWLObjectPropertyExpression> inverse(@Nonnull Collection<OWLInverseObjectPropertiesAxiom> axioms, @Nonnull OWLObjectPropertyExpression p) {
        ArrayList<OWLObjectPropertyExpression> toReturn = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLInverseObjectPropertiesAxiom ax : axioms) {
            if (ax.getFirstProperty().equals(p)) {
                toReturn.add(ax.getSecondProperty());
                continue;
            }
            toReturn.add(ax.getFirstProperty());
        }
        return toReturn;
    }

    @Nonnull
    public static Collection<OWLAnnotationValue> values(@Nonnull Collection<OWLAnnotation> annotations) {
        return Searcher.values(annotations, null);
    }

    @Nonnull
    public static Collection<OWLAnnotationValue> values(@Nonnull Collection<OWLAnnotation> annotations, @Nullable OWLAnnotationProperty p) {
        HashSet<OWLAnnotationValue> toReturn = new HashSet<OWLAnnotationValue>();
        for (OWLAnnotation ax : annotations) {
            if (p != null && !ax.getProperty().equals(p)) continue;
            toReturn.add(ax.getValue());
        }
        return toReturn;
    }

    @Nonnull
    public static Collection<OWLAnnotation> annotations(@Nonnull Collection<? extends OWLAxiom> axioms) {
        return Searcher.annotations(axioms, null);
    }

    @Nonnull
    public static Collection<OWLAnnotation> annotationObjects(@Nonnull Collection<OWLAnnotationAssertionAxiom> axioms, @Nullable OWLAnnotationProperty p) {
        HashSet<OWLAnnotation> toReturn = new HashSet<OWLAnnotation>();
        for (OWLAnnotationAssertionAxiom ax : axioms) {
            assert (ax != null);
            OWLAnnotation c = ax.getAnnotation();
            if (p != null && !c.getProperty().equals(p)) continue;
            toReturn.add(c);
        }
        return toReturn;
    }

    @Nonnull
    public static Collection<OWLAnnotation> annotationObjects(@Nonnull Collection<OWLAnnotationAssertionAxiom> axioms) {
        HashSet<OWLAnnotation> toReturn = new HashSet<OWLAnnotation>();
        for (OWLAnnotationAssertionAxiom ax : axioms) {
            assert (ax != null);
            toReturn.add(ax.getAnnotation());
        }
        return toReturn;
    }

    public static OWLAnnotation annotationObject(@Nonnull OWLAnnotationAssertionAxiom axiom, @Nullable OWLAnnotationProperty p) {
        if (p == null || axiom.getProperty().equals(p)) {
            return axiom.getAnnotation();
        }
        return null;
    }

    @Nonnull
    public static Collection<OWLAnnotation> annotations(@Nonnull Collection<? extends OWLAxiom> axioms, @Nullable OWLAnnotationProperty p) {
        HashSet<OWLAnnotation> toReturn = new HashSet<OWLAnnotation>();
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            Set<OWLAnnotation> c = Searcher.annotations(oWLAxiom, p);
            toReturn.addAll(c);
        }
        return toReturn;
    }

    @Nonnull
    public static Set<OWLAnnotation> annotations(@Nonnull OWLAxiom axiom, @Nullable OWLAnnotationProperty p) {
        HashSet<OWLAnnotation> set = new HashSet<OWLAnnotation>();
        if (axiom instanceof OWLAnnotationAssertionAxiom) {
            OWLAnnotationAssertionAxiom ax = (OWLAnnotationAssertionAxiom)axiom;
            if (p == null || ax.getProperty().equals(p)) {
                set.add(ax.getAnnotation());
            }
        }
        if (p != null) {
            set.addAll(axiom.getAnnotations(p));
        } else {
            set.addAll(axiom.getAnnotations());
        }
        return set;
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> equivalent(@Nonnull Collection<? extends OWLAxiom> axioms) {
        return Searcher.equivalent(axioms, OWLObject.class);
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> equivalent(@Nonnull Collection<? extends OWLAxiom> axioms, @Nonnull Class<C> type) {
        HashSet<C> toReturn = new HashSet<C>();
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            Set<C> c = Searcher.equivalent(oWLAxiom);
            toReturn.addAll(c);
        }
        return toReturn;
    }

    @Nonnull
    public static <C extends OWLObject> Set<C> equivalent(@Nonnull OWLAxiom axiom) {
        return (Set)axiom.accept(new EquivalentVisitor(true));
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> different(@Nonnull Collection<? extends OWLAxiom> axioms) {
        return Searcher.different(axioms, OWLObject.class);
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> different(@Nonnull Collection<? extends OWLAxiom> axioms, @Nonnull Class<C> type) {
        HashSet<C> toReturn = new HashSet<C>();
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            Set<C> c = Searcher.different(oWLAxiom);
            toReturn.addAll(c);
        }
        return toReturn;
    }

    @Nonnull
    public static <C extends OWLObject> Set<C> different(@Nonnull OWLAxiom axiom) {
        return (Set)axiom.accept(new EquivalentVisitor(false));
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> sub(@Nonnull Collection<? extends OWLAxiom> axioms) {
        return Searcher.sub(axioms, OWLObject.class);
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> sub(@Nonnull Collection<? extends OWLAxiom> axioms, @Nonnull Class<C> type) {
        ArrayList<C> toReturn = new ArrayList<C>();
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            C c = Searcher.sub(oWLAxiom);
            toReturn.add(c);
        }
        return toReturn;
    }

    @Nonnull
    public static <C extends OWLObject> C sub(@Nonnull OWLAxiom axiom) {
        return (C)((OWLObject)axiom.accept(new SupSubVisitor(false)));
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> sup(@Nonnull Collection<? extends OWLAxiom> axioms, @Nonnull Class<C> type) {
        ArrayList<C> toReturn = new ArrayList<C>();
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            C c = Searcher.sup(oWLAxiom);
            toReturn.add(c);
        }
        return toReturn;
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> sup(@Nonnull Collection<? extends OWLAxiom> axioms) {
        return Searcher.sup(axioms, OWLObject.class);
    }

    @Nonnull
    public static <C extends OWLObject> C sup(@Nonnull OWLAxiom axiom) {
        return (C)((OWLObject)axiom.accept(new SupSubVisitor(true)));
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> domain(@Nonnull Collection<? extends OWLAxiom> axioms) {
        return Searcher.domain(axioms, OWLObject.class);
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> domain(@Nonnull Collection<? extends OWLAxiom> axioms, @Nonnull Class<C> type) {
        ArrayList<C> toReturn = new ArrayList<C>();
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            C c = Searcher.domain(oWLAxiom);
            toReturn.add(c);
        }
        return toReturn;
    }

    @Nonnull
    public static <C extends OWLObject> C domain(@Nonnull OWLAxiom axiom) {
        return (C)((OWLObject)axiom.accept(new DomainVisitor()));
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> range(@Nonnull Collection<? extends OWLAxiom> axioms) {
        return Searcher.range(axioms, OWLObject.class);
    }

    @Nonnull
    public static <C extends OWLObject> Collection<C> range(@Nonnull Collection<? extends OWLAxiom> axioms, @Nonnull Class<C> type) {
        ArrayList<C> toReturn = new ArrayList<C>();
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            C c = Searcher.range(oWLAxiom);
            toReturn.add(c);
        }
        return toReturn;
    }

    @Nonnull
    public static <C extends OWLObject> C range(@Nonnull OWLAxiom axiom) {
        return (C)((OWLObject)axiom.accept(new RangeVisitor()));
    }

    @Nonnull
    public static Collection<IRI> ontologyIRIs(Iterable<OWLOntology> ontologies) {
        ArrayList<OWLOntologyID> list = new ArrayList<OWLOntologyID>();
        for (OWLOntology o : ontologies) {
            list.add(o.getOntologyID());
        }
        return Searcher.ontologyIRIs(list);
    }

    @Nonnull
    public static Collection<IRI> ontologyIRIs(Collection<OWLOntologyID> ids) {
        ArrayList<IRI> list = new ArrayList<IRI>();
        for (OWLOntologyID id : ids) {
            if (!id.getOntologyIRI().isPresent()) continue;
            list.add(id.getOntologyIRI().get());
        }
        return list;
    }
}

