/*
 * Decompiled with CFR 0.152.
 */
package owltools.ncbi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import owltools.ncbi.NCBIConverter;
import owltools.ncbi.NCBIOWL;

public class NCBI2OWL
extends NCBIConverter {
    protected static final Logger logger = Logger.getLogger(NCBI2OWL.class);
    protected static String usage = "usage: ncbi-converter [-ca] <input.dat> <output.owl> [axioms.txt] [-m [merged.dmp]] [-t [taxdmp.zip]] [-n [names.dmp]] [-l [citations.dmp]]\n\n       -c   Convert to OWL.\n       -a   Print axiom list.\n       -ca  Convert and print axiom list.\n       -m   Extract alternate identifier information from the given merged.dmp file.\n       -t   Extract alternate identifier, unique name, and citation information from the taxdmp.zip file.\n       -n   Extract unique name information from given names.dmp file.\n       -l   Extract literature citation information from the given citation.dmp file\n";

    public static void main(String[] args) {
        try {
            File outputFile;
            File inputFile;
            boolean printAxioms = false;
            boolean checkAxioms = false;
            String inputDat = null;
            String mergedDmp = null;
            String namesDmp = null;
            String citationDmp = null;
            String taxdmp = null;
            String outputOwl = null;
            String axiomFile = "axioms.txt";
            for (int i = 0; i < args.length; ++i) {
                String current = args[i];
                if (current.charAt(0) == '-') {
                    if ("-ca".equals(current)) {
                        printAxioms = true;
                    }
                    if ("-a".equals(current)) {
                        checkAxioms = true;
                        continue;
                    }
                    if ("-c".equals(current)) continue;
                    if ("-m".equals(current)) {
                        if (i + 1 < args.length) {
                            mergedDmp = args[++i];
                            continue;
                        }
                        mergedDmp = "merged.dmp";
                        continue;
                    }
                    if ("-n".equals(current)) {
                        if (i + 1 < args.length) {
                            namesDmp = args[++i];
                            continue;
                        }
                        namesDmp = "names.dmp";
                        continue;
                    }
                    if ("-l".equals(current)) {
                        if (i + 1 < args.length) {
                            citationDmp = args[++i];
                            continue;
                        }
                        citationDmp = "citations.dmp";
                        continue;
                    }
                    if ("-t".equals(current)) {
                        if (i + 1 < args.length) {
                            taxdmp = args[++i];
                            continue;
                        }
                        taxdmp = "taxdmp.zip";
                        continue;
                    }
                    NCBI2OWL.error("unknown option: " + current);
                    return;
                }
                if (inputDat == null) {
                    inputDat = current;
                    continue;
                }
                if (outputOwl == null) {
                    outputOwl = current;
                    continue;
                }
                if (printAxioms) {
                    axiomFile = current;
                    continue;
                }
                NCBI2OWL.error("Unexpected number of input parameters.");
                return;
            }
            if (inputDat == null) {
                inputDat = "taxonomy.dat";
            }
            if (!(inputFile = new File(inputDat)).exists()) {
                NCBI2OWL.error("The specified input file doesn't exist: " + inputDat);
                return;
            }
            if (!inputFile.isFile()) {
                NCBI2OWL.error("The specified input file is not a file: " + inputDat);
                return;
            }
            if (!inputFile.canRead()) {
                NCBI2OWL.error("The specified input file can't be read, please check the permissions: " + inputDat);
                return;
            }
            if (outputOwl == null) {
                outputOwl = "ncbitaxon.owl";
            }
            if ((outputFile = new File(outputOwl)).isDirectory()) {
                NCBI2OWL.error("The specified output file is a directory: " + outputOwl);
                return;
            }
            if (outputFile.exists() && !outputFile.canWrite()) {
                NCBI2OWL.error("The specified output file can't be over written, please check the permissions: " + outputOwl);
                return;
            }
            if (checkAxioms) {
                NCBI2OWL.checkAxioms(inputDat, outputOwl);
            } else {
                InputStream mergeInfo = null;
                if (mergedDmp != null) {
                    mergeInfo = new FileInputStream(mergedDmp);
                } else if (taxdmp != null) {
                    ZipFile zipFile = new ZipFile(taxdmp);
                    ZipEntry entry = zipFile.getEntry("merged.dmp");
                    mergeInfo = zipFile.getInputStream(entry);
                }
                InputStream citationInfo = null;
                if (citationDmp != null) {
                    citationInfo = new FileInputStream(citationDmp);
                } else if (taxdmp != null) {
                    ZipFile zipFile = new ZipFile(taxdmp);
                    ZipEntry entry = zipFile.getEntry("citations.dmp");
                    citationInfo = zipFile.getInputStream(entry);
                }
                Map<String, String> uniqueNames = null;
                if (namesDmp != null) {
                    uniqueNames = NCBI2OWL.loadUniqueNames(new FileInputStream(namesDmp));
                } else if (taxdmp != null) {
                    ZipFile zipFile = new ZipFile(taxdmp);
                    ZipEntry entry = zipFile.getEntry("names.dmp");
                    uniqueNames = NCBI2OWL.loadUniqueNames(zipFile.getInputStream(entry));
                }
                OWLOntology ontology = NCBI2OWL.convertToOWL(inputDat, outputOwl, mergeInfo, citationInfo, uniqueNames);
                if (printAxioms) {
                    NCBI2OWL.printAxioms(ontology, axiomFile);
                }
            }
        }
        catch (Exception e) {
            NCBI2OWL.error(e.getMessage());
        }
    }

    public static void error(String msg) {
        System.err.println("Error: " + msg);
        System.err.println();
        System.err.println(usage);
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OWLOntology convertToOWL(String inputPath, Map<String, String> uniqueNames) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException {
        OWLOntology ontology = NCBIOWL.createOWLOntology();
        File file = new File(inputPath);
        FileInputStream fis = new FileInputStream(file);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fis));){
            String line;
            SimpleDateFormat day = new SimpleDateFormat("yyyy-MM-dd");
            String date = day.format(file.lastModified());
            NCBI2OWL.annotate(ontology, "owl:versionIRI", IRI.create("http://purl.obolibrary.org/obo/ncbitaxon/" + date + "/ncbitaxon.owl"));
            HashMap<String, List<OWLClass>> labels = new HashMap<String, List<OWLClass>>();
            OWLClass taxon = null;
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                taxon = NCBI2OWL.handleLine(ontology, labels, taxon, line, lineNumber);
                if (++lineNumber % 10000 != 0) continue;
                logger.debug("At line " + lineNumber);
            }
            logger.debug("Resolving duplicate label issues");
            for (Map.Entry entry : labels.entrySet()) {
                List classes = (List)entry.getValue();
                if (classes.size() <= 1) continue;
                String originalLabel = (String)entry.getKey();
                Map<OWLClass, String> newLabels = NCBI2OWL.createUniqueLabels(classes, originalLabel, uniqueNames);
                for (OWLClass owlClass : newLabels.keySet()) {
                    String newLabel = newLabels.get(owlClass);
                    NCBI2OWL.updateAnnotation(ontology, owlClass, "rdfs:label", newLabel);
                    NCBI2OWL.synonym(ontology, (OWLEntity)owlClass, "ncbitaxon:scientific_name", "oio:hasExactSynonym", originalLabel);
                }
            }
            logger.debug("Finished reading lines: " + lineNumber);
            logger.debug("Filled ontology. Axioms: " + ontology.getAxiomCount());
            OWLOntology oWLOntology = ontology;
            return oWLOntology;
        }
    }

    private static Map<OWLClass, String> createUniqueLabels(List<OWLClass> classes, String label, Map<String, String> uniqueNames) {
        HashMap<OWLClass, String> newLabels = new HashMap<OWLClass, String>();
        if (uniqueNames != null) {
            String unique;
            String id;
            int nullCount = 0;
            for (OWLClass cls : classes) {
                id = NCBI2OWL.getTaxonID(cls);
                unique = uniqueNames.get(id);
                if (unique != null) continue;
                ++nullCount;
            }
            if (nullCount <= 1) {
                for (OWLClass cls : classes) {
                    id = NCBI2OWL.getTaxonID(cls);
                    unique = uniqueNames.get(id);
                    if (unique == null) continue;
                    newLabels.put(cls, unique);
                }
            } else {
                for (OWLClass cls : classes) {
                    id = NCBI2OWL.getTaxonID(cls);
                    unique = uniqueNames.get(id);
                    if (unique != null) {
                        newLabels.put(cls, unique);
                        continue;
                    }
                    newLabels.put(cls, label + " [NCBITaxon:" + id + "]");
                }
            }
        } else {
            for (OWLClass cls : classes) {
                String id = NCBI2OWL.getTaxonID(cls);
                newLabels.put(cls, label + " [NCBITaxon:" + id + "]");
            }
        }
        return newLabels;
    }

    public static OWLOntology convertToOWL(String inputPath, String outputPath, Map<String, String> uniqueNames) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException {
        return NCBI2OWL.convertToOWL(inputPath, outputPath, null, null, uniqueNames);
    }

    public static OWLOntology convertToOWL(String inputPath, String outputPath, InputStream mergeInfo, InputStream citationInfo, Map<String, String> uniqueNames) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException {
        File outputFile = new File(outputPath);
        IRI outputIRI = IRI.create(outputFile);
        OWLOntology ontology = NCBI2OWL.convertToOWL(inputPath, uniqueNames);
        if (mergeInfo != null) {
            NCBI2OWL.addAltIds(ontology, mergeInfo);
        }
        if (citationInfo != null) {
            NCBI2OWL.addCitationInfo(ontology, citationInfo);
        }
        logger.debug("Saving ontology...");
        ontology.getOWLOntologyManager().saveOntology(ontology, outputIRI);
        return ontology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> loadUniqueNames(InputStream nameInfo) throws IOException {
        HashMap<String, String> uniqueNames = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(nameInfo));){
            String line;
            while ((line = reader.readLine()) != null) {
                List<String> split = NCBI2OWL.splitDmpLine(line);
                if (split == null || split.size() <= 3) continue;
                String id = split.get(0);
                String uniqueName = split.get(2);
                String type = split.get(3);
                if (id == null || uniqueName == null || type == null || !"scientific name".equals(type)) continue;
                uniqueNames.put(id, uniqueName);
            }
        }
        return uniqueNames;
    }

    static List<String> splitDmpLine(String line) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if ('|' != c) continue;
            String field = line.substring(start, i);
            int length = (field = field.trim()).length();
            if (length == 0 || length == 1 && Character.isWhitespace(field.charAt(0))) {
                field = null;
            }
            list.add(field);
            start = i + 1;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCitationInfo(OWLOntology ontology, InputStream citationInfo) throws IOException {
        logger.debug("Adding citation information.");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(citationInfo));){
            String line;
            while ((line = reader.readLine()) != null) {
                List<String> split = NCBI2OWL.splitDmpLine(line);
                if (split == null || split.size() < 7) continue;
                String pubmed_id = split.get(2);
                String medline_id = split.get(3);
                String taxon_list = split.get(6);
                if (pubmed_id == null && medline_id == null || taxon_list == null) continue;
                String value = null;
                if (pubmed_id != null && !"0".equals(pubmed_id)) {
                    value = pubmed_id;
                } else if (medline_id != null && !"0".equals(medline_id)) {
                    value = medline_id;
                }
                if (value == null) continue;
                for (String taxon : NCBI2OWL.splitTaxonList(taxon_list)) {
                    IRI iri = NCBI2OWL.createNCBIIRI(taxon);
                    OWLClass cls = ontology.getOWLOntologyManager().getOWLDataFactory().getOWLClass(iri);
                    if (ontology.getDeclarationAxioms(cls).isEmpty()) continue;
                    NCBI2OWL.annotate(ontology, (OWLEntity)cls, "oio:hasDbXref", "PMID:" + value);
                }
            }
        }
    }

    static List<String> splitTaxonList(String string) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            String substring = string.substring(start, i);
            if (substring.length() > 0) {
                list.add(substring);
            }
            start = i + 1;
        }
        if (start < string.length() - 1) {
            list.add(string.substring(start));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAltIds(OWLOntology ontology, InputStream mergeInfo) throws IOException {
        logger.debug("Adding alternative identifiers from merge information.");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(mergeInfo));){
            String line;
            OWLAnnotationProperty ap = NCBIOWL.setupAltIdProperty(ontology);
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String altIdString = null;
                String merged = null;
                if (line.length() >= 4) {
                    int start = 0;
                    for (int i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if ('|' == c) {
                            if (start == 0) {
                                altIdString = line.substring(start, i);
                                start = i + 1;
                                continue;
                            }
                            merged = line.substring(start, i);
                            break;
                        }
                        if (!Character.isWhitespace(c) && !Character.isDigit(c)) break;
                    }
                }
                if (altIdString != null && merged != null) {
                    NCBIOWL.addAltId(ontology, merged, altIdString, ap);
                    continue;
                }
                logger.warn("Could not parse line in merge info: " + line);
            }
        }
    }

    protected static OWLClass handleLine(OWLOntology ontology, Map<String, List<OWLClass>> labels, OWLClass taxon, String line, int lineNumber) {
        if (line.trim().equals("//")) {
            return taxon;
        }
        String[] result = NCBI2OWL.parseLine(line, lineNumber);
        if (result == null) {
            return taxon;
        }
        String fieldName = result[0];
        String fieldValue = result[1];
        if (fieldName.equals("id")) {
            if (taxon != null) {
                NCBI2OWL.checkTaxon(ontology, taxon);
            }
            return NCBI2OWL.createTaxon(ontology, fieldValue);
        }
        if (taxon == null) {
            logger.error("Null taxon for line " + lineNumber + ": " + line);
            return null;
        }
        if (fieldName.equals("parent id")) {
            if (!fieldValue.equals("0")) {
                NCBI2OWL.assertSubClass(ontology, taxon, fieldValue);
            }
        } else if (fieldName.equals("rank")) {
            if (!fieldValue.equals("no rank")) {
                String name = NCBI2OWL.reformatName(fieldValue);
                NCBI2OWL.annotate(ontology, (OWLEntity)taxon, "ncbitaxon:has_rank", (OWLAnnotationValue)IRI.create("http://purl.obolibrary.org/obo/NCBITaxon_" + name));
                if (!NCBIOWL.ranks.contains(fieldValue)) {
                    logger.warn("Unrecognized RANK '" + fieldValue + "' on line " + lineNumber);
                }
            }
        } else if (fieldName.equals("scientific name")) {
            String label = fieldValue;
            NCBI2OWL.annotate(ontology, (OWLEntity)taxon, "rdfs:label", label);
            List<OWLClass> classes = labels.get(label);
            if (classes == null || classes.isEmpty()) {
                labels.put(label, Collections.singletonList(taxon));
            } else if (classes.size() == 1) {
                classes = new ArrayList<OWLClass>(classes);
                classes.add(taxon);
                labels.put(label, classes);
            } else {
                classes.add(taxon);
            }
        } else if (!fieldName.equals("includes")) {
            if (fieldName.equals("gc id")) {
                String value = "GC_ID:" + fieldValue;
                NCBI2OWL.annotate(ontology, (OWLEntity)taxon, "oio:hasDbXref", value);
            } else if (!fieldName.equals("mgc id")) {
                if (NCBIOWL.synonymTypes.containsKey(fieldName)) {
                    String typeCURIE = NCBI2OWL.reformatName("ncbitaxon:" + fieldName);
                    String propertyCURIE = NCBIOWL.synonymTypes.get(fieldName);
                    NCBI2OWL.synonym(ontology, (OWLEntity)taxon, typeCURIE, propertyCURIE, fieldValue);
                } else {
                    logger.error("Unknown field name '" + fieldName + "' for line " + lineNumber + ": " + line);
                }
            }
        }
        return taxon;
    }

    public static String[] parseLine(String line, int lineNumber) {
        String[] parts = line.split(":", 2);
        if (parts.length == 2 && parts[0].trim().length() > 0 && parts[1].trim().length() > 0) {
            return new String[]{parts[0].trim().toLowerCase(), parts[1].trim()};
        }
        logger.warn("Bad line " + lineNumber + ": " + line);
        return null;
    }

    public static void checkAxioms(String inputPath, String outputPath) throws IOException, OWLOntologyCreationException {
        File inputFile = new File(inputPath);
        OWLOntology ontology = NCBIOWL.loadOWLOntology(inputFile);
        logger.debug("Loaded ontology. Axioms: " + ontology.getAxiomCount());
        NCBI2OWL.printAxioms(ontology, outputPath);
    }

    public static void printAxioms(OWLOntology ontology, String outputPath) throws IOException {
        logger.debug("Printing axioms...");
        Set<OWLAxiom> axioms = ontology.getAxioms();
        Iterator<OWLAxiom> iterator = axioms.iterator();
        FileWriter fw = new FileWriter(outputPath);
        BufferedWriter bw = new BufferedWriter(fw);
        while (iterator.hasNext()) {
            OWLAxiom axiom = iterator.next();
            bw.write(axiom.toString() + "\n");
        }
        bw.close();
    }
}

